/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.logger.decorator;

import org.apache.avalon.excalibur.logger.LoggerManager;
import org.apache.avalon.excalibur.logger.decorator.LoggerManagerDecorator;
import org.apache.avalon.excalibur.logger.util.LoggerSwitch;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.avalon.framework.logger.Logger;

public class LogToSelfDecorator
extends LoggerManagerDecorator {
    private final String m_switchTo;
    private LoggerSwitch m_switch;
    private Logger m_logger;

    public LogToSelfDecorator(LoggerManager loggerManager, String switchTo) {
        super(loggerManager);
        if (switchTo == null) {
            throw new NullPointerException("switchTo");
        }
        this.m_switchTo = switchTo;
    }

    public void enableLogging(Logger logger) {
        if (this.m_switch != null) {
            throw new IllegalStateException("enableLogging() already called");
        }
        if (logger == null) {
            throw new NullPointerException("logger");
        }
        this.m_switch = new LoggerSwitch(logger);
        this.m_logger = this.m_switch.get();
        ContainerUtil.enableLogging((Object)this.m_loggerManager, (Logger)this.m_logger);
    }

    public void start() throws Exception {
        String message;
        super.start();
        Logger preferred = this.m_loggerManager.getLoggerForCategory(this.m_switchTo);
        if (this.m_logger.isDebugEnabled()) {
            message = "LogToSelfDecorator: switching logging to '" + this.m_switchTo + "'";
            this.m_logger.debug(message);
        }
        this.m_switch.setPreferred(preferred);
        if (this.m_logger.isDebugEnabled()) {
            message = "Have switched logging to '" + this.m_switchTo + "'";
            this.m_logger.debug(message);
        }
    }
}

