/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.Hits;

public class LuceneCocoonPager
implements ListIterator {
    public static final int COUNT_OF_HITS_PER_PAGE_DEFAULT = 5;
    public static final int HITS_INDEX_START_DEFAULT = 0;
    int hitsIndex = 0;
    int countOfHitsPerPage = 5;
    private Hits hits;

    public LuceneCocoonPager(Hits hits) {
        this.setHits(hits);
    }

    public LuceneCocoonPager() {
    }

    public void setHits(Hits hits) {
        this.hits = hits;
        this.hitsIndex = 0;
    }

    public void setCountOfHitsPerPage(int countOfHitsPerPage) {
        this.countOfHitsPerPage = countOfHitsPerPage;
        if (this.countOfHitsPerPage <= 0) {
            this.countOfHitsPerPage = 1;
        }
    }

    public void setStartIndex(int start_index) {
        this.hitsIndex = start_index;
    }

    public void set(Object o) {
        throw new UnsupportedOperationException();
    }

    public int getCountOfHits() {
        return this.hits.length();
    }

    public int getCountOfHitsPerPage() {
        return this.countOfHitsPerPage;
    }

    public int getCountOfPages() {
        int count_of_pages = this.hits.length() / this.countOfHitsPerPage;
        int remainder = this.hits.length() % this.countOfHitsPerPage;
        if (remainder != 0) {
            ++count_of_pages;
        }
        return count_of_pages;
    }

    public int getStartIndex() {
        return this.hitsIndex;
    }

    public void add(Object o) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public boolean hasNext() {
        return this.hitsIndex < this.hits.length();
    }

    public boolean hasPrevious() {
        return this.hitsIndex > this.countOfHitsPerPage;
    }

    public Object next() {
        ArrayList<HitWrapper> hitsPerPageList = new ArrayList<HitWrapper>();
        int endIndex = Math.min(this.hits.length(), this.hitsIndex + this.countOfHitsPerPage);
        if (this.hitsIndex < endIndex) {
            while (this.hitsIndex < endIndex) {
                try {
                    HitWrapper hit = new HitWrapper(this.hits.score(this.hitsIndex), this.hits.doc(this.hitsIndex));
                    hitsPerPageList.add(hit);
                }
                catch (IOException ioe) {
                    throw new NoSuchElementException("no more hits: " + ioe.getMessage());
                }
                ++this.hitsIndex;
            }
        } else {
            throw new NoSuchElementException();
        }
        return hitsPerPageList;
    }

    public int nextIndex() {
        return Math.min(this.hitsIndex, this.hits.length());
    }

    public Object previous() {
        int endIndex;
        ArrayList<HitWrapper> hitsPerPageList = new ArrayList<HitWrapper>();
        int startIndex = Math.max(0, this.hitsIndex - 2 * this.countOfHitsPerPage);
        if (startIndex < (endIndex = Math.min(this.hits.length() - 1, this.hitsIndex - this.countOfHitsPerPage))) {
            while (startIndex < endIndex) {
                try {
                    HitWrapper hit = new HitWrapper(this.hits.score(startIndex), this.hits.doc(startIndex));
                    hitsPerPageList.add(hit);
                }
                catch (IOException ioe) {
                    throw new NoSuchElementException("no more hits: " + ioe.getMessage());
                }
                ++startIndex;
            }
        } else {
            throw new NoSuchElementException();
        }
        this.hitsIndex = endIndex;
        return hitsPerPageList;
    }

    public int previousIndex() {
        return Math.max(0, this.hitsIndex - 2 * this.countOfHitsPerPage);
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public static class HitWrapper {
        float score;
        Document document;

        public HitWrapper(float score, Document document) {
            this.document = document;
            this.score = score;
        }

        public Document getDocument() {
            return this.document;
        }

        public float getScore() {
            return this.score;
        }

        public String getField(String field) {
            return this.document.get(field);
        }
    }
}

