/*
SDX: Documentary System in XML.
Copyright (C) 2000, 2001, 2002  Ministere de la culture et de la communication (France), AJLSM

Ministere de la culture et de la communication,
Mission de la recherche et de la technologie
3 rue de Valois, 75042 Paris Cedex 01 (France)
mrt@culture.fr, michel.bottin@culture.fr

AJLSM, 17, rue Vital Carles, 33000 Bordeaux (France)
sevigny@ajlsm.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
or connect to:
http://www.fsf.org/copyleft/gpl.html
*/
package fr.gouv.culture.sdx.user;

import fr.gouv.culture.sdx.document.XMLDocument;
import fr.gouv.culture.sdx.exception.SDXException;
import org.apache.avalon.framework.logger.LogEnabled;

/**
 * An abstract and simple implementation of an identity using an XML document.
 *
 * <p>
 * This abstract class takes care of the name and type methods. By extending XMLdocument,
 * it also takes care of most of the indexing process.
 */
public abstract class AbstractIdentity extends XMLDocument implements Identity, LogEnabled {

    /** The type of identity. */
    private int type;

    /** Creates an empty identity.
     * @throws SDXException if identity can not be built
     */
    public AbstractIdentity() throws SDXException {
        super();
    }

    /** Creates an identity with a given id.
     * @param id An id for the identity.
     * @throws SDXException if identity can not be built
     */
    public AbstractIdentity(String id) throws SDXException {
        super(id);
    }

    /** Returns the type of identity.
     * @deprecated Use {@link fr.gouv.culture.sdx.document.Document#getDoctype getDoctype()}
     * @return The type.
     */
    public int getType() {
        return this.type;
    }

    /**
     * Sets the type of this identity (@see ???).
     *
     * @param   type    The identity type.
     */
    public void setType(int type) {
        this.type = type;
    }


}
