/*
SDX: Documentary System in XML.
Copyright (C) 2000, 2001, 2002  Ministere de la culture et de la communication (France), AJLSM

Ministere de la culture et de la communication,
Mission de la recherche et de la technologie
3 rue de Valois, 75042 Paris Cedex 01 (France)
mrt@culture.fr, michel.bottin@culture.fr

AJLSM, 17, rue Vital Carles, 33000 Bordeaux (France)
sevigny@ajlsm.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
or connect to:
http://www.fsf.org/copyleft/gpl.html
*/
package fr.gouv.culture.sdx.utils.jvm;

import fr.gouv.culture.sdx.utils.Utilities;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;

/**
 * Created by IntelliJ IDEA.
 * User: rpandey
 * Date: 22 dc. 2003
 * Time: 13:21:23
 * To change this template use Options | File Templates.
 */
/*Class to be copied into parent 'jvm' package a build time for
 * java specific building (see build.xml, target:prepare-src-main)
 */

/**Utility class for java 1.4 url encoding/decoding support
 *
 */
public class URLCoderWrapper {

    public static String encode(String str, String encoding) throws UnsupportedEncodingException {
        String enc = encoding;
        if (!Utilities.checkString(enc))
            enc = System.getProperty("file.encoding");
        return URLEncoder.encode(str, enc);
    }

    public static String decode(String str, String encoding) throws UnsupportedEncodingException {
        String enc = encoding;
        if (!Utilities.checkString(enc))
            enc = System.getProperty("file.encoding");
        return URLDecoder.decode(str, enc);
    }
}
