/*
 * Created on 24 aot 2004
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package fr.gouv.culture.sdx.utils.save;

import fr.gouv.culture.sdx.exception.SDXException;

/**
 * @author jlecren
 *
 * This interface lets an object to save and restore its data.
 */
public interface Saveable {
	
	/**
	 * Constants to retrieve the save directory in the SaveParameters
	 */
	public final static String SAVE_DIRECTORY_PARAM = "save-directory";
	
	/**
	 * Attribute of the save configuration file
	 */
	public final static String ALL_SAVE_ATTRIB = "all";
	public final static String PATH_ATTRIB = "path";
	
	/**
	 * The backup method gives a way to an object to save its data
	 * @param save-config contains the save-directory and other options (among the implementations)
	 * @throws an SDXException if there is an error 
	 */
	public void backup(SaveParameters save_config) throws SDXException;
	
	/**
	 * The restore method gives a way to an object to restore its data from a backup.
	 * @param save_config
	 * @throws an SDXException if there is an error 
	 */
	public void restore(SaveParameters save_config) throws SDXException;

}
