/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.tree;

import com.icl.saxon.om.NamePool;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.output.Outputter;
import com.icl.saxon.tree.ElementImpl;
import com.icl.saxon.tree.NodeImpl;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Node;

final class NamespaceImpl
extends NodeImpl {
    private int nsCode;
    private int nameCode;
    private int index;

    public NamespaceImpl(ElementImpl elementImpl, int n, int n2) {
        this.parent = elementImpl;
        this.nsCode = n;
        NamePool namePool = this.getNamePool();
        this.nameCode = namePool.allocate("", "", namePool.getPrefixFromNamespaceCode(n));
        this.index = n2;
    }

    public int getNameCode() {
        return this.nameCode;
    }

    public int getNamespaceCode() {
        return this.nsCode;
    }

    public boolean isSameNode(NodeInfo nodeInfo) {
        if (!(nodeInfo instanceof NamespaceImpl)) {
            return false;
        }
        if (this == nodeInfo) {
            return true;
        }
        NamespaceImpl namespaceImpl = (NamespaceImpl)nodeInfo;
        return this.parent.isSameNode(namespaceImpl.parent) && this.nsCode == namespaceImpl.nsCode;
    }

    public String getLocalName() {
        return this.getNamePool().getPrefixFromNamespaceCode(this.nsCode);
    }

    public void setNamespaceCode(int n) {
        NamePool namePool = this.getNamePool();
        this.nsCode = n;
        this.nameCode = namePool.allocate("", "", namePool.getPrefixFromNamespaceCode(n));
    }

    public final short getNodeType() {
        return 13;
    }

    public String getStringValue() {
        return this.getNamePool().getURIFromNamespaceCode(this.nsCode);
    }

    public String getNodeName() {
        return this.getLocalName();
    }

    public Node getNextSibling() {
        return null;
    }

    public Node getPreviousSibling() {
        return null;
    }

    public NodeImpl getPreviousInDocument() {
        return (NodeImpl)this.getParent();
    }

    public NodeImpl getNextInDocument(NodeImpl nodeImpl) {
        if (this == nodeImpl) {
            return null;
        }
        return ((NodeImpl)this.getParent()).getNextInDocument(nodeImpl);
    }

    public String generateId() {
        return this.parent.generateId() + "_xmlns_" + this.getLocalName();
    }

    public void copy(Outputter outputter) throws TransformerException {
        outputter.copyNamespaceNode(this.nsCode);
    }

    protected long getSequenceNumber() {
        return this.parent.getSequenceNumber() + (long)this.index;
    }
}

