/*
 * Decompiled with CFR 0.152.
 */
package org.xmldb.api;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Database;
import org.xmldb.api.base.XMLDBException;

public class DatabaseManager {
    protected static final String URI_PREFIX = "xmldb:";
    static Properties properties = new Properties();
    static Hashtable databases = new Hashtable();

    public static Database[] getDatabases() {
        Enumeration enumeration = databases.elements();
        Database[] databaseArray = new Database[databases.size()];
        int n = 0;
        while (enumeration.hasMoreElements()) {
            databaseArray[n] = (Database)enumeration.nextElement();
            ++n;
        }
        return databaseArray;
    }

    public static void registerDatabase(Database database) throws XMLDBException {
        if (database.getName() == null || database.getName().equals("")) {
            throw new XMLDBException(401);
        }
        databases.put(database.getName(), database);
    }

    public static void deregisterDatabase(Database database) throws XMLDBException {
        databases.remove(database.getName());
    }

    public static Collection getCollection(String string) throws XMLDBException {
        return DatabaseManager.getCollection(string, null, null);
    }

    public static Collection getCollection(String string, String string2, String string3) throws XMLDBException {
        Database database = DatabaseManager.getDatabase(string);
        string = DatabaseManager.stripURIPrefix(string);
        return database.getCollection(string, string2, string3);
    }

    public static String getConformanceLevel(String string) throws XMLDBException {
        Database database = DatabaseManager.getDatabase(string);
        return database.getConformanceLevel();
    }

    public static String getProperty(String string) {
        return properties.getProperty(string);
    }

    public static void setProperty(String string, String string2) {
        ((Hashtable)properties).put(string, string2);
    }

    protected static Database getDatabase(String string) throws XMLDBException {
        if (!string.startsWith(URI_PREFIX)) {
            throw new XMLDBException(5);
        }
        int n = string.indexOf(":", URI_PREFIX.length());
        if (n == -1) {
            throw new XMLDBException(5);
        }
        String string2 = string.substring(URI_PREFIX.length(), n);
        Database database = (Database)databases.get(string2);
        if (database == null) {
            throw new XMLDBException(400);
        }
        return database;
    }

    protected static String stripURIPrefix(String string) throws XMLDBException {
        if (!string.startsWith(URI_PREFIX)) {
            throw new XMLDBException(5);
        }
        String string2 = string.substring(URI_PREFIX.length(), string.length());
        return string2;
    }
}

