/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.mesa.rdf.jena.rdb;

import com.hp.hpl.mesa.rdf.jena.model.Literal;
import com.hp.hpl.mesa.rdf.jena.model.RDFException;
import com.hp.hpl.mesa.rdf.jena.model.RDFNode;
import com.hp.hpl.mesa.rdf.jena.model.Resource;
import com.hp.hpl.mesa.rdf.jena.rdb.IConstraints;
import com.hp.hpl.mesa.rdf.jena.rdb.IDBID;
import com.hp.hpl.mesa.rdf.jena.rdb.IRDBDriver;
import com.hp.hpl.mesa.rdf.jena.rdb.ModelRDB;
import com.hp.hpl.mesa.rdf.jena.rdb.RDFRDBException;
import com.hp.hpl.mesa.rdf.jena.rdb.ResultSetIterator;
import com.hp.hpl.mesa.rdf.jena.rdb.ResultSetStatementIterator;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class ConstraintsGeneric
implements IConstraints {
    protected PreparedStatement m_preparedSQL;
    protected Resource m_subject;
    protected Resource m_property;
    protected RDFNode m_object;
    protected boolean m_objectIsLiteral;
    protected String m_stringConstraint;
    protected ModelRDB m_model;

    public ConstraintsGeneric(ModelRDB modelRDB) {
        this.m_model = modelRDB;
    }

    public synchronized ResultSetIterator runQuery(IRDBDriver iRDBDriver, ModelRDB modelRDB) throws RDFException {
        try {
            if (this.m_preparedSQL == null) {
                StringBuffer stringBuffer = new StringBuffer(800);
                boolean bl = false;
                if (this.m_stringConstraint != null) {
                    String string = iRDBDriver.getSQLCache().getSQLStatement("listConstraint");
                    boolean bl2 = bl = string != null;
                    if (!bl) {
                        string = iRDBDriver.getSQLCache().getSQLStatement("list");
                    }
                    stringBuffer.append(string);
                } else {
                    stringBuffer.append(iRDBDriver.getSQLCache().getSQLStatement("list"));
                }
                if (this.m_subject != null) {
                    stringBuffer.append(" AND S.SUBJECT=?");
                }
                if (this.m_property != null) {
                    stringBuffer.append(" AND S.PREDICATE=?");
                }
                if (this.m_object != null) {
                    stringBuffer.append(" AND S.OBJECT=? AND S.OBJECT_ISLITERAL=");
                    stringBuffer.append(this.m_objectIsLiteral ? "1" : "0");
                } else if (this.m_stringConstraint != null) {
                    if (bl) {
                        stringBuffer.append(" AND S.OBJECT_ISLITERAL=1 AND S.OBJECT = RDF_LITERALS.ID AND " + this.m_stringConstraint);
                    } else {
                        stringBuffer.append(" AND S.OBJECT_ISLITERAL=1 AND S.OBJECT IN (SELECT ID FROM RDF_LITERALS WHERE " + this.m_stringConstraint + ")");
                    }
                }
                this.m_preparedSQL = iRDBDriver.getConnection().prepareStatement(stringBuffer.toString());
            }
            int n = 1;
            if (iRDBDriver.supportsMultipleModels()) {
                this.m_preparedSQL.setObject(n++, modelRDB.getDBID().getID());
            }
            if (this.m_subject != null) {
                IDBID iDBID = iRDBDriver.getResourceID(this.m_subject);
                if (iDBID == null) {
                    return new ResultSetIterator();
                }
                this.m_preparedSQL.setObject(n++, iDBID.getID());
            }
            if (this.m_property != null) {
                IDBID iDBID = iRDBDriver.getResourceID(this.m_property);
                if (iDBID == null) {
                    return new ResultSetIterator();
                }
                this.m_preparedSQL.setObject(n++, iDBID.getID());
            }
            if (this.m_object != null) {
                IDBID iDBID = null;
                iDBID = this.m_objectIsLiteral ? iRDBDriver.getLiteralID((Literal)this.m_object) : iRDBDriver.getResourceID((Resource)this.m_object);
                if (iDBID == null) {
                    return new ResultSetIterator();
                }
                this.m_preparedSQL.setObject(n++, iDBID.getID());
            }
            return iRDBDriver.getSQLCache().executeSQL(this.m_preparedSQL, null, new ResultSetStatementIterator(modelRDB, iRDBDriver));
        }
        catch (SQLException sQLException) {
            this.m_preparedSQL = null;
            throw new RDFRDBException("Problem formatting constrained query", (Exception)sQLException);
        }
    }

    public IConstraints addSubjectConstraint(Resource resource) throws RDFException {
        this.m_preparedSQL = null;
        this.m_subject = this.m_model.convert(resource);
        return this;
    }

    public IConstraints addPropertyConstraint(Resource resource) throws RDFException {
        this.m_preparedSQL = null;
        this.m_property = this.m_model.convert(resource);
        return this;
    }

    public IConstraints addObjectConstraint(Resource resource) throws RDFException {
        this.m_preparedSQL = null;
        this.m_object = this.m_model.convert(resource);
        this.m_objectIsLiteral = false;
        return this;
    }

    public IConstraints addObjectConstraint(Literal literal) throws RDFException {
        this.m_preparedSQL = null;
        this.m_object = this.m_model.convert(literal);
        this.m_objectIsLiteral = true;
        return this;
    }

    public IConstraints reset() {
        this.m_preparedSQL = null;
        this.m_subject = null;
        this.m_property = null;
        this.m_object = null;
        this.m_objectIsLiteral = false;
        this.m_stringConstraint = null;
        return this;
    }

    public IConstraints addStringConstraint(String string, String string2) {
        return this.doAddSqlConstraint("RDF_LITERALS.LITERAL_IDX " + string + " '" + string2 + "'");
    }

    protected IConstraints doAddSqlConstraint(String string) {
        this.m_preparedSQL = null;
        this.m_object = null;
        this.m_stringConstraint = this.m_stringConstraint == null ? string : this.m_stringConstraint + " AND " + string;
        this.m_objectIsLiteral = true;
        return this;
    }

    public IConstraints addIntConstraint(String string, int n) {
        return this.doAddSqlConstraint("RDF_LITERALS.INT_LITERAL " + string + " " + n + " AND RDF_LITERALS.INT_OK = 1");
    }
}

