/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.avalon.excalibur.cli.CLArgsParser;
import org.apache.avalon.excalibur.cli.CLOption;
import org.apache.avalon.excalibur.cli.CLOptionDescriptor;
import org.apache.avalon.excalibur.cli.CLUtil;
import org.apache.avalon.excalibur.logger.DefaultLogKitManager;
import org.apache.avalon.excalibur.logger.LogKitManager;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.DefaultContext;
import org.apache.cocoon.Cocoon;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.environment.commandline.CommandlineContext;
import org.apache.cocoon.environment.commandline.FileSavingEnvironment;
import org.apache.cocoon.environment.commandline.LinkSamplingEnvironment;
import org.apache.cocoon.util.IOUtils;
import org.apache.cocoon.util.MIMEUtils;
import org.apache.cocoon.util.NetUtils;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.apache.log.Priority;

public class Main {
    private static Logger log = null;
    protected static final int HELP_OPT = 104;
    protected static final int VERSION_OPT = 118;
    protected static final int LOG_KIT_OPT = 107;
    protected static final int LOGGER_OPT = 108;
    protected static final int LOG_LEVEL_OPT = 117;
    protected static final int CONTEXT_DIR_OPT = 99;
    protected static final int DEST_DIR_OPT = 100;
    protected static final int WORK_DIR_OPT = 119;
    protected static final int AGENT_OPT = 97;
    protected static final int ACCEPT_OPT = 112;
    protected static final int URI_FILE = 102;
    protected static final int FOLLOW_LINKS_OPT = 114;
    protected static final int CONFIG_FILE = 67;
    protected static final int BROKEN_LINK_FILE = 98;
    protected static final int PRECOMPILE_OPT = 80;
    protected static final String DEFAULT_USER_AGENT = "Apache Cocoon 2.0.4";
    protected static final String DEFAULT_ACCEPT = "text/html, */*";
    protected static final CLOptionDescriptor[] OPTIONS = new CLOptionDescriptor[]{new CLOptionDescriptor("brokenLinkFile", 2, 98, "send a list of broken links to a file (one URI per line)"), new CLOptionDescriptor("uriFile", 2, 102, "use a text file with uris to process (one URI per line)"), new CLOptionDescriptor("help", 8, 104, "print this message and exit"), new CLOptionDescriptor("version", 8, 118, "print the version information and exit"), new CLOptionDescriptor("logKitconfig", 2, 107, "use given file for LogKit Management configuration"), new CLOptionDescriptor("Logger", 2, 108, "use given logger category as default logger for the Cocoon engine"), new CLOptionDescriptor("logLevel", 2, 117, "choose the minimum log level for logging (DEBUG, INFO, WARN, ERROR, FATAL_ERROR) for startup logging"), new CLOptionDescriptor("contextDir", 2, 99, "use given dir as context"), new CLOptionDescriptor("destDir", 2, 100, "use given dir as destination"), new CLOptionDescriptor("workDir", 2, 119, "use given dir as working directory"), new CLOptionDescriptor("precompileOnly", 8, 80, "generate java code for xsp and xmap files"), new CLOptionDescriptor("userAgent", 2, 97, "use given string for user-agent header"), new CLOptionDescriptor("accept", 2, 112, "use given string for accept header"), new CLOptionDescriptor("followLinks", 2, 114, "process pages linked from starting page or not (boolean argument is expected, default is true)"), new CLOptionDescriptor("configFile", 2, 67, "specify alternate location of the configurationfile (default is ${contextDir}/cocoon.xconf)")};
    private Cocoon cocoon;
    private File destDir;
    private File context;
    private PrintWriter brokenLinkWriter;
    private Map attributes;
    private HashMap empty;
    private Map allProcessedLinks;
    private Map allTranslatedLinks;
    private String userAgent;
    private String accept;
    private boolean followLinks;
    static /* synthetic */ Class class$org$apache$cocoon$Main;

    public static void processFile(String filename, List uris) {
        try {
            BufferedReader uriFile = new BufferedReader(new FileReader(filename));
            boolean eof = false;
            while (!eof) {
                String uri = uriFile.readLine();
                if (null == uri) {
                    eof = true;
                    continue;
                }
                uris.add(NetUtils.normalize(uri.trim()));
            }
            uriFile.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) throws Exception {
        String error;
        String destDir = "./site";
        String contextDir = "./webapp";
        String configFile = null;
        File brokenLinkFile = null;
        String workDir = "./work";
        ArrayList<String> targets = new ArrayList<String>();
        CLArgsParser parser = new CLArgsParser(args, OPTIONS);
        String logKit = null;
        String logger = null;
        String logLevel = "DEBUG";
        boolean precompileOnly = false;
        String userAgent = DEFAULT_USER_AGENT;
        String accept = DEFAULT_ACCEPT;
        boolean followLinks = true;
        Vector clOptions = parser.getArguments();
        int size = clOptions.size();
        int i = 0;
        while (i < size) {
            CLOption option = (CLOption)clOptions.get(i);
            switch (option.getId()) {
                case 0: {
                    targets.add(NetUtils.normalize(option.getArgument()));
                    break;
                }
                case 67: {
                    configFile = option.getArgument();
                    break;
                }
                case 104: {
                    Main.printUsage();
                    break;
                }
                case 118: {
                    Main.printVersion();
                    break;
                }
                case 100: {
                    destDir = option.getArgument();
                    break;
                }
                case 119: {
                    workDir = option.getArgument();
                    break;
                }
                case 99: {
                    contextDir = option.getArgument();
                    break;
                }
                case 107: {
                    logKit = option.getArgument();
                    break;
                }
                case 108: {
                    logger = option.getArgument();
                    break;
                }
                case 117: {
                    logLevel = option.getArgument();
                    break;
                }
                case 80: {
                    precompileOnly = true;
                    break;
                }
                case 97: {
                    userAgent = option.getArgument();
                    break;
                }
                case 112: {
                    accept = option.getArgument();
                    break;
                }
                case 102: {
                    Main.processFile(option.getArgument(), targets);
                    break;
                }
                case 114: {
                    followLinks = "yes".equals(option.getArgument()) || "true".equals(option.getArgument());
                    break;
                }
                case 98: {
                    brokenLinkFile = new File(option.getArgument());
                }
            }
            ++i;
        }
        Priority priority = Priority.getPriorityForName((String)logLevel);
        Hierarchy.getDefaultHierarchy().setDefaultPriority(priority);
        log = Hierarchy.getDefaultHierarchy().getLoggerFor("");
        if (destDir.equals("")) {
            error = "Careful, you must specify a destination dir when using the -d/--destDir argument";
            log.fatalError(error);
            System.out.println(error);
            System.exit(1);
        }
        if (contextDir.equals("")) {
            error = "Careful, you must specify a configuration file when using the -c/--contextDir argument";
            log.error(error);
            System.out.println(error);
            System.exit(1);
        }
        if (workDir.equals("")) {
            error = "Careful, you must specify a destination dir when using the -w/--workDir argument";
            log.error(error);
            System.out.println(error);
            System.exit(1);
        }
        if (targets.size() == 0 && !precompileOnly) {
            error = "Please, specify at least one starting URI.";
            log.error(error);
            System.out.println(error);
            System.exit(1);
        }
        try {
            File dest = null;
            if (!precompileOnly) {
                dest = Main.getDir(destDir, "destination");
            }
            File work = Main.getDir(workDir, "working");
            File context = Main.getDir(contextDir, "context");
            File conf = null;
            if (null == configFile) {
                conf = Main.getConfigurationFile(context);
            } else {
                conf = new File(configFile);
                if (!conf.exists()) {
                    conf = new File(context, configFile);
                }
            }
            DefaultContext appContext = new DefaultContext();
            appContext.put((Object)"class-loader", (Object)(class$org$apache$cocoon$Main == null ? (class$org$apache$cocoon$Main = Main.class$("org.apache.cocoon.Main")) : class$org$apache$cocoon$Main).getClassLoader());
            CommandlineContext clContext = new CommandlineContext(contextDir);
            clContext.setLogger(log);
            appContext.put((Object)"environment-context", (Object)clContext);
            DefaultLogKitManager logKitManager = null;
            if (logKit != null) {
                FileInputStream fis = new FileInputStream(logKit);
                DefaultConfigurationBuilder builder = new DefaultConfigurationBuilder();
                Configuration logKitConf = builder.build((InputStream)fis);
                logKitManager = new DefaultLogKitManager(Hierarchy.getDefaultHierarchy());
                logKitManager.setLogger(log);
                DefaultContext subcontext = new DefaultContext((Context)appContext);
                subcontext.put((Object)"context-root", (Object)contextDir);
                logKitManager.contextualize((Context)subcontext);
                logKitManager.configure(logKitConf);
                log = logger != null ? logKitManager.getLogger(logger) : logKitManager.getLogger("cocoon");
            } else {
                logKitManager = new DefaultLogKitManager(Hierarchy.getDefaultHierarchy());
                logKitManager.setLogger(log);
            }
            appContext.put((Object)"classpath", (Object)Main.getClassPath(contextDir));
            appContext.put((Object)"work-directory", (Object)work);
            appContext.put((Object)"upload-directory", (Object)(contextDir + "upload-dir"));
            File cacheDir = Main.getDir(workDir + File.separator + "cache-dir", "cache");
            appContext.put((Object)"cache-directory", (Object)cacheDir);
            appContext.put((Object)"config-url", (Object)conf.toURL());
            Cocoon c = new Cocoon();
            c.setLogger(log);
            c.contextualize((Context)appContext);
            c.setLogKitManager((LogKitManager)logKitManager);
            c.initialize();
            Main main = new Main(c, context, dest, brokenLinkFile);
            main.userAgent = userAgent;
            main.accept = accept;
            main.followLinks = followLinks;
            main.warmup();
            if (main.process(targets, precompileOnly) == 0) {
                main.recursivelyPrecompile(context, context);
            }
            c.dispose();
            log.info("Done");
        }
        catch (Exception e) {
            log.fatalError("Exception caught ", (Throwable)e);
            System.exit(1);
        }
        System.exit(0);
    }

    private static void printVersion() {
        System.out.println("2.0.4");
        System.exit(0);
    }

    private static void printUsage() {
        String lSep = System.getProperty("line.separator");
        StringBuffer msg = new StringBuffer();
        msg.append("------------------------------------------------------------------------ ").append(lSep);
        msg.append("Apache Cocoon").append(" ").append("2.0.4").append(lSep);
        msg.append("Copyright (c) ").append("1999-2002").append(" Apache Software Foundation. All rights reserved.").append(lSep);
        msg.append("------------------------------------------------------------------------ ").append(lSep).append(lSep);
        msg.append("Usage: java org.apache.cocoon.Main [options] [targets]").append(lSep).append(lSep);
        msg.append("Options: ").append(lSep);
        msg.append(CLUtil.describeOptions((CLOptionDescriptor[])OPTIONS).toString());
        msg.append("Note: the context directory defaults to '").append("./webapp'").append(lSep);
        System.out.println(msg.toString());
        System.exit(0);
    }

    private static File getConfigurationFile(File dir) throws Exception {
        File f;
        if (log.isDebugEnabled()) {
            log.debug("Trying configuration file at: " + dir + File.separator + "cocoon.xconf");
        }
        if ((f = new File(dir, "cocoon.xconf")).canRead()) {
            return f;
        }
        if (log.isDebugEnabled()) {
            log.debug("Trying configuration file at: " + System.getProperty("user.dir") + File.separator + "cocoon.xconf");
        }
        if ((f = new File(System.getProperty("user.dir") + File.separator + "cocoon.xconf")).canRead()) {
            return f;
        }
        if (log.isDebugEnabled()) {
            log.debug("Trying configuration file at: /usr/local/etc/cocoon.xconf");
        }
        if ((f = new File("/usr/local/etc/", "cocoon.xconf")).canRead()) {
            return f;
        }
        log.error("Could not find the configuration file.");
        throw new FileNotFoundException("The configuration file could not be found.");
    }

    private static File getDir(String dir, String type) throws Exception {
        File d;
        if (log.isDebugEnabled()) {
            log.debug("Getting handle to " + type + " directory '" + dir + "'");
        }
        if (!(d = new File(dir)).exists() && !d.mkdirs()) {
            log.error("Error creating " + type + " directory '" + d + "'");
            throw new IOException("Error creating " + type + " directory '" + d + "'");
        }
        if (!d.isDirectory()) {
            log.error("'" + d + "' is not a directory.");
            throw new IOException("'" + d + "' is not a directory.");
        }
        if (!d.canRead() || !d.canWrite()) {
            log.error("Directory '" + d + "' is not readable/writable");
            throw new IOException("Directory '" + d + "' is not readable/writable");
        }
        return d;
    }

    public Main(Cocoon cocoon, File context, File destDir, File brokenLinks) {
        this.cocoon = cocoon;
        this.context = context;
        this.destDir = destDir;
        if (brokenLinks != null) {
            try {
                this.brokenLinkWriter = new PrintWriter((Writer)new FileWriter(brokenLinks), true);
            }
            catch (IOException ioe) {
                log.error("File does not exist: " + brokenLinks.getAbsolutePath());
            }
        }
        this.attributes = new HashMap();
        this.empty = new HashMap();
        this.allProcessedLinks = new HashMap();
        this.allTranslatedLinks = new HashMap();
    }

    public void warmup() throws Exception {
        log.info("Warming up...");
        log.info(" [Cocoon might need to compile the sitemaps, this might take a while]");
        this.cocoon.generateSitemap(new LinkSamplingEnvironment("/", this.context, this.attributes, null, log));
    }

    public int process(Collection uris, boolean precompileOnly) throws Exception {
        String next;
        int nCount = 0;
        log.info("...ready, let's go:");
        ArrayList<String> links = new ArrayList<String>();
        Iterator i = uris.iterator();
        while (i.hasNext()) {
            next = (String)i.next();
            if (links.contains(next)) continue;
            links.add(next);
        }
        while (links.size() > 0) {
            String url;
            block10: {
                url = (String)links.get(0);
                try {
                    if (this.allProcessedLinks.get(url) == null) {
                        if (precompileOnly) {
                            this.processXSP(url);
                        } else if (this.followLinks) {
                            i = this.processURI(url).iterator();
                            while (i.hasNext()) {
                                next = (String)i.next();
                                if (links.contains(next)) continue;
                                links.add(next);
                            }
                        } else {
                            this.processURI(url);
                        }
                    }
                }
                catch (ResourceNotFoundException rnfe) {
                    log.warn("  [broken link]--> " + url);
                    if (null == this.brokenLinkWriter) break block10;
                    this.brokenLinkWriter.println(url);
                }
            }
            links.remove(url);
            ++nCount;
            if (!log.isInfoEnabled()) continue;
            log.info("  Memory used: " + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()));
            log.info("  Processed, Translated & Left: " + this.allProcessedLinks.size() + ", " + this.allTranslatedLinks.size() + ", " + links.size());
        }
        return nCount;
    }

    public void recursivelyPrecompile(File contextDir, File file) {
        block6: {
            block7: {
                block5: {
                    if (!file.isDirectory()) break block5;
                    String[] entries = file.list();
                    int i = 0;
                    while (i < entries.length) {
                        this.recursivelyPrecompile(contextDir, new File(file, entries[i]));
                        ++i;
                    }
                    break block6;
                }
                if (!file.getName().toLowerCase().endsWith(".xmap")) break block7;
                try {
                    this.processXMAP(IOUtils.getContextFilePath(contextDir.getCanonicalPath(), file.getCanonicalPath()));
                }
                catch (Exception e) {}
                break block6;
            }
            if (!file.getName().toLowerCase().endsWith(".xsp")) break block6;
            try {
                this.processXSP(IOUtils.getContextFilePath(contextDir.getCanonicalPath(), file.getCanonicalPath()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void processXSP(String uri) throws Exception {
        String markupLanguage = "xsp";
        String programmingLanguage = "java";
        LinkSamplingEnvironment env = new LinkSamplingEnvironment("/", this.context, this.attributes, null, log);
        this.cocoon.precompile(uri, env, markupLanguage, programmingLanguage);
    }

    public void processXMAP(String uri) throws Exception {
        String markupLanguage = "sitemap";
        String programmingLanguage = "java";
        LinkSamplingEnvironment env = new LinkSamplingEnvironment("/", this.context, this.attributes, null, log);
        this.cocoon.precompile(uri, env, markupLanguage, programmingLanguage);
    }

    public Collection processURI(String uri) throws Exception {
        String filename;
        log.info("Processing URI: " + uri);
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        String deparameterizedURI = NetUtils.deparameterize(uri, parameters);
        String path = NetUtils.getPath(uri);
        String suri = NetUtils.parameterize(deparameterizedURI, parameters);
        parameters.put("user-agent", this.userAgent);
        parameters.put("accept", this.accept);
        String pageURI = deparameterizedURI;
        if (pageURI.indexOf("/") != -1 && (pageURI = pageURI.substring(pageURI.lastIndexOf("/") + 1)).length() == 0) {
            pageURI = "./";
        }
        if ((filename = (String)this.allTranslatedLinks.get(suri)) == null) {
            filename = this.mangle(suri);
            String type = this.getType(deparameterizedURI, parameters);
            String ext = NetUtils.getExtension(filename);
            String defaultExt = MIMEUtils.getDefaultExtension(type);
            if (ext == null || !ext.equals(defaultExt)) {
                filename = filename + defaultExt;
            }
            this.allTranslatedLinks.put(suri, filename);
        }
        this.allProcessedLinks.put(suri, filename);
        if ("".equals(filename)) {
            return new ArrayList();
        }
        ArrayList<String> absoluteLinks = new ArrayList<String>();
        HashMap<String, String> translatedLinks = new HashMap<String, String>();
        Iterator i = this.getLinks(deparameterizedURI, parameters).iterator();
        while (i.hasNext()) {
            String link = (String)i.next();
            String relativeLink = link;
            if (relativeLink.startsWith("?")) {
                relativeLink = pageURI + relativeLink;
            }
            String absoluteLink = NetUtils.normalize(NetUtils.absolutize(path, relativeLink));
            TreeMap p = new TreeMap();
            String translatedAbsoluteLink = (String)this.allTranslatedLinks.get(absoluteLink = NetUtils.parameterize(NetUtils.deparameterize(absoluteLink, p), p));
            if (translatedAbsoluteLink == null) {
                try {
                    translatedAbsoluteLink = this.translateURI(absoluteLink);
                    log.info("  Link translated: " + absoluteLink);
                    this.allTranslatedLinks.put(absoluteLink, translatedAbsoluteLink);
                    absoluteLinks.add(absoluteLink);
                }
                catch (ResourceNotFoundException rnfe) {
                    log.warn("  [broken link]--> " + absoluteLink);
                    if (null == this.brokenLinkWriter) continue;
                    this.brokenLinkWriter.println(absoluteLink);
                    continue;
                }
            }
            String translatedRelativeLink = NetUtils.relativize(path, translatedAbsoluteLink);
            translatedLinks.put(link, translatedRelativeLink);
        }
        try {
            File file = IOUtils.createFile(this.destDir, NetUtils.decodePath(filename));
            BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(file));
            String type = this.getPage(deparameterizedURI, parameters, translatedLinks, output);
            ((OutputStream)output).close();
            if (type == null) {
                log.warn("  [broken link]--> " + filename);
                if (null != this.brokenLinkWriter) {
                    this.brokenLinkWriter.println(filename);
                }
                this.resourceUnavailable(file);
            } else {
                log.info("  [" + type + "]--> " + filename);
            }
        }
        catch (ResourceNotFoundException rnfe) {
            log.warn("Could not process URI: " + deparameterizedURI);
        }
        return absoluteLinks;
    }

    public String translateURI(String uri) throws Exception {
        if (null == uri || "".equals(uri)) {
            log.warn("translate empty uri");
            return "";
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("user-agent", this.userAgent);
        parameters.put("accept", this.accept);
        String deparameterizedURI = NetUtils.deparameterize(uri, parameters);
        String path = NetUtils.getPath(uri);
        String filename = this.mangle(uri);
        String type = this.getType(deparameterizedURI, parameters);
        String ext = NetUtils.getExtension(filename);
        String defaultExt = MIMEUtils.getDefaultExtension(type);
        if (ext == null || !ext.equals(defaultExt)) {
            filename = filename + defaultExt;
        }
        return filename;
    }

    private void resourceUnavailable(File file) throws IOException {
        PrintStream out = new PrintStream(new BufferedOutputStream(new FileOutputStream(file)));
        out.println(new StringBuffer("<html><head><title>Page Not Available</title></head>").append("<body><h1 align=\"center\">Page Not Available</h1>").append("<body><p align=\"center\">Generated by ").append(DEFAULT_USER_AGENT).append("</p></body></html>"));
        out.close();
    }

    private String mangle(String uri) {
        if (log.isDebugEnabled()) {
            log.debug("mangle(\"" + uri + "\")");
        }
        if (uri.charAt(uri.length() - 1) == '/') {
            uri = uri + "index";
        }
        uri = uri.replace('\"', '\'');
        uri = uri.replace('?', '_');
        uri = uri.replace(':', '_');
        if (log.isDebugEnabled()) {
            log.debug(uri);
        }
        return uri;
    }

    private String leaf(int level) {
        if (level == 0) {
            return "";
        }
        return this.tree(level - 2) + "+--";
    }

    protected String tree(int level) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i <= level) {
            buffer.append("|  ");
            ++i;
        }
        return buffer.toString();
    }

    protected Collection getLinks(String deparameterizedURI, Map parameters) throws Exception {
        LinkSamplingEnvironment env = new LinkSamplingEnvironment(deparameterizedURI, this.context, this.attributes, parameters, log);
        this.cocoon.process(env);
        return env.getLinks();
    }

    protected String getPage(String deparameterizedURI, Map parameters, Map links, OutputStream stream) throws Exception {
        FileSavingEnvironment env = new FileSavingEnvironment(deparameterizedURI, this.context, this.attributes, parameters, links, stream, log);
        this.cocoon.process(env);
        return env.getContentType();
    }

    protected String getType(String deparameterizedURI, Map parameters) throws Exception {
        FileSavingEnvironment env = new FileSavingEnvironment(deparameterizedURI, this.context, this.attributes, parameters, this.empty, new NullOutputStream(), log);
        this.cocoon.process(env);
        return env.getContentType();
    }

    protected static String getClassPath(String context) {
        StringBuffer buildClassPath = new StringBuffer();
        String classDir = context + "/WEB-INF/classes";
        File root = new File(context + "/WEB-INF/lib");
        buildClassPath.append(classDir);
        if (root.isDirectory()) {
            Object[] libraries = root.listFiles();
            Arrays.sort(libraries);
            int i = 0;
            while (i < libraries.length) {
                buildClassPath.append(File.pathSeparatorChar).append(IOUtils.getFullFilename((File)libraries[i]));
                ++i;
            }
        }
        buildClassPath.append(File.pathSeparatorChar).append(System.getProperty("java.class.path"));
        if (log.isDebugEnabled()) {
            log.debug("Context classpath: " + buildClassPath.toString());
        }
        return buildClassPath.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class NullOutputStream
    extends OutputStream {
        NullOutputStream() {
        }

        public void write(int b) throws IOException {
        }

        public void write(byte[] b) throws IOException {
        }

        public void write(byte[] b, int off, int len) throws IOException {
        }
    }
}

