/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.browser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.browser.Browser;
import org.apache.cocoon.components.browser.UserAgentComparator;
import org.apache.cocoon.components.parser.Parser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class BrowserImpl
implements Component,
Browser,
Composable,
Disposable,
ThreadSafe {
    HashMap byMimeType = new HashMap();
    TreeSet byUserAgent = new TreeSet(new UserAgentComparator());
    ArrayList mimeTypeSearchOrder;
    Parser parser;
    protected ComponentManager manager = null;

    public void compose(ComponentManager manager) throws ComponentException {
        this.manager = manager;
        this.parser = (Parser)this.manager.lookup("org.apache.cocoon.components.parser.Parser");
        HashMap browser0 = new HashMap();
        this.mimeTypeSearchOrder = new ArrayList();
        this.mimeTypeSearchOrder.add("text/html");
        this.mimeTypeSearchOrder.add("text/vnd.wap.wml");
        HashMap browser1 = (HashMap)browser0.clone();
        this.byMimeType.put("text/vnd.wap.wml", browser1);
        browser1.put("media", "wap");
        browser1.put("mime-type", "text/vnd.wap.wml");
        browser1.put("formatter-type", "text/wml");
        Document document = this.createDocumentForBrowserInfo(browser1);
        browser1.put("ua-capabilities", document);
        HashMap browser2 = (HashMap)browser1.clone();
        browser2.put("name", "phone.com");
        browser2.put("formatter-type", "text/wml/phone.com");
        browser2.put("user-agent", "UP.Browser");
        this.byUserAgent.add(browser2);
        browser2.put("has-accesskey", "");
        browser2.put("binds-call-to-send", "vnd.up.send");
        browser2.put("prf:WmlDeckSize", "1400");
        browser2.put("has-wtai-add-phonebook", "");
        document = this.createDocumentForBrowserInfo(browser2);
        browser2.put("ua-capabilities", document);
        HashMap browser3 = (HashMap)browser2.clone();
        browser3.put("name", "Motorola i500+, i700+, i1000+");
        browser3.put("user-agent", "MO01");
        this.byUserAgent.add(browser3);
        browser3.put("binds-call-to-send", "false");
        browser3.put("has-wtai-add-phonebook", "false");
        browser3.put("prf:NumberOfSoftKeys", "2");
        document = this.createDocumentForBrowserInfo(browser3);
        browser3.put("ua-capabilities", document);
        browser2 = (HashMap)browser1.clone();
        browser2.put("name", "Nokia");
        browser2.put("user-agent", "Nokia");
        this.byUserAgent.add(browser2);
        document = this.createDocumentForBrowserInfo(browser2);
        browser2.put("ua-capabilities", document);
        browser1 = (HashMap)browser0.clone();
        this.byMimeType.put("text/html", browser1);
        browser1.put("media", "html");
        browser1.put("mime-type", "text/html");
        browser1.put("formatter-type", "text/html");
        document = this.createDocumentForBrowserInfo(browser1);
        browser1.put("ua-capabilities", document);
        browser2 = (HashMap)browser1.clone();
        browser2.put("media", "explorer");
        browser2.put("user-agent", "MSIE");
        this.byUserAgent.add(browser2);
        document = this.createDocumentForBrowserInfo(browser2);
        browser2.put("ua-capabilities", document);
        browser2 = (HashMap)browser1.clone();
        browser2.put("media", "pocketexplorer");
        browser2.put("user-agent", "MSPIE");
        this.byUserAgent.add(browser2);
        document = this.createDocumentForBrowserInfo(browser2);
        browser2.put("ua-capabilities", document);
        browser2 = (HashMap)browser1.clone();
        browser2.put("media", "handweb");
        browser2.put("user-agent", "HandHTTP");
        this.byUserAgent.add(browser2);
        document = this.createDocumentForBrowserInfo(browser2);
        browser2.put("ua-capabilities", document);
    }

    public void dispose() {
        if (this.parser != null) {
            this.manager.release((Component)this.parser);
        }
    }

    public HashMap getBrowser(String userAgent, String acceptHeader) {
        if (userAgent == null || userAgent.equals("")) {
            return new HashMap();
        }
        Iterator iter = this.byUserAgent.iterator();
        while (iter.hasNext()) {
            HashMap browserInfo = (HashMap)iter.next();
            String ua = (String)browserInfo.get("user-agent");
            if (ua.indexOf(userAgent) == -1 && userAgent.indexOf(ua) == -1) continue;
            return browserInfo;
        }
        String exactMatch = null;
        String partialMatch = null;
        String globalMatch = null;
        int length = this.mimeTypeSearchOrder.size();
        int i = 0;
        block1: while (i < length) {
            String currentType = (String)this.mimeTypeSearchOrder.get(i);
            int index = currentType.indexOf("/");
            String genericType = currentType.substring(0, index) + "/*";
            StringTokenizer tokenizer = new StringTokenizer(acceptHeader, ", ");
            while (tokenizer.hasMoreElements()) {
                String mediaType = ((String)tokenizer.nextElement()).trim();
                if (currentType.equals(mediaType)) {
                    exactMatch = currentType;
                    break block1;
                }
                if (genericType.equals(mediaType) && partialMatch == null) {
                    partialMatch = currentType;
                    continue;
                }
                if (!mediaType.equals("*/*") || globalMatch != null) continue;
                globalMatch = currentType;
            }
            ++i;
        }
        String type = null;
        if (exactMatch != null) {
            type = exactMatch;
        } else if (partialMatch != null) {
            type = partialMatch;
        } else if (globalMatch != null) {
            type = globalMatch;
        }
        return type != null ? (HashMap)this.byMimeType.get(type) : null;
    }

    protected Document createDocumentForBrowserInfo(HashMap browserInfo) {
        Document document = this.parser.newDocument();
        Element element = document.createElementNS(null, "browser");
        document.appendChild(element);
        Iterator iter = browserInfo.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String nodeName = (String)entry.getKey();
            if (nodeName.equals("ua-capabilities")) continue;
            String nodeValue = (String)entry.getValue();
            Element node = nodeName.indexOf(":") < 0 ? document.createElementNS(null, nodeName) : document.createElementNS("http://www.wapforum.org/UAPROF/ccppschema-20000405", nodeName);
            Text text = document.createTextNode(nodeValue);
            node.appendChild(text);
            element.appendChild(node);
        }
        return document;
    }

    public String getMedia(HashMap browserInfo) {
        return (String)browserInfo.get("media");
    }

    public Document getUACapabilities(HashMap browserInfo) {
        return (Document)browserInfo.get("ua-capabilities");
    }
}

