/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.modules.input;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.modules.input.AbstractInputModule;
import org.apache.cocoon.components.modules.input.IteratorHelper;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;

public class RequestParameterModule
extends AbstractInputModule
implements ThreadSafe {
    public Object getAttribute(String name, Configuration modeConf, Map objectModel) throws ConfigurationException {
        String pname = name;
        if (modeConf != null) {
            pname = modeConf.getAttribute("parameter", pname);
        }
        return ObjectModelHelper.getRequest(objectModel).getParameter(pname);
    }

    public Iterator getAttributeNames(Configuration modeConf, Map objectModel) throws ConfigurationException {
        return new IteratorHelper(ObjectModelHelper.getRequest(objectModel).getParameterNames());
    }

    public Object[] getAttributeValues(String name, Configuration modeConf, Map objectModel) throws ConfigurationException {
        int wildcardIndex;
        Request request = ObjectModelHelper.getRequest(objectModel);
        String wildcard = name;
        if (modeConf != null) {
            wildcard = modeConf.getAttribute("parameter", wildcard);
        }
        if ((wildcardIndex = wildcard.indexOf("*")) != -1) {
            String prefix = wildcard.substring(0, wildcardIndex);
            String suffix = wildcard.length() >= wildcardIndex + 1 ? wildcard.substring(wildcardIndex + 1) : "";
            LinkedList<String> values = new LinkedList<String>();
            Enumeration names = request.getParameterNames();
            while (names.hasMoreElements()) {
                String pname = (String)names.nextElement();
                if (!pname.startsWith(prefix) || !pname.endsWith(suffix)) continue;
                values.add(request.getParameter(pname));
            }
            return values.toArray();
        }
        return request.getParameterValues(wildcard);
    }
}

