/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.notification;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.Map;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import org.apache.avalon.framework.CascadingThrowable;
import org.apache.avalon.framework.component.Component;
import org.apache.cocoon.components.notification.Notifying;
import org.apache.cocoon.components.notification.NotifyingBuilder;
import org.apache.cocoon.components.notification.SimpleNotifyingBean;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DefaultNotifyingBuilder
implements NotifyingBuilder,
Component {
    public Notifying build(Object sender, Object o) {
        if (o instanceof Notifying) {
            return (Notifying)o;
        }
        if (o instanceof Throwable) {
            Throwable t = (Throwable)o;
            SimpleNotifyingBean n = new SimpleNotifyingBean(sender);
            n.setType("error");
            n.setTitle("An error occurred");
            if (t != null) {
                n.setSource(t.getClass().getName());
                Throwable rootCauseThrowable = DefaultNotifyingBuilder.getRootCause(t);
                n.addExtraDescription("original message", rootCauseThrowable.toString());
                if (rootCauseThrowable instanceof SAXParseException) {
                    SAXParseException saxParseException = (SAXParseException)rootCauseThrowable;
                    n.setMessage(saxParseException.getMessage());
                    n.addExtraDescription("location", String.valueOf(saxParseException.getSystemId()));
                    n.addExtraDescription("line", String.valueOf(saxParseException.getLineNumber()));
                    n.addExtraDescription("column", String.valueOf(saxParseException.getColumnNumber()));
                } else if (rootCauseThrowable instanceof TransformerException) {
                    TransformerException transformerException = (TransformerException)rootCauseThrowable;
                    SourceLocator sourceLocator = transformerException.getLocator();
                    n.setMessage(transformerException.getMessage());
                    if (null != sourceLocator) {
                        n.addExtraDescription("location", String.valueOf(sourceLocator.getSystemId()));
                        n.addExtraDescription("line", String.valueOf(sourceLocator.getLineNumber()));
                        n.addExtraDescription("column", String.valueOf(sourceLocator.getColumnNumber()));
                    }
                } else {
                    n.setMessage(t.getMessage());
                }
                n.setDescription(t.toString());
                Throwable stackTraceException = t instanceof SAXException && ((SAXException)t).getException() != null ? ((SAXException)t).getException() : t;
                StringWriter sw = new StringWriter();
                stackTraceException.printStackTrace(new PrintWriter(sw));
                n.addExtraDescription("stacktrace", sw.toString());
                sw = new StringWriter();
                DefaultNotifyingBuilder.appendCauses(new PrintWriter(sw), stackTraceException);
                String causes = sw.toString();
                if (causes != null && causes.length() != 0) {
                    n.addExtraDescription("full exception chain stacktrace", causes);
                }
            }
            return n;
        }
        SimpleNotifyingBean n = new SimpleNotifyingBean(sender);
        n.setType("unknown");
        n.setTitle("Object notification");
        n.setSource(o.getClass().getName());
        n.setMessage(o.toString());
        n.setDescription("No details available.");
        return n;
    }

    public Notifying build(Object sender, Object o, String type, String title, String source, String message, String description, Map extra) {
        SimpleNotifyingBean n = (SimpleNotifyingBean)this.build(sender, o);
        if (type != null) {
            n.setType(type);
        }
        if (title != null) {
            n.setTitle(title);
        }
        if (source != null) {
            n.setSource(source);
        }
        if (message != null) {
            n.setMessage(message);
        }
        if (description != null) {
            n.setDescription(description);
        }
        if (extra != null) {
            n.replaceExtraDescriptions(extra);
        }
        return n;
    }

    private static void appendCauses(PrintWriter out, Throwable t) {
        Throwable cause = null;
        if (t instanceof CascadingThrowable) {
            cause = ((CascadingThrowable)t).getCause();
        } else if (t instanceof SAXException) {
            cause = ((SAXException)t).getException();
        } else if (t instanceof SQLException) {
            cause = ((SQLException)t).getNextException();
        }
        if (cause != null) {
            out.print("Original exception : ");
            cause.printStackTrace(out);
            out.println();
            DefaultNotifyingBuilder.appendCauses(out, cause);
        }
    }

    private static Throwable getRootCause(Throwable t) {
        Throwable cause = null;
        if (t instanceof CascadingThrowable) {
            cause = ((CascadingThrowable)t).getCause();
        } else if (t instanceof SAXException) {
            cause = ((SAXException)t).getException();
        } else if (t instanceof SQLException) {
            cause = ((SQLException)t).getNextException();
        }
        if (cause == null) {
            return t;
        }
        return DefaultNotifyingBuilder.getRootCause(cause);
    }
}

