/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.search;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.avalon.excalibur.xml.Parser;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLoggable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.search.LuceneIndexContentHandler;
import org.apache.cocoon.components.search.LuceneXMLIndexer;
import org.apache.lucene.document.DateField;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SimpleLuceneXMLIndexerImpl
extends AbstractLoggable
implements LuceneXMLIndexer,
Configurable,
Composable,
ThreadSafe {
    protected ComponentManager manager = null;
    final String CONTENT_QUERY = "cocoon-view=content";
    final HashSet allowedContentType = new HashSet();

    public SimpleLuceneXMLIndexerImpl() {
        this.allowedContentType.add("text/xml");
        this.allowedContentType.add("text/xhtml");
    }

    public void configure(Configuration conf) throws ConfigurationException {
    }

    public void compose(ComponentManager manager) throws ComponentException {
        this.manager = manager;
    }

    public List build(URL url) throws ProcessingException {
        try {
            URL contentURL = new URL(url, url.getFile() + (url.getFile().indexOf("?") == -1 ? "?" : "&") + "cocoon-view=content");
            URLConnection contentURLConnection = contentURL.openConnection();
            if (contentURLConnection == null) {
                throw new ProcessingException("Can not open connection to URL " + contentURL + " (null connection)");
            }
            String contentType = contentURLConnection.getContentType();
            if (contentType == null) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Ignoring " + contentURL + " (no content type)");
                }
                return Collections.EMPTY_LIST;
            }
            int index = contentType.indexOf(59);
            if (index != -1) {
                contentType = contentType.substring(0, index);
            }
            if (this.allowedContentType.contains(contentType)) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Indexing " + contentURL + " (" + contentType + ")");
                }
                LuceneIndexContentHandler luceneIndexContentHandler = new LuceneIndexContentHandler();
                this.indexDocument(contentURLConnection, luceneIndexContentHandler);
                Iterator it = luceneIndexContentHandler.iterator();
                while (it.hasNext()) {
                    Document d = (Document)it.next();
                    d.add(Field.UnIndexed((String)"url", (String)url.toString()));
                    d.add(new Field("uid", this.uid(contentURLConnection), false, true, false));
                }
                return luceneIndexContentHandler.allDocuments();
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Ignoring " + contentURL + " (" + contentType + ")");
            }
            return Collections.EMPTY_LIST;
        }
        catch (IOException ioe) {
            throw new ProcessingException("Cannot read URL " + url, ioe);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void indexDocument(URLConnection contentURLConnection, LuceneIndexContentHandler luceneIndexContentHandler) throws ProcessingException {
        InputStream is = null;
        InputSource in = null;
        Parser parser = null;
        try {
            try {
                is = contentURLConnection.getInputStream();
                in = new InputSource(is);
                parser = (Parser)this.manager.lookup(Parser.ROLE);
                parser.parse(in, (ContentHandler)luceneIndexContentHandler);
            }
            catch (IOException ioe) {
                throw new ProcessingException("Cannot read!", ioe);
            }
            catch (SAXException saxe) {
                throw new ProcessingException("Cannot parse!", saxe);
            }
            catch (ComponentException ce) {
                throw new ProcessingException("Cannot lookup xml parser!", ce);
            }
            Object var10_6 = null;
            if (parser == null) return;
        }
        catch (Throwable throwable) {
            Object var10_7 = null;
            if (parser == null) throw throwable;
            this.manager.release(parser);
            throw throwable;
        }
        this.manager.release((Component)parser);
    }

    private String uid(URLConnection urlConnection) {
        return urlConnection.toString().replace('/', '\u0000') + "\u0000" + DateField.timeToString((long)urlConnection.getLastModified());
    }
}

