/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.reading;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Map;
import org.apache.avalon.excalibur.datasource.DataSourceComponent;
import org.apache.avalon.excalibur.pool.Poolable;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.ComponentSelector;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.caching.CacheValidity;
import org.apache.cocoon.caching.Cacheable;
import org.apache.cocoon.caching.NOPCacheValidity;
import org.apache.cocoon.caching.TimeStampCacheValidity;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.reading.AbstractReader;
import org.apache.cocoon.util.HashUtil;
import org.xml.sax.SAXException;

public class DatabaseReader
extends AbstractReader
implements Composable,
Configurable,
Disposable,
Cacheable,
Poolable {
    private ComponentSelector dbselector;
    private String dsn;
    private long lastModified = System.currentTimeMillis();
    private Blob resource = null;
    private Connection con = null;
    private DataSourceComponent datasource = null;
    private boolean doCommit = false;
    private boolean defaultCache = true;
    private ComponentManager manager;

    public void compose(ComponentManager manager) throws ComponentException {
        this.manager = manager;
        this.dbselector = (ComponentSelector)manager.lookup(DataSourceComponent.ROLE + "Selector");
    }

    public void configure(Configuration conf) throws ConfigurationException {
        this.dsn = conf.getChild("use-connection").getValue();
        this.defaultCache = conf.getChild("invalidate").getValue("never").equals("always");
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, par);
        try {
            this.datasource = (DataSourceComponent)this.dbselector.select((Object)this.dsn);
            this.con = this.datasource.getConnection();
            if (this.con.getAutoCommit()) {
                this.con.setAutoCommit(false);
            }
            PreparedStatement statement = this.con.prepareStatement(this.getQuery());
            statement.setString(1, this.source);
            ResultSet set = statement.executeQuery();
            if (!set.next()) {
                throw new ResourceNotFoundException("There is no resource with that key");
            }
            Response response = ObjectModelHelper.getResponse(objectModel);
            Request request = ObjectModelHelper.getRequest(objectModel);
            if (this.modifiedSince(set, request, response)) {
                this.resource = set.getBlob(1);
                if (this.resource == null) {
                    throw new ResourceNotFoundException("There is no resource with that key");
                }
            }
            this.doCommit = true;
        }
        catch (Exception e) {
            this.getLogger().warn("Could not get resource from Database", (Throwable)e);
            this.doCommit = false;
            throw new ResourceNotFoundException("DatabaseReader error:", e);
        }
    }

    public void generate() throws ProcessingException, SAXException, IOException {
        try {
            Response response = ObjectModelHelper.getResponse(this.objectModel);
            this.serialize(response);
        }
        catch (IOException ioe) {
            this.getLogger().debug("Assuming client reset stream");
            this.doCommit = false;
        }
        catch (Exception e) {
            this.getLogger().warn("Could not get resource from Database", (Throwable)e);
            this.doCommit = false;
            throw new ResourceNotFoundException("DatabaseReader error:", e);
        }
    }

    public String getQuery() throws Exception {
        String table = this.parameters.getParameter("table", null);
        String column = this.parameters.getParameter("image", null);
        String key = this.parameters.getParameter("key", null);
        String where = this.parameters.getParameter("where", null);
        String orderBy = this.parameters.getParameter("order-by", null);
        if (table == null || column == null || key == null) {
            throw new ProcessingException("We are missing a required parameter.  Please include 'table', 'image', and 'key'");
        }
        String date = this.parameters.getParameter("last-modified", null);
        StringBuffer query = new StringBuffer("SELECT ");
        query.append(column);
        if (date != null) {
            query.append(", ").append(date);
        }
        if (null != orderBy) {
            query.append(", ");
            if (orderBy.endsWith(" DESC")) {
                query.append(orderBy.substring(0, orderBy.length() - 5));
            } else {
                query.append(orderBy);
            }
        }
        query.append(" FROM ").append(table);
        query.append(" WHERE ").append(key).append(" = ?");
        if (null != where) {
            query.append(" AND ").append(where);
        }
        if (null != orderBy) {
            query.append(" ORDER BY ").append(orderBy);
        }
        return query.toString();
    }

    public boolean modifiedSince(ResultSet set, Request request, Response response) throws SQLException {
        String lastModified = this.parameters.getParameter("last-modified", null);
        if (lastModified != null) {
            Timestamp modified = set.getTimestamp(lastModified, null);
            if (null != modified) {
                this.lastModified = modified.getTime();
            }
            response.setDateHeader("Last-Modified", this.lastModified);
            return this.lastModified > request.getDateHeader("if-modified-since");
        }
        return true;
    }

    public void serialize(Response response) throws IOException, SQLException {
        if (this.resource == null) {
            throw new SQLException("The Blob is empty!");
        }
        BufferedInputStream is = new BufferedInputStream(this.resource.getBinaryStream());
        long expires = this.parameters.getParameterAsInteger("expires", -1);
        if (expires > 0L) {
            response.setDateHeader("Expires", System.currentTimeMillis() + expires);
        }
        response.setHeader("Accept-Ranges", "bytes");
        byte[] buffer = new byte[8192];
        int length = -1;
        while ((length = ((InputStream)is).read(buffer)) > -1) {
            this.out.write(buffer, 0, length);
        }
        ((InputStream)is).close();
        this.out.flush();
    }

    public long generateKey() {
        return HashUtil.hash(this.source);
    }

    public CacheValidity generateValidity() {
        if (this.lastModified > 0L) {
            return new TimeStampCacheValidity(this.lastModified);
        }
        if (this.defaultCache) {
            return NOPCacheValidity.CACHE_VALIDITY;
        }
        return null;
    }

    public void recycle() {
        super.recycle();
        this.resource = null;
        this.lastModified = 0L;
        if (this.con != null) {
            try {
                if (this.doCommit) {
                    this.con.commit();
                } else {
                    this.con.rollback();
                }
            }
            catch (SQLException se) {
                this.getLogger().warn("Could not commit or rollback connection", (Throwable)se);
            }
            try {
                this.con.close();
            }
            catch (SQLException se) {
                this.getLogger().warn("Could not close connection", (Throwable)se);
            }
            this.con = null;
        }
        if (this.datasource != null) {
            this.dbselector.release((Component)this.datasource);
            this.datasource = null;
        }
    }

    public void dispose() {
        this.manager.release((Component)this.dbselector);
    }

    public String getMimeType() {
        return this.parameters.getParameter("content-type", super.getMimeType());
    }
}

