/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.transformation;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CacheValidity;
import org.apache.cocoon.caching.Cacheable;
import org.apache.cocoon.caching.NOPCacheValidity;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.generation.FragmentExtractorGenerator;
import org.apache.cocoon.transformation.AbstractTransformer;
import org.apache.cocoon.xml.dom.DOMBuilder;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class FragmentExtractorTransformer
extends AbstractTransformer
implements Cacheable,
Configurable {
    private static final String EXTRACT_URI_NAME = "extract-uri";
    private static final String EXTRACT_ELEMENT_NAME = "extract-element";
    private static final String EXTRACT_URI = "http://www.w3.org/2000/svg";
    private static final String EXTRACT_ELEMENT = "svg";
    private static final String FE_URI = "http://apache.org/cocoon/fragmentextractor/2.0";
    private static final String XLINK_URI = "http://www.w3c.org/1999/xlink";
    private String extractURI;
    private String extractElement;
    private static String generatorClass = "org.apache.cocoon.generation.FragmentExtractorGenerator";
    private DOMBuilder currentBuilder;
    private Map prefixMap;
    private int extractLevel;

    public void configure(Configuration conf) throws ConfigurationException {
        if (conf != null) {
            this.extractURI = conf.getChild(EXTRACT_URI_NAME).getValue(EXTRACT_URI);
            this.extractElement = conf.getChild(EXTRACT_ELEMENT_NAME).getValue(EXTRACT_ELEMENT);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Extraction URI is " + this.extractURI);
                this.getLogger().debug("Extraction element is " + this.extractElement);
            }
        }
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters parameters) throws ProcessingException, SAXException, IOException {
        this.extractLevel = 0;
        this.prefixMap = new HashMap();
    }

    public long generateKey() {
        return 1L;
    }

    public CacheValidity generateValidity() {
        return NOPCacheValidity.CACHE_VALIDITY;
    }

    public void startDocument() throws SAXException {
        super.startDocument();
    }

    public void endDocument() throws SAXException {
        super.endDocument();
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.extractLevel == 0) {
            super.startPrefixMapping(prefix, uri);
            this.prefixMap.put(prefix, uri);
        } else {
            this.currentBuilder.startPrefixMapping(prefix, uri);
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        if (this.extractLevel == 0) {
            super.endPrefixMapping(prefix);
            this.prefixMap.remove(prefix);
        } else {
            this.currentBuilder.endPrefixMapping(prefix);
        }
    }

    public void startElement(String uri, String loc, String raw, Attributes a) throws SAXException {
        if (this.extractURI.equals(uri) && this.extractElement.equals(loc)) {
            ++this.extractLevel;
            this.getLogger().debug("extractLevel now " + this.extractLevel + ".");
            this.currentBuilder = new DOMBuilder();
            this.currentBuilder.startDocument();
            Iterator itt = this.prefixMap.entrySet().iterator();
            while (itt.hasNext()) {
                Map.Entry entry = itt.next();
                this.currentBuilder.startPrefixMapping((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (this.extractLevel == 0) {
            super.startElement(uri, loc, raw, a);
        } else {
            this.currentBuilder.startElement(uri, loc, raw, a);
        }
    }

    public void endElement(String uri, String loc, String raw) throws SAXException {
        if (this.extractLevel == 0) {
            super.endElement(uri, loc, raw);
        } else {
            this.currentBuilder.endElement(uri, loc, raw);
            if (this.extractURI.equals(uri) && this.extractElement.equals(loc)) {
                --this.extractLevel;
                this.getLogger().debug("extractLevel now " + this.extractLevel + ".");
                if (this.extractLevel == 0) {
                    Iterator itt = this.prefixMap.entrySet().iterator();
                    while (itt.hasNext()) {
                        Map.Entry entry = itt.next();
                        this.currentBuilder.endPrefixMapping((String)entry.getKey());
                    }
                    this.currentBuilder.endDocument();
                    Document doc = this.currentBuilder.getDocument();
                    String id = FragmentExtractorGenerator.store(doc);
                    this.getLogger().debug("Stored document " + id + ".");
                    super.startPrefixMapping("fe", FE_URI);
                    AttributesImpl atts = new AttributesImpl();
                    atts.addAttribute(null, "fragment-id", "fragment-id", "CDATA", id);
                    super.startElement(FE_URI, "fragment", "fe:fragment", atts);
                    super.endElement(FE_URI, "fragment", "fe:fragment");
                    super.endPrefixMapping("fe");
                }
            }
        }
    }

    public void characters(char[] c, int start, int len) throws SAXException {
        if (this.extractLevel == 0) {
            super.characters(c, start, len);
        } else {
            this.currentBuilder.characters(c, start, len);
        }
    }

    public void ignorableWhitespace(char[] c, int start, int len) throws SAXException {
        if (this.extractLevel == 0) {
            super.ignorableWhitespace(c, start, len);
        } else {
            this.currentBuilder.ignorableWhitespace(c, start, len);
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (this.extractLevel == 0) {
            super.processingInstruction(target, data);
        } else {
            this.currentBuilder.processingInstruction(target, data);
        }
    }

    public void skippedEntity(String name) throws SAXException {
        if (this.extractLevel == 0) {
            super.skippedEntity(name);
        } else {
            this.currentBuilder.skippedEntity(name);
        }
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        if (this.extractLevel != 0) {
            throw new SAXException("Recieved startDTD after beginning fragment extraction process.");
        }
        super.startDTD(name, publicId, systemId);
    }

    public void endDTD() throws SAXException {
        if (this.extractLevel != 0) {
            throw new SAXException("Recieved endDTD after beginning fragment extraction process.");
        }
        super.endDTD();
    }

    public void startEntity(String name) throws SAXException {
        if (this.extractLevel == 0) {
            super.startEntity(name);
        } else {
            this.currentBuilder.startEntity(name);
        }
    }

    public void endEntity(String name) throws SAXException {
        if (this.extractLevel == 0) {
            super.endEntity(name);
        } else {
            this.currentBuilder.endEntity(name);
        }
    }

    public void startCDATA() throws SAXException {
        if (this.extractLevel == 0) {
            super.startCDATA();
        } else {
            this.currentBuilder.startCDATA();
        }
    }

    public void endCDATA() throws SAXException {
        if (this.extractLevel == 0) {
            super.endCDATA();
        } else {
            this.currentBuilder.endCDATA();
        }
    }

    public void comment(char[] ch, int start, int len) throws SAXException {
        if (this.extractLevel == 0) {
            super.comment(ch, start, len);
        } else {
            this.currentBuilder.comment(ch, start, len);
        }
    }
}

