package fr.gouv.culture.sdx.utils.database;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.exception.SDXExceptionCode;
import fr.gouv.culture.sdx.framework.FrameworkImpl;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;

import java.sql.SQLException;

/**
 * Created by IntelliJ IDEA.
 * User: Rasik Pandey
 * Date: 2 f�vr. 2004
 * Time: 14:51:22
 * To change this template use Options | File Templates.
 */
public class JDBCDatabase extends AbstractJDBCDatabase {


    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        this.tableName = (String) props.get(FrameworkImpl.APP_PATH_NAME) + "_" + this.id;
    }

    public DatabaseConnection getConnection() throws SDXException {
        try {
            DatabaseConnection dbConn = new JDBCDatabaseConnection(getDataSourceComponent());
            dbConn.enableLogging(this.logger);
            dbConn.setAutoCommit(false);
            return dbConn;
        } catch (SQLException e) {
            String[] args = new String[2];
            args[0] = this.getId();
            args[1] = e.getMessage();
            throw new SDXException(logger, SDXExceptionCode.ERROR_GET_CONNECTION, args, e);
        } catch (ComponentException e) {
            String[] args = new String[1];
            args[0] = e.getMessage();
            //null logger passed to prevent double logging
            SDXException sdxE = new SDXException(null, SDXExceptionCode.ERROR_ACQUIRE_DATASOURCE, args, e);

            String[] args2 = new String[2];
            args2[0] = this.getId();
            args2[1] = sdxE.getMessage();
            throw new SDXException(logger, SDXExceptionCode.ERROR_GET_CONNECTION, args2, sdxE);
        }
    }

    public void releaseConnection(DatabaseConnection conn) throws SDXException {
        if (conn != null) {
            //closing the sql connection if there is one open
            if (conn.getConnection() != null)
                ((JDBCDatabaseConnection) conn).releaseSqlConnection();
            //releasing the datasource component from cocoon's dbSelector
            this.releaseDataSourceComponent(((JDBCDatabaseConnection) conn).getDataSource());
        }
    }

    /**Not needed*/
    public String getDatabaseDirectoryName() {
        return null;
    }

    /**Not needed*/
    public void optimize() throws SDXException {
    }
}
