<?xml version="1.0" encoding="UTF-8"?>
<!--
SDX: Documentary System in XML.
Copyright (C) 2000, 2001, 2002  Ministere de la culture et de la communication (France), AJLSM

Ministere de la culture et de la communication,
Mission de la recherche et de la technologie
3 rue de Valois, 75042 Paris Cedex 01 (France)
mrt@culture.fr, michel.bottin@culture.fr

AJLSM, 17, rue Vital Carles, 33000 Bordeaux (France)
sevigny@ajlsm.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
or connect to:
http://www.fsf.org/copyleft/gpl.html
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:sdx="http://www.culture.gouv.fr/ns/sdx/sdx" exclude-result-prefixes="xsl sdx">
    <xsl:import href="../../sdx/resources/xsl/sdx-default.xsl"/>
    <xsl:param name="q"/>
    <xsl:param name="uri" select="/sdx:document/@uri"/>
    <!-- (if not <map:parameter name="use-request-parameters" value="true"/>)
select="/sdx:document/sdx:parameters/sdx:parameter[@name='q']/@value" -->
    <!-- modèle racine de page HTML -->
    <xsl:variable name="admin" select="boolean(/sdx:document/sdx:user/@admin)"/>
    <xsl:template match="/sdx:document">
        <html>
            <head>
                <link rel="stylesheet" type="text/css" href="../sdx/resources/css/html.css"/>
                <title>sdx:test -
                    <xsl:value-of select="(//titre | //title | //h1)[1]"/>
                </title>
                <xsl:apply-templates mode="head"/>
            </head>
            <body bgcolor="#FFFFFF">
                <xsl:attribute name="onload">
                    <xsl:call-template name="onload"/>
                </xsl:attribute>
                <xsl:apply-templates/>
            </body>
        </html>
    </xsl:template>
    <xsl:template name="onload">
        <!-- par défaut, rien, destiné à être surchargé par l'xsl qui importe -->
    </xsl:template>
    <xsl:template match="node()" mode="head" priority="-2">
        <!-- par défaut, le mode head ne sort rien -->
    </xsl:template>
    <xsl:template match="*[@show='replace'][@actuate='onload']" mode="head">
        <meta http-equiv="refresh" content="{@time};URL={@href}"/>
    </xsl:template>
    <xsl:template match="*[@show='replace'][@actuate='onload']">
        <p>Si vous n'étiez pas redirigé dans
                <xsl:value-of select="@time"/>
            <xsl:if test="not(@time)">quelques</xsl:if>
        secondes cliquez <a class="but" href="{@href}">ICI</a>
        </p>
    </xsl:template>
    <!-- si barre de navigation demandée dans la source, des liens vers d'autres pages -->
    <xsl:template match="bar">
        <table class="bar" width="100%" cellpadding="0" cellspacing="0" border="0">
            <form action="results.xsp" method="get">
                <tr>
                    <td>&#160;&#160;&#160;</td>
                    <xsl:apply-templates select="document('bar.xml')/*/*"/>
                    <td width="100%">&#160;</td>
                    <td align="right;" nowrap="nowrap">
                        <input type="text" name="q" value="{$q}"/>
                        <input type="submit" value="Rechercher"/>
                    </td>
                    <td>&#160;&#160;&#160;</td>
                </tr>
            </form>
        </table>
        <div class="alert">SDX-2 : ceci est une application test en cours de développement</div>
    </xsl:template>
    <!-- pour chaque boutons -->
    <xsl:template match="bar/link">
        <xsl:if test="not(@label='Administration' and not($admin))">
            <td nowrap="nowrap">
                <input type="submit" onclick="this.form.action='{@href}'" title="{@title}" value="{@label}">
                    <xsl:attribute name="style">
                        <xsl:text>cursor:pointer; </xsl:text>
                        <xsl:if test="contains($uri, @href)">border:inset 2; </xsl:if>
                    </xsl:attribute>
                </input>
            </td>
        </xsl:if>
    </xsl:template>
    <!-- display user -->
    <xsl:template match="sdx:user">
        <br/>
        <br/>
        <hr/>
        <xsl:if test="not(@anonymous)">
            <small>
                <xsl:value-of select="@firstname"/>&#160;<xsl:value-of select="@lastname"/>
        &#160;&#160;(<xsl:value-of select="@id"/>), 
vous êtes identifié comme
            <xsl:choose>
                    <xsl:when test="@anonymous"/>
                    <xsl:when test="@superuser='true'">
                    superutilisateur.
                </xsl:when>
                    <xsl:when test="@admin='true'">
                    administrateur de l'application
                    <xsl:value-of select="@app"/>.
                </xsl:when>
                    <xsl:when test="@app">
                    utilisateur de lapplication
                    <xsl:value-of select="@app"/>.
                </xsl:when>
                </xsl:choose>
                <br/>
                <xsl:call-template name="views"/>
            </small>
        </xsl:if>
    </xsl:template>
    <!-- views -->
    <xsl:template name="views">
        <div>
Les étapes de cette page: 
1) <b>
                    <a title="XSP - la source XSP de cette page" href="{/sdx:document/@uri}2xsp{/sdx:document/@query}">XSP</a>
                </b>
2) <b>
                    <a title="Java - code Java/XSP résultant de la transformation SDX" href="{/sdx:document/@uri}2java{/sdx:document/@query}">Java</a>
                </b>
3) <b>
                    <a title="SDX - exécution SDX du code Java/XSP" href="{/sdx:document/@uri}2sdx{/sdx:document/@query}">SDX</a>
                </b>
4) <b>
                    <a title="XSL - transformation de présentation, avec imports et inclusions" href="{/sdx:document/@uri}2xsl{/sdx:document/@query}">XSL</a>
                </b>
5) <b>
                    <a title="HTML - le code après transformation de présentation" href="{/sdx:document/@uri}2htm{/sdx:document/@query}">HTM</a>
                </b>
        </div>
    </xsl:template>
    <xsl:template match="sdx:field"/>
    <xsl:template match="title"/>
    <xsl:template match="notadmin">
        <div class="alert">Vous n'êtes pas autorisé à administrer cette application.</div>
    </xsl:template>
</xsl:stylesheet>
