/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.oai;

import fr.gouv.culture.oai.OAIComponent;
import fr.gouv.culture.oai.OAIHarvester;
import fr.gouv.culture.oai.OAIRepository;
import fr.gouv.culture.oai.OAIRequestImpl;
import fr.gouv.culture.oai.OAIResponseImpl;
import fr.gouv.culture.oai.util.OAIUtilities;
import java.io.File;
import java.net.MalformedURLException;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.environment.Context;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.xml.XMLConsumer;
import org.xml.sax.SAXException;

public class OAIComponentImpl
implements LogEnabled,
OAIComponent,
Contextualizable,
Composable,
Configurable,
Initializable,
ThreadSafe {
    private ComponentManager manager = null;
    private org.apache.avalon.framework.context.Context context = null;
    private String contextPath = null;
    private File workDir = null;
    protected Logger logger = null;

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }

    public void contextualize(org.apache.avalon.framework.context.Context context) throws ContextException {
        if (context == null) {
            throw new ContextException("Context provided was null", null);
        }
        this.context = context;
        if (this.workDir == null) {
            this.workDir = (File)context.get((Object)"work-directory");
        }
        Context ctx = (Context)context.get((Object)"environment-context");
        try {
            String rootPath = ctx.getRealPath("/");
            if (rootPath != null) {
                this.contextPath = new File(rootPath).toURL().toExternalForm();
            } else {
                String webInf = ctx.getResource("/WEB-INF").toExternalForm();
                this.contextPath = webInf.substring(0, webInf.length() - "WEB-INF".length());
            }
        }
        catch (MalformedURLException e) {
            OAIUtilities.logWarn(this.logger, "Could not get context directory", e);
            this.contextPath = "";
        }
    }

    public void compose(ComponentManager manager) throws ComponentException {
        this.manager = manager;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
    }

    public void initialize() throws Exception {
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void acceptRequest(OAIRepository repo, Request cocoonRequest, XMLConsumer consumer) throws SAXException {
        if (repo != null && cocoonRequest != null && consumer != null) {
            OAIRequestImpl request = new OAIRequestImpl();
            request.enableLogging(this.logger);
            request.setRequest(cocoonRequest);
            OAIResponseImpl response = new OAIResponseImpl();
            response.enableLogging(this.logger);
            response.setRepository(repo);
            response.setRequest(request);
            repo.setConsumer((XMLConsumer)response);
            response.setConsumer(consumer);
            response.sendResponse();
        }
    }

    public void receiveResponse(String requestUrl, OAIHarvester harvester, String identifierNodeName) {
        if (harvester != null && OAIUtilities.checkString(requestUrl)) {
            harvester.setIdentifierName(identifierNodeName);
            harvester.receiveSynchronizedRequest(requestUrl);
        }
    }
}

