/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.document;

import fr.gouv.culture.sdx.document.AbstractIndexableDocument;
import fr.gouv.culture.sdx.document.ParsableDocument;
import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.utils.Utilities;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.avalon.excalibur.xml.Parser;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.cocoon.xml.dom.DOMStreamer;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.tidy.Tidy;
import org.xml.sax.SAXException;

public class HTMLDocument
extends AbstractIndexableDocument
implements ParsableDocument {
    private String MIMETYPE = "text/html";
    protected File tidyConf = null;

    public HTMLDocument(String id) throws SDXException {
        this.setId(id);
    }

    public HTMLDocument() {
    }

    public void startIndexing(Parser parser, XMLConsumer consumer) throws SDXException {
        Utilities.checkXmlConsumer(this.logger, consumer);
        super.resetFields();
        this.parse(parser, consumer);
    }

    public void parse(Parser parser) throws SDXException {
        this.parse(parser, this.xmlConsumer);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parse(Parser parser, XMLConsumer consumer) throws SDXException {
        if (parser == null) {
            String[] args = new String[1];
            if (this.getURL() == null) throw new SDXException(this.logger, 5100, args, null);
            args[0] = this.getURL().toExternalForm();
            throw new SDXException(this.logger, 5100, args, null);
        }
        Utilities.checkXmlConsumer(this.logger, consumer);
        StringWriter stringWriter = new StringWriter();
        PrintWriter errorWriter = new PrintWriter(stringWriter);
        try {
            try {
                Tidy tidy = new Tidy();
                tidy.setXmlOut(true);
                tidy.setXHTML(true);
                tidy.setTidyMark(false);
                tidy.setXmlPi(true);
                tidy.setXmlPIs(true);
                tidy.setNumEntities(true);
                tidy.setDocType("omit");
                tidy.setBreakBeforeBR(true);
                tidy.setFixComments(true);
                tidy.setBreakBeforeBR(true);
                if (this.logger != null) {
                    tidy.setShowWarnings(this.logger.isWarnEnabled());
                    tidy.setQuiet(!this.logger.isInfoEnabled());
                }
                if (this.tidyConf != null && this.tidyConf.canRead()) {
                    tidy.setConfigurationFromFile(this.tidyConf.getCanonicalPath());
                }
                tidy.setErrout(errorWriter);
                Document doc = tidy.parseDOM((InputStream)new BufferedInputStream(this.openStream()), null);
                XMLUtils.stripDuplicateAttributes((Node)doc, null);
                DOMStreamer streamer = new DOMStreamer(consumer);
                streamer.stream((Node)doc);
            }
            catch (SAXException e) {
                String[] args = new String[2];
                if (this.getURL() != null) {
                    args[0] = this.getURL().toExternalForm();
                }
                args[1] = e.getMessage();
                throw new SDXException(this.logger, 5101, args, e);
            }
            catch (IOException e) {
                String[] args = new String[2];
                if (this.getURL() != null) {
                    args[0] = this.getURL().toExternalForm();
                }
                args[1] = e.getMessage();
                throw new SDXException(this.logger, 5101, args, e);
            }
            Object var9_13 = null;
            errorWriter.flush();
            errorWriter.close();
            if (this.logger == null) return;
        }
        catch (Throwable throwable) {
            Object var9_14 = null;
            errorWriter.flush();
            errorWriter.close();
            if (this.logger == null) throw throwable;
            if (!this.logger.isWarnEnabled()) throw throwable;
            this.logger.warn(stringWriter.toString());
            throw throwable;
        }
        if (!this.logger.isWarnEnabled()) return;
        this.logger.warn(stringWriter.toString());
    }

    public String getDocType() {
        return "html";
    }

    public void setTransformedDocument(byte[] content) throws SDXException {
        if (content == null) {
            String[] args = new String[]{this.getId()};
            throw new SDXException(this.logger, 5102, args, null);
        }
        HTMLDocument doc = new HTMLDocument();
        this.transformedDoc = doc;
        this.transformedDoc.enableLogging(this.logger);
        this.transformedDoc.setContent(content);
        this.setUpTransformedDocument();
    }

    public void setTransformedDocument(File file) throws SDXException {
        if (file == null) {
            String[] args = new String[]{this.getId()};
            throw new SDXException(this.logger, 5102, args, null);
        }
        HTMLDocument doc = new HTMLDocument();
        this.transformedDoc = doc;
        this.transformedDoc.enableLogging(this.logger);
        this.transformedDoc.setContent(file);
        this.setUpTransformedDocument();
    }

    public String getMimeType() {
        return this.MIMETYPE;
    }

    public void setTidyConfiguration(File tidyConf) {
        this.tidyConf = tidyConf;
    }

    public void addAdditionalSystemFields(org.apache.lucene.document.Document doc) {
    }
}

