/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.oai;

import fr.gouv.culture.oai.AbstractOAIRepository;
import fr.gouv.culture.oai.OAIRequest;
import fr.gouv.culture.oai.util.OAIUtilities;
import fr.gouv.culture.sdx.documentbase.DocumentBase;
import fr.gouv.culture.sdx.documentbase.IDGenerator;
import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.utils.ConfigurationUtilities;
import fr.gouv.culture.sdx.utils.Utilities;
import fr.gouv.culture.sdx.utils.database.Database;
import fr.gouv.culture.sdx.utils.database.DatabaseBacked;
import fr.gouv.culture.sdx.utils.database.DatabaseEntity;
import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.context.DefaultContext;
import org.apache.cocoon.components.source.FileSource;
import org.apache.cocoon.environment.Request;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class AbstractDocumentBaseOAIRepository
extends AbstractOAIRepository
implements Composable,
Contextualizable {
    protected ComponentManager manager = null;
    protected DefaultContext context = null;
    protected DocumentBase documentBase = null;
    protected Database database = null;
    protected String documentBaseId = null;
    protected Hashtable documentBaseProps = null;
    protected int numRecordsPerResponse = 1000;
    protected IDGenerator resumptionTokenIdGen = null;
    public static final String PARAMETER_NAME_SDX_FIELD = "sdxFieldName";
    public static final String PARAMETER_NAME_SET_NAME = "setName";
    public static final String PARAMETER_NAME_SET_SPEC = "setSpec";
    protected final String ATTRIBUTE_NAME_ADMIN_EMAIL = "adminEmail";
    protected final String ATTRIBUTE_NAME_NAME = "name";
    protected final String ATTRIBUTE_NAME_BASE_URL = "baseURL";
    protected final String ATTRIBUTE_NAME_QUERY = "query";
    protected final String ATTRIBUTE_NAME_NO_PER_RESPONSE = "noPerResponse";
    protected final String ELEMENT_NAME_OAI_SETS = "oai-sets";
    protected final String ELEMENT_NAME_OAI_SET = "oai-set";
    protected final String ATTRIBUTE_NAME_SPEC = "spec";
    protected final String ATTRIBUTE_SRC = "src";
    protected final String ELEMENT_NAME_DESCRIPTION = "description";

    public void compose(ComponentManager componentManager) throws ComponentException {
        this.manager = componentManager;
    }

    public void contextualize(Context context) throws ContextException {
        if (context == null) {
            throw new ContextException("Context provided was null", null);
        }
        this.context = (DefaultContext)context;
    }

    public void setProperties(Hashtable props) {
        this.documentBaseProps = props;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        Utilities.checkConfiguration(configuration);
        this.configureAdminEmails(configuration);
        this.repositoryName = configuration.getAttribute("name");
        this.numRecordsPerResponse = configuration.getAttributeAsInteger("noPerResponse", 1000);
        this.configureBaseURL(configuration);
        this.configureDescription(configuration);
        this.configureDatabase(configuration);
        this.configureResumptionTokenIDGenerator(configuration);
    }

    protected void configureResumptionTokenIDGenerator(Configuration configuration) throws ConfigurationException {
        this.resumptionTokenIdGen = ConfigurationUtilities.configureIDGenerator(this.logger, configuration);
        this.resumptionTokenIdGen.setDatabase(this.database);
    }

    protected void configureBaseURL(Configuration configuration) throws ConfigurationException {
        this.baseURL = configuration.getAttribute("baseURL");
    }

    protected void configureDescription(Configuration configuration) throws ConfigurationException {
        Configuration descriptionConf = configuration.getChild("description", false);
        if (descriptionConf != null) {
            String src = descriptionConf.getAttribute("src");
            Utilities.checkConfAttributeValue("src", src, descriptionConf.getLocation());
            File srcFile = null;
            try {
                srcFile = Utilities.resolveFile(null, descriptionConf.getLocation(), this.documentBaseProps, src, false);
                src = srcFile.toURL().toExternalForm();
            }
            catch (SDXException e) {
                throw new ConfigurationException(e.getMessage(), (Throwable)e);
            }
            catch (MalformedURLException e) {
                throw new ConfigurationException(e.getMessage(), (Throwable)e);
            }
            this.description = new FileSource(src, this.manager);
            try {
                this.getDescription((ContentHandler)((Object)this));
            }
            catch (SAXException e) {
                throw new ConfigurationException(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void configureAdminEmails(Configuration configuration) throws ConfigurationException {
        ArrayList<String> locAdminEmailsList = new ArrayList<String>();
        String firstAdminEmail = configuration.getAttribute("adminEmail", null);
        Configuration[] locAdminEmails = configuration.getChildren("adminEmail");
        if (Utilities.checkString(firstAdminEmail)) {
            locAdminEmailsList.add(firstAdminEmail);
        }
        for (int i = 0; i < locAdminEmails.length; ++i) {
            String value;
            Configuration locAdminEmail = locAdminEmails[i];
            if (locAdminEmail == null || !Utilities.checkString(value = locAdminEmail.getValue())) continue;
            locAdminEmailsList.add(value);
        }
        if (locAdminEmailsList.size() <= 0) {
            Utilities.checkConfAttributeValue("adminEmail", "", configuration.getLocation());
        }
        this.adminEmails = locAdminEmailsList.toArray(new String[0]);
        locAdminEmailsList.clear();
        locAdminEmailsList = null;
    }

    protected void configureDatabase(Configuration configuration) throws ConfigurationException {
        DatabaseBacked internalDb = new DatabaseBacked();
        try {
            internalDb.setId(this.getRepositoryId());
            internalDb.compose(this.manager);
            internalDb.setProperties(this.documentBaseProps);
            internalDb.configure(configuration);
            internalDb.init();
            this.database = internalDb.getDatabase();
        }
        catch (SDXException e) {
            throw new ConfigurationException(e.getMessage(), (Throwable)e);
        }
        catch (ComponentException e) {
            throw new ConfigurationException(e.getMessage(), (Throwable)e);
        }
    }

    protected String getRepositoryId() {
        String rid = "";
        rid = rid + "sdx_";
        rid = rid + "oai_";
        rid = rid + "repository_";
        rid = rid + this.documentBaseId;
        return rid;
    }

    protected String buildExternalOaiId(OAIRequest request, String docId) {
        String endSub;
        String scheme = "sdx";
        String requestUrl = request.getRequestURL();
        String beginSub = requestUrl.substring("http://".length());
        String nsId = endSub = beginSub.substring(0, beginSub.indexOf("/"));
        String appId = Utilities.getStringFromHashtable("appPathName", this.documentBaseProps);
        String prefix = scheme + ":" + nsId + ":";
        String encoding = Utilities.getStringFromHashtable("encoding", this.documentBaseProps);
        String suffix = Utilities.encodeURL(appId, encoding) + "/" + Utilities.encodeURL(this.documentBaseId, encoding) + "/" + Utilities.encodeURL(docId, encoding);
        String externalOaiId = prefix + suffix;
        return externalOaiId;
    }

    protected String deriveInternalSdxId(OAIRequest request, String fullOaiId) {
        if (!Utilities.checkString(fullOaiId)) {
            return null;
        }
        String dummyId = "sdxDummyId";
        String dummyExternalId = this.buildExternalOaiId(request, dummyId);
        if (!fullOaiId.startsWith(dummyExternalId.substring(0, dummyExternalId.indexOf(dummyId)))) {
            return null;
        }
        String appId = Utilities.getStringFromHashtable("appPathName", this.documentBaseProps);
        String substring = appId + "/" + this.documentBaseId + "/";
        String encoding = Utilities.getStringFromHashtable("encoding", this.documentBaseProps);
        int beginIdx = fullOaiId.indexOf(substring = Utilities.decodeURL(substring, encoding));
        beginIdx = beginIdx < 0 ? 0 : (beginIdx += substring.length());
        int endIdx = fullOaiId.length();
        String internalId = fullOaiId.substring(beginIdx, endIdx);
        internalId = Utilities.decodeURL(internalId, encoding);
        return internalId;
    }

    protected String buildUrlLocator(OAIRequest request, String docId) {
        String base;
        String requestUrl = request.getRequestURL();
        int endIdx = requestUrl.indexOf("?");
        if (endIdx < 0) {
            endIdx = requestUrl.length();
        }
        if (!(base = requestUrl.substring(0, endIdx)).endsWith("/")) {
            base = base + "/";
        }
        base = base + docId;
        return base;
    }

    protected String createResumptionToken(OAIRequest request) throws SDXException {
        int cursor;
        String previousResumptionToken = request.getResumptionToken();
        DatabaseEntity rtEnt = this.database.getEntity(previousResumptionToken);
        String newResumptionToken = this.resumptionTokenIdGen.generate();
        String resultsId = "";
        Date date = OAIUtilities.Date.getUtcIso8601Date();
        String utcDate = OAIUtilities.Date.formatUtcISO8601Date(date);
        while (this.database.entityExists(newResumptionToken)) {
            newResumptionToken = this.resumptionTokenIdGen.generate();
        }
        if (rtEnt == null) {
            Enumeration paramNames;
            rtEnt = new DatabaseEntity(newResumptionToken);
            cursor = 0;
            Request cocoonRequest = request.getRequest();
            if (cocoonRequest != null && (paramNames = cocoonRequest.getParameterNames()) != null) {
                while (paramNames.hasMoreElements()) {
                    String paramName = (String)paramNames.nextElement();
                    String paramVal = cocoonRequest.getParameter(paramName);
                    if (!Utilities.checkString(paramName = OAIUtilities.normalizeHttpRequestParameterName(paramName)) || !Utilities.checkString(paramVal)) continue;
                    if ("identifier".equals(paramName)) {
                        rtEnt.addProperty(paramName, paramVal);
                        continue;
                    }
                    if ("metadataPrefix".equals(paramName)) {
                        rtEnt.addProperty(paramName, paramVal);
                        continue;
                    }
                    if ("set".equals(paramName)) {
                        rtEnt.addProperty(paramName, paramVal);
                        continue;
                    }
                    if ("from".equals(paramName)) {
                        rtEnt.addProperty(paramName, paramVal);
                        continue;
                    }
                    if ("until".equals(paramName)) {
                        rtEnt.addProperty(paramName, paramVal);
                        continue;
                    }
                    if ("resumptionToken".equals(paramName)) {
                        rtEnt.addProperty(paramName, paramVal);
                        continue;
                    }
                    if (!"verb".equals(paramName)) continue;
                    rtEnt.addProperty(paramName, paramVal);
                }
            }
            resultsId = newResumptionToken + "_results";
        } else {
            cursor = Integer.parseInt(rtEnt.getProperty("cursor")) + this.numRecordsPerResponse;
            rtEnt.setId(newResumptionToken);
            resultsId = rtEnt.getProperty("resultsId");
        }
        rtEnt.deleteProperty("cursor");
        rtEnt.deleteProperty("resultsId");
        rtEnt.deleteProperty("responseDate");
        rtEnt.addProperty("cursor", Integer.toString(cursor));
        rtEnt.addProperty("resultsId", resultsId);
        rtEnt.addProperty("responseDate", utcDate);
        if (Utilities.checkString(previousResumptionToken)) {
            this.database.delete(new DatabaseEntity(previousResumptionToken));
        }
        this.database.update(rtEnt);
        this.database.optimize();
        return newResumptionToken;
    }

    protected String getResumptionTokenCursor(String resumptionToken) {
        return this.getResumptionTokenProperty(resumptionToken, "cursor");
    }

    protected String getResumptionTokenProperty(String resumptionToken, String propertyName) {
        String propVal = null;
        try {
            DatabaseEntity ent = this.database.getEntity(resumptionToken);
            if (ent != null) {
                propVal = ent.getProperty(propertyName);
            }
        }
        catch (SDXException e) {
            Utilities.logException(this.logger, e);
        }
        return propVal;
    }

    public boolean verifyGranularity(String paramVal) {
        Date date = fr.gouv.culture.sdx.utils.Date.parseUtcISO8601Date(paramVal);
        return date != null;
    }
}

