/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.repository;

import fr.gouv.culture.sdx.document.Document;
import fr.gouv.culture.sdx.document.ParsableDocument;
import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.repository.RepositoryConnection;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.cocoon.xml.XMLConsumer;
import org.xml.sax.ContentHandler;

public interface Repository
extends Composable,
LogEnabled,
Configurable {
    public static final String ATTRIBUTE_ID = "id";
    public static final String ELEMENT_NAME_REPOSITORIES = "repositories";
    public static final String ELEMENT_NAME_REPOSITORY = "repository";
    public static final String ATTRIBUTE_DEFAULT = "default";
    public static final String ATTRIBUTE_TYPE = "type";
    public static final String ATTRIBUTE_REF = "ref";
    public static final String PACKAGE_QUALNAME = "fr.gouv.culture.sdx.repository.";
    public static final String CLASS_NAME_SUFFIX = "Repository";

    public String getId();

    public void init() throws SDXException;

    public RepositoryConnection getConnection() throws SDXException;

    public void releaseConnection(RepositoryConnection var1) throws SDXException;

    public long size() throws SDXException;

    public void lists(ContentHandler var1) throws SDXException;

    public void add(Document var1, RepositoryConnection var2) throws SDXException;

    public void empty() throws SDXException;

    public void delete(Document var1, RepositoryConnection var2) throws SDXException;

    public void toSAX(ParsableDocument var1, XMLConsumer var2, RepositoryConnection var3) throws SDXException;

    public InputStream openStream(Document var1, String var2, RepositoryConnection var3) throws SDXException;

    public void get(Document var1, OutputStream var2, RepositoryConnection var3) throws SDXException;

    public boolean isDefault();

    public void setProperties(Hashtable var1);

    public void setIsDefault(boolean var1);

    public void optimize() throws SDXException;

    public boolean exists(String var1, RepositoryConnection var2);
}

