/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.search.lucene.analysis;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.search.lucene.analysis.Analyzer;
import fr.gouv.culture.sdx.utils.Utilities;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Hashtable;
import java.util.Locale;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.source.FileSource;
import org.xml.sax.SAXException;

public class AnalyzerManager
implements Composable,
LogEnabled,
Configurable {
    private ComponentManager manager;
    private Logger logger;
    private Hashtable analyzers = new Hashtable();
    private static String PACKAGE_NAME = "fr.gouv.culture.sdx.search.lucene.analysis";
    private static String CLASS_PREFIX = "Analyzer_";
    private static String DEFAULT_CLASSNAME = PACKAGE_NAME + ".DefaultAnalyzer";
    private static String DEFAULT_KEY = "default";

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
    }

    public Analyzer getAnalyzer(Locale locale, File configurationFile) throws SDXException {
        String key;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        String filename = "";
        if (configurationFile != null) {
            filename = configurationFile.getAbsolutePath();
        }
        if (this.analyzers.get(key = locale.getLanguage() + ":" + locale.getCountry() + ":" + locale.getVariant() + ":" + filename) != null) {
            return (Analyzer)this.analyzers.get(key);
        }
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        String className = PACKAGE_NAME + "." + CLASS_PREFIX + language + "_" + country + "_" + variant;
        Class<?> c = null;
        try {
            c = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            className = PACKAGE_NAME + "." + CLASS_PREFIX + language + "_" + country;
            try {
                c = Class.forName(className);
            }
            catch (ClassNotFoundException e1) {
                className = PACKAGE_NAME + "." + CLASS_PREFIX + language;
                try {
                    c = Class.forName(className);
                }
                catch (ClassNotFoundException e2) {
                    Utilities.logWarn(this.logger, "Cannot find an analyzer for locale " + locale.getDisplayName() + ", will use default analyzer", null);
                    className = DEFAULT_CLASSNAME;
                    try {
                        c = Class.forName(className);
                        key = DEFAULT_KEY;
                    }
                    catch (ClassNotFoundException e3) {
                        String[] args = new String[]{className};
                        throw new SDXException(this.logger, 4301, args, e3);
                    }
                }
            }
        }
        if (c != null) {
            this.setAnalyzer(key, c, configurationFile);
            return (Analyzer)this.analyzers.get(key);
        }
        String[] args = new String[]{className};
        throw new SDXException(this.logger, 4301, args, null);
    }

    public Analyzer getAnalyzer(String className, File configurationFile) throws SDXException {
        String key = null;
        Class<?> c = null;
        String filename = "";
        if (configurationFile != null) {
            filename = configurationFile.getAbsolutePath();
        }
        if (className == null) {
            className = DEFAULT_CLASSNAME;
            key = DEFAULT_KEY;
            if (this.analyzers.get(key) != null) {
                return (Analyzer)this.analyzers.get(key);
            }
        } else {
            key = className + ":" + filename;
            if (this.analyzers.get(key) != null) {
                return (Analyzer)this.analyzers.get(key);
            }
            try {
                c = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                className = DEFAULT_CLASSNAME;
                key = DEFAULT_KEY;
                try {
                    c = Class.forName(className);
                }
                catch (ClassNotFoundException e1) {
                    String[] args = new String[]{className};
                    throw new SDXException(this.logger, 4301, args, e1);
                }
            }
        }
        this.setAnalyzer(key, c, configurationFile);
        return (Analyzer)this.analyzers.get(key);
    }

    private void setAnalyzer(String key, Class aClass, File cFile) throws SDXException {
        String[] args;
        Configuration conf = null;
        if (cFile != null && cFile.exists()) {
            try {
                DefaultConfigurationBuilder confBuilder = new DefaultConfigurationBuilder();
                FileSource fs = new FileSource(cFile.toURL().toString(), this.manager);
                conf = confBuilder.build(fs.getInputSource());
            }
            catch (SAXException e) {
                String[] args2 = new String[]{key};
                throw new SDXException(this.logger, 4302, args2, e);
            }
            catch (MalformedURLException e) {
                String[] args3 = new String[]{key};
                throw new SDXException(this.logger, 4302, args3, e);
            }
            catch (ProcessingException e) {
                String[] args4 = new String[]{key};
                throw new SDXException(this.logger, 4303, args4, e);
            }
            catch (IOException e) {
                String[] args5 = new String[]{key};
                throw new SDXException(this.logger, 4303, args5, e);
            }
            catch (ConfigurationException e) {
                String[] args6 = new String[]{key};
                throw new SDXException(this.logger, 4303, args6, e);
            }
        }
        try {
            Object o = aClass.newInstance();
            if (o == null) {
                args = new String[]{aClass.getName()};
                throw new SDXException(this.logger, 220, args, null);
            }
            if (!(o instanceof Analyzer)) {
                args = new String[]{"Analyzer", aClass.getName(), key};
                throw new SDXException(this.logger, 10, args, null);
            }
            ((Analyzer)o).enableLogging(this.logger);
            ((Analyzer)o).configure(conf);
            this.analyzers.put(key, o);
        }
        catch (InstantiationException e) {
            args = new String[]{key};
            throw new SDXException(this.logger, 4304, args, e);
        }
        catch (IllegalAccessException e) {
            args = new String[]{key};
            throw new SDXException(this.logger, 4304, args, e);
        }
        catch (ConfigurationException e) {
            args = new String[]{key};
            throw new SDXException(this.logger, 4304, args, e);
        }
    }

    public void compose(ComponentManager manager) throws ComponentException {
        this.manager = manager;
    }
}

