/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.search.lucene.query;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.search.TermHighlighter;
import fr.gouv.culture.sdx.search.lucene.DateField;
import fr.gouv.culture.sdx.search.lucene.query.Query;
import fr.gouv.culture.sdx.search.lucene.query.ResultDocument;
import fr.gouv.culture.sdx.search.lucene.query.ResultDocuments;
import fr.gouv.culture.sdx.search.lucene.query.SearchLocations;
import fr.gouv.culture.sdx.search.lucene.query.SortSpecification;
import fr.gouv.culture.sdx.utils.SdxObjectImpl;
import fr.gouv.culture.sdx.utils.Utilities;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import org.apache.avalon.framework.logger.Logger;
import org.apache.cocoon.ProcessingException;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.search.Hits;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class Results
extends SdxObjectImpl
implements fr.gouv.culture.sdx.search.Results {
    private String id = "";
    private Query query;
    private int hitsPerPage = 20;
    private int nbPages;
    private SearchLocations searchLocations;
    public static final int HITS_PER_PAGE = 20;
    private SortSpecification sorts;
    private ResultDocuments sortedResults;
    private float topScore = 1.0f;
    private TermHighlighter highlighter = null;
    private Hits hits = null;

    public void setUp(SearchLocations sLocs, Hits searchHits, SortSpecification sorts, Query query) throws SDXException, IOException {
        if (sLocs == null) {
            throw new SDXException(null, 4000, null, null);
        }
        if (searchHits == null) {
            throw new SDXException(this.logger, 4003, null, null);
        }
        this.hits = searchHits;
        this.query = query;
        this.sorts = sorts;
        this.searchLocations = sLocs;
        if (this.sorts == null) {
            this.sorts = new SortSpecification();
        }
        this.sorts.enableLogging(this.logger);
        try {
            if (searchHits.length() > 0) {
                this.topScore = searchHits.score(0);
            }
        }
        catch (IOException e) {
            String[] args = new String[]{e.getMessage()};
            throw new SDXException(this.logger, 4400, args, e);
        }
        this.sortedResults = this.sorts.sortResults(searchHits);
        this.nbPages = this.countPages();
    }

    public void setUp(SearchLocations sLocs, Hits searchHits, Query query) throws SDXException {
        if (searchHits == null) {
            throw new SDXException(this.logger, 4003, null, null);
        }
        this.query = query;
        this.searchLocations = sLocs;
        this.sorts = new SortSpecification();
        this.sorts.enableLogging(this.logger);
        try {
            if (searchHits.length() > 0) {
                this.topScore = searchHits.score(0);
            }
        }
        catch (IOException e) {
            String[] args = new String[]{e.getMessage()};
            throw new SDXException(this.logger, 4400, args, e);
        }
        this.sortedResults = this.sorts.sortResults(searchHits);
        this.nbPages = this.countPages();
    }

    public SearchLocations getSearchLocations() {
        return this.searchLocations;
    }

    public Hits getHits() {
        return this.hits;
    }

    public void toSAX(ContentHandler hdl) throws SAXException, ProcessingException {
        try {
            this.toSAX(hdl, 1, false);
        }
        catch (Exception e) {
            if (e instanceof SAXException) {
                throw (SAXException)e;
            }
            if (e instanceof ProcessingException) {
                throw (ProcessingException)((Object)e);
            }
            throw new ProcessingException(e);
        }
    }

    public void toSAX(ContentHandler hdl, boolean getDocuments) throws SDXException, Exception {
        this.toSAX(hdl, 1, getDocuments);
    }

    public void toSAX(ContentHandler hdl, int pageNo) throws SDXException, Exception {
        this.toSAX(hdl, pageNo, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toSAX(ContentHandler hdl, int pageNo, boolean getDocuments) throws SDXException, SAXException, ProcessingException {
        int eIdx;
        int sIdx;
        int nbHits = this.sortedResults.getLength();
        if (nbHits > 0) {
            if (pageNo < 1) {
                pageNo = 1;
            }
            if (pageNo > this.nbPages) {
                pageNo = this.nbPages;
            }
            sIdx = (pageNo - 1) * this.hitsPerPage + 1;
            eIdx = pageNo * this.hitsPerPage;
            if (sIdx < 1) {
                sIdx = 1;
            }
            if (eIdx > nbHits) {
                eIdx = nbHits;
            }
        } else {
            pageNo = 0;
            sIdx = 0;
            eIdx = 0;
        }
        String sdxNsUri = "http://www.culture.gouv.fr/ns/sdx/sdx";
        String sdxNsPrefix = "sdx";
        String localName = "results";
        String qName = sdxNsPrefix + ":" + localName;
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "qid", "qid", "CDATA", String.valueOf(this.id));
        atts.addAttribute("", "page", "page", "CDATA", String.valueOf(pageNo));
        atts.addAttribute("", "hpp", "hpp", "CDATA", String.valueOf(this.hitsPerPage));
        atts.addAttribute("", "pages", "pages", "CDATA", String.valueOf(this.nbPages));
        atts.addAttribute("", "nb", "nb", "CDATA", String.valueOf(nbHits));
        atts.addAttribute("", "start", "start", "CDATA", String.valueOf(sIdx));
        atts.addAttribute("", "end", "end", "CDATA", String.valueOf(eIdx));
        atts.addAttribute("", "id", "id", "CDATA", String.valueOf(this.id));
        atts.addAttribute("", "currentPage", "currentPage", "CDATA", String.valueOf(pageNo));
        atts.addAttribute("", "nbPages", "nbPages", "CDATA", String.valueOf(this.nbPages));
        hdl.startElement(sdxNsUri, localName, qName, atts);
        if (this.query != null) {
            this.query.toSAX(hdl);
        }
        if (this.sorts != null) {
            this.sorts.toSAX(hdl);
        }
        if (nbHits > 0 && this.hitsPerPage != 0) {
            Document resultDoc = null;
            boolean error = false;
            Enumeration fields = null;
            String previousDocId = null;
            float maxScore = this.getMaxScore();
            for (int i = sIdx; i <= eIdx; ++i) {
                ResultDocument currentDocument = this.sortedResults.getDocument(i - 1);
                if (currentDocument == null) continue;
                String childOneLocalName = "result";
                String childOneQName = sdxNsPrefix + ":" + childOneLocalName;
                AttributesImpl childOneAtts = new AttributesImpl();
                childOneAtts.addAttribute("", "no", "no", "CDATA", String.valueOf(i));
                childOneAtts.addAttribute("", "score", "score", "CDATA", String.valueOf(currentDocument.getScore()));
                float pctScore = 100.0f * (currentDocument.getScore() / maxScore);
                childOneAtts.addAttribute("", "pctScore", "pctScore", "CDATA", String.valueOf(Math.round(Math.floor(pctScore))));
                hdl.startElement(sdxNsUri, childOneLocalName, childOneQName, childOneAtts);
                resultDoc = currentDocument.getDocument();
                if (resultDoc != null) {
                    fields = resultDoc.fields();
                }
                if (fields != null) {
                    while (fields.hasMoreElements()) {
                        Field field = (Field)fields.nextElement();
                        if (field == null) continue;
                        String fieldName = field.name();
                        String childTwoLocalName = "field";
                        String childTwoQName = sdxNsPrefix + ":" + childTwoLocalName;
                        AttributesImpl childTwoAtts = new AttributesImpl();
                        int fieldType = this.searchLocations.getFieldType(fieldName);
                        String value = "";
                        value = field.stringValue();
                        childTwoAtts.addAttribute("", "name", "name", "CDATA", fieldName);
                        if (fieldType == 2) {
                            Date date = DateField.stringToDate(value);
                            long milliSecs = 0L;
                            if (date != null) {
                                milliSecs = date.getTime();
                            }
                            value = fr.gouv.culture.sdx.utils.Date.formatDate(date);
                            childTwoAtts.addAttribute("", "timeInMilliseconds", "timeInMilliseconds", "CDATA", Long.toString(milliSecs));
                        }
                        String esc = "";
                        esc = Utilities.encodeURL(value, this.encoding);
                        childTwoAtts.addAttribute("", "value", "value", "CDATA", value);
                        if (esc != null) {
                            childTwoAtts.addAttribute("", "escapedValue", "escapedValue", "CDATA", esc);
                        }
                        String fieldTypeName = "";
                        fieldTypeName = this.searchLocations.getTypeName(fieldName);
                        if (fieldTypeName != null) {
                            childTwoAtts.addAttribute("", "type", "type", "CDATA", fieldTypeName);
                        }
                        childTwoAtts.addAttribute("", "indexed", "indexed", "CDATA", String.valueOf(field.isIndexed()));
                        childTwoAtts.addAttribute("", "tokenized", "tokenized", "CDATA", String.valueOf(field.isTokenized()));
                        hdl.startElement(sdxNsUri, childTwoLocalName, childTwoQName, childTwoAtts);
                        char[] chars = value.toCharArray();
                        hdl.characters(chars, 0, chars.length);
                        hdl.endElement(sdxNsUri, childTwoLocalName, childTwoQName);
                        if (!getDocuments || fieldName.equals("sdxdocid")) {
                            // empty if block
                        }
                        if (!fieldName.equals("sdxdocid")) continue;
                        previousDocId = resultDoc.get(fieldName);
                    }
                }
                hdl.endElement(sdxNsUri, childOneLocalName, childOneQName);
            }
        }
        hdl.endElement(sdxNsUri, localName, qName);
    }

    public int countPages() {
        if (this.hitsPerPage == 0) {
            return 1;
        }
        int nbHits = this.sortedResults.getLength();
        if (nbHits == 0) {
            return 0;
        }
        float temp = (float)nbHits / (float)this.hitsPerPage;
        if (temp != (float)Math.round(temp)) {
            return (int)Math.round(Math.floor(temp) + 1.0);
        }
        return Math.round(temp);
    }

    public void setAllHits() {
        this.hitsPerPage = this.sortedResults.getLength();
        this.nbPages = 1;
    }

    public void setHitsPerPage(int nb) {
        if (nb < 0) {
            this.setAllHits();
        } else {
            this.hitsPerPage = nb;
            this.nbPages = this.countPages();
        }
    }

    public int getHitsPerPage() {
        return this.hitsPerPage;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void getQueryAsSAX(ContentHandler hdl) throws SDXException, SAXException, ProcessingException {
        this.query.toSAX(hdl);
    }

    public String[] getDocIds() throws SDXException, IOException {
        int nbHits = this.sortedResults.getLength();
        String[] docIds = new String[nbHits];
        for (int i = 0; i < nbHits; ++i) {
            Document doc = this.sortedResults.getDocument(i).getDocument();
            docIds[i] = doc.get("sdxdocid");
        }
        return docIds;
    }

    public Query getQuery() {
        return this.query;
    }

    public void getNavigationAsSAX(ContentHandler hdl, int docNo) throws SDXException, SAXException, ProcessingException, IOException {
        if (hdl == null) {
            throw new SDXException(this.logger, 215, null, null);
        }
        int nbHits = this.sortedResults.getLength();
        if (docNo <= nbHits && docNo > 0 && this.sortedResults.getDocument(docNo - 1) != null) {
            String sdxNsUri = "http://www.culture.gouv.fr/ns/sdx/sdx";
            String sdxNsPrefix = "sdx";
            String localName = "navigation";
            String qName = sdxNsPrefix + ":" + localName;
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute("", "qid", "qid", "CDATA", this.id);
            atts.addAttribute("", "page", "page", "CDATA", "" + this.getPage(docNo));
            atts.addAttribute("", "no", "no", "CDATA", "" + docNo);
            atts.addAttribute("", "queryId", "queryId", "CDATA", this.id);
            atts.addAttribute("", "docNo", "docNo", "CDATA", "" + docNo);
            hdl.startElement(sdxNsUri, localName, qName, atts);
            if (this.query != null) {
                this.query.toSAX(hdl);
            }
            if (docNo > 1 && this.sortedResults.getDocument(docNo - 2) != null) {
                String childOneLocalName = "previous";
                String childOneQName = sdxNsPrefix + ":" + childOneLocalName;
                AttributesImpl childOneAtts = new AttributesImpl();
                childOneAtts.addAttribute("", "id", "id", "CDATA", this.sortedResults.getDocument(docNo - 2).getFieldValue("sdxdocid"));
                childOneAtts.addAttribute("", "base", "base", "CDATA", this.sortedResults.getDocument(docNo - 2).getFieldValue("sdxdbid"));
                childOneAtts.addAttribute("", "app", "app", "CDATA", this.sortedResults.getDocument(docNo - 2).getFieldValue("sdxappid"));
                childOneAtts.addAttribute("", "no", "no", "CDATA", "" + String.valueOf(docNo - 1));
                childOneAtts.addAttribute("", "page", "page", "CDATA", "" + this.getPage(docNo - 1));
                childOneAtts.addAttribute("", "docId", "docId", "CDATA", this.sortedResults.getDocument(docNo - 2).getFieldValue("sdxdocid"));
                hdl.startElement(sdxNsUri, childOneLocalName, childOneQName, childOneAtts);
                hdl.endElement(sdxNsUri, childOneLocalName, childOneQName);
            }
            if (docNo < nbHits && this.sortedResults.getDocument(docNo) != null) {
                String childTwoLocalName = "next";
                String childTwoQName = sdxNsPrefix + ":" + childTwoLocalName;
                AttributesImpl childTwoAtts = new AttributesImpl();
                childTwoAtts.addAttribute("", "id", "id", "CDATA", this.sortedResults.getDocument(docNo).getFieldValue("sdxdocid"));
                childTwoAtts.addAttribute("", "base", "base", "CDATA", this.sortedResults.getDocument(docNo).getFieldValue("sdxdbid"));
                childTwoAtts.addAttribute("", "app", "app", "CDATA", this.sortedResults.getDocument(docNo).getFieldValue("sdxappid"));
                childTwoAtts.addAttribute("", "no", "no", "CDATA", "" + String.valueOf(docNo + 1));
                childTwoAtts.addAttribute("", "page", "page", "CDATA", "" + this.getPage(docNo + 1));
                childTwoAtts.addAttribute("", "docId", "docId", "CDATA", this.sortedResults.getDocument(docNo).getFieldValue("sdxdocid"));
                hdl.startElement(sdxNsUri, childTwoLocalName, childTwoQName, childTwoAtts);
                hdl.endElement(sdxNsUri, childTwoLocalName, childTwoQName);
            }
            hdl.endElement(sdxNsUri, localName, qName);
        } else if (docNo > -1) {
            // empty if block
        }
    }

    public void getNavigationAsSAX(ContentHandler hdl, String id) throws SDXException, SAXException, ProcessingException, IOException {
        String[] docIds = this.getDocIds();
        for (int i = 0; i < docIds.length; ++i) {
            if (!id.equals(docIds[i])) continue;
            this.getNavigationAsSAX(hdl, i + 1);
            return;
        }
    }

    private int getPage(int docNo) {
        float temp;
        if (docNo < 1) {
            docNo = 1;
        }
        if ((temp = (float)docNo / (float)this.hitsPerPage) != (float)Math.round(temp)) {
            return (int)Math.round(Math.floor(temp) + 1.0);
        }
        return Math.round(temp);
    }

    public void reSort(SortSpecification sorts) throws IOException, SDXException {
        this.sorts = sorts;
        if (this.sorts == null) {
            this.sorts = new SortSpecification();
        }
        this.sorts.enableLogging(this.logger);
        this.sortedResults = this.sorts.sortResults(this.sortedResults);
    }

    public int count() {
        if (this.sortedResults == null) {
            return 0;
        }
        return this.sortedResults.getLength();
    }

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }

    public float getMaxScore() {
        return this.topScore;
    }

    public TermHighlighter getHighliter() {
        return this.highlighter;
    }

    public void setHighliter(TermHighlighter hliter) {
        this.highlighter = hliter;
    }
}

