/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.search.lucene.query;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.search.lucene.DateField;
import fr.gouv.culture.sdx.search.lucene.Field;
import fr.gouv.culture.sdx.search.lucene.filter.Criteria;
import fr.gouv.culture.sdx.search.lucene.filter.Filter;
import fr.gouv.culture.sdx.search.lucene.query.Results;
import fr.gouv.culture.sdx.search.lucene.query.SearchLocations;
import fr.gouv.culture.sdx.search.lucene.query.TermInfo;
import fr.gouv.culture.sdx.utils.Bits;
import fr.gouv.culture.sdx.utils.Date;
import fr.gouv.culture.sdx.utils.SdxObjectImpl;
import fr.gouv.culture.sdx.utils.Utilities;
import java.io.IOException;
import java.text.Collator;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.TreeMap;
import org.apache.avalon.framework.logger.Logger;
import org.apache.cocoon.ProcessingException;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.Hits;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class Terms
extends SdxObjectImpl
implements fr.gouv.culture.sdx.search.Terms {
    private static Logger logger;
    private TreeMap termList;
    private int hitsPerPage = 20;
    private int nbPages;
    public static final int HITS_PER_PAGE = 20;
    private String[] fieldFilters;
    private String[] valueFilters;
    private String id;
    private Filter filter;
    private static Collator sortCollator;
    private SearchLocations searchLocations;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setUp(SearchLocations sLocs, String field) throws SDXException {
        IndexReader reader;
        block18: {
            if (sLocs == null) {
                throw new SDXException(logger, 4000, null, null);
            }
            if (!Utilities.checkString(field)) {
                throw new SDXException(logger, 4200, null, null);
            }
            this.setFieldFilter(field);
            String internedfieldName = field.intern();
            this.searchLocations = sLocs;
            this.initCollator(this.searchLocations.getField(field));
            this.termList = new TreeMap(sortCollator);
            reader = null;
            TermEnum ts = null;
            try {
                try {
                    int nbReaders = this.searchLocations.size();
                    block10: for (int i = 0; i < nbReaders; ++i) {
                        reader = this.searchLocations.getIndexReader(i);
                        if (reader == null) continue;
                        ts = reader.terms(new Term(internedfieldName, ""));
                        boolean collecting = false;
                        if (ts == null) continue;
                        do {
                            if (ts.term() != null && ts.term().field() == internedfieldName) {
                                collecting = true;
                                TermInfo ti = (TermInfo)this.termList.get(ts.term().text());
                                if (ti != null) {
                                    ti.update(reader, ts.term());
                                    continue;
                                }
                                ti = new TermInfo();
                                ti.enableLogging(logger);
                                ti.setUp(reader, ts.term());
                                this.termList.put(ts.term().text(), ti);
                                continue;
                            }
                            if (collecting) continue block10;
                        } while (ts.next());
                    }
                    Object var11_12 = null;
                    if (ts == null) break block18;
                }
                catch (IOException e) {
                    String[] args = new String[]{e.getMessage()};
                    throw new SDXException(null, 4201, args, e);
                }
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                if (ts != null) {
                    try {
                        ts.close();
                    }
                    catch (IOException e) {
                        String[] args = new String[]{e.getMessage()};
                        throw new SDXException(null, 210, args, e);
                    }
                }
                if (reader == null) throw throwable;
                try {
                    reader.close();
                    throw throwable;
                }
                catch (IOException e) {
                    String[] args = new String[]{e.getMessage()};
                    throw new SDXException(null, 211, args, e);
                }
            }
            try {}
            catch (IOException e) {
                String[] args = new String[]{e.getMessage()};
                throw new SDXException(null, 210, args, e);
            }
            ts.close();
        }
        if (reader != null) {
            try {}
            catch (IOException e) {
                String[] args = new String[]{e.getMessage()};
                throw new SDXException(null, 211, args, e);
            }
            reader.close();
        }
        this.nbPages = this.countPages();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setUp(SearchLocations sLocs, String field, String str) throws SDXException {
        if (sLocs == null) {
            throw new SDXException(logger, 4000, null, null);
        }
        if (!Utilities.checkString(field)) {
            throw new SDXException(logger, 4200, null, null);
        }
        this.setFieldFilter(field);
        String internedfieldName = field.intern();
        if (str == null) {
            this.setUp(sLocs, field);
            return;
        }
        this.searchLocations = sLocs;
        this.initCollator(this.searchLocations.getField(field));
        this.termList = new TreeMap(sortCollator);
        IndexReader reader = null;
        TermEnum ts = null;
        RE re = null;
        try {
            re = Terms.getRE(str);
        }
        catch (RESyntaxException e) {
            String[] args = new String[]{e.getMessage()};
            throw new SDXException(null, 4201, args, e);
        }
        int nbReaders = this.searchLocations.size();
        int i = 0;
        while (true) {
            block27: {
                block25: {
                    Object var15_17;
                    if (i >= nbReaders) {
                        this.nbPages = this.countPages();
                        return;
                    }
                    reader = this.searchLocations.getIndexReader(i);
                    if (reader == null) break block27;
                    try {
                        block24: {
                            try {
                                ts = reader.terms(new Term(internedfieldName, ""));
                                Term t = null;
                                boolean collecting = false;
                                if (ts == null) break block24;
                                do {
                                    if (ts.term() != null) {
                                        t = ts.term();
                                    }
                                    if (t != null && t.field() == internedfieldName) {
                                        collecting = true;
                                        String text = t.text();
                                        if (!re.match(text)) continue;
                                        TermInfo ti = (TermInfo)this.termList.get(text);
                                        if (ti != null) {
                                            ti.update(reader, ts.term());
                                            continue;
                                        }
                                        ti = new TermInfo();
                                        ti.enableLogging(logger);
                                        ti.setUp(reader, ts.term());
                                        this.termList.put(text, ti);
                                        continue;
                                    }
                                    if (collecting) break;
                                } while (ts.next());
                            }
                            catch (IOException e) {
                                String[] args = new String[]{e.getMessage()};
                                throw new SDXException(null, 4201, args, e);
                            }
                        }
                        var15_17 = null;
                        if (ts == null) break block25;
                    }
                    catch (Throwable throwable) {
                        var15_17 = null;
                        if (ts != null) {
                            try {
                                ts.close();
                            }
                            catch (IOException e) {
                                String[] args = new String[]{e.getMessage()};
                                throw new SDXException(null, 210, args, e);
                            }
                        }
                        if (reader == null) throw throwable;
                        try {
                            reader.close();
                            throw throwable;
                        }
                        catch (IOException e) {
                            String[] args = new String[]{e.getMessage()};
                            throw new SDXException(null, 211, args, e);
                        }
                    }
                    try {}
                    catch (IOException e) {
                        String[] args = new String[]{e.getMessage()};
                        throw new SDXException(null, 210, args, e);
                    }
                    ts.close();
                }
                if (reader != null) {
                    try {}
                    catch (IOException e) {
                        String[] args = new String[]{e.getMessage()};
                        throw new SDXException(null, 211, args, e);
                    }
                    reader.close();
                }
            }
            ++i;
        }
    }

    protected void setFieldFilter(String field) {
        String[] fields = new String[]{field};
        this.fieldFilters = fields;
    }

    public void setUp(Results results, String field, String value) throws SDXException {
        this.setFieldFilter(field);
        String[] fields = new String[]{field};
        String[] values = new String[]{value};
        this.setUp(results, fields, values);
    }

    public void setUp(Results results, String[] fields, String[] values) throws SDXException {
        if (results != null) {
            this.searchLocations = results.getSearchLocations();
            if (this.searchLocations == null) {
                throw new SDXException(logger, 4000, null, null);
            }
            if (fields == null) {
                throw new SDXException(logger, 4200, null, null);
            }
            if (this.searchLocations.size() > 1) {
                Utilities.logWarn(logger, "Only the first search location will be used...", null);
            }
            this.fieldFilters = fields;
            this.termList = this.getTerms(results.getHits(), fields, values);
            this.nbPages = this.countPages();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setUp(SearchLocations sLocs, String[] fields, String[] values) throws SDXException {
        block11: {
            if (sLocs == null) {
                throw new SDXException(logger, 4000, null, null);
            }
            if (fields == null) {
                throw new SDXException(logger, 4200, null, null);
            }
            this.searchLocations = sLocs;
            if (sLocs.size() > 1) {
                Utilities.logWarn(logger, "Only the first search location will be used...", null);
            }
            this.fieldFilters = fields;
            this.valueFilters = values;
            if (values == null) {
                values = new String[]{};
            }
            if (fields.length != values.length + 1) return;
            BitSet documentSet = null;
            IndexReader r = sLocs.getIndexReader(0);
            if (fields.length > 1) {
                this.filter = new Filter(1);
                for (int i = 0; i < values.length; ++i) {
                    Criteria c = new Criteria();
                    c.enableLogging(logger);
                    c.setUp(sLocs.getField(fields[i]), values[i]);
                    this.filter.add(c);
                }
                documentSet = this.filter.bits(r);
            }
            try {
                this.termList = this.getTerms(r, sLocs.getField(fields[fields.length - 1]), documentSet);
                Object var9_8 = null;
                if (r == null) break block11;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (r == null) throw throwable;
                try {
                    r.close();
                    throw throwable;
                }
                catch (IOException e) {
                    String[] args = new String[]{e.getMessage()};
                    throw new SDXException(null, 211, args, e);
                }
            }
            try {}
            catch (IOException e) {
                String[] args = new String[]{e.getMessage()};
                throw new SDXException(null, 211, args, e);
            }
            r.close();
        }
        this.nbPages = this.countPages();
    }

    public void toSAX(ContentHandler hdl) throws SAXException, ProcessingException {
        this.toSAX(hdl, -1);
    }

    public void toSAX(ContentHandler hdl, int page) throws SAXException, ProcessingException {
        int sIdx;
        String sdxNsUri = "http://www.culture.gouv.fr/ns/sdx/sdx";
        String sdxNsPrefix = "sdx";
        if (page < 1) {
            page = 1;
        }
        if (page > this.nbPages) {
            page = this.nbPages;
        }
        if ((sIdx = (page - 1) * this.hitsPerPage) < 0) {
            sIdx = 0;
        }
        int eIdx = page * this.hitsPerPage - 1;
        if (this.termList != null && eIdx >= this.termList.size()) {
            eIdx = this.termList.size() - 1;
        }
        String localName = "terms";
        String qName = sdxNsPrefix + ":" + localName;
        AttributesImpl atts = new AttributesImpl();
        if (this.fieldFilters != null && this.fieldFilters.length > 0) {
            atts.addAttribute("", "name", "name", "CDATA", this.fieldFilters[this.fieldFilters.length - 1]);
            atts.addAttribute("", "field", "field", "CDATA", this.fieldFilters[this.fieldFilters.length - 1]);
        }
        if (this.id != null) {
            atts.addAttribute("", "qid", "qid", "CDATA", this.id);
        }
        atts.addAttribute("", "page", "page", "CDATA", String.valueOf(page));
        atts.addAttribute("", "hpp", "hpp", "CDATA", String.valueOf(this.hitsPerPage));
        atts.addAttribute("", "pages", "pages", "CDATA", String.valueOf(this.nbPages));
        if (this.termList != null) {
            atts.addAttribute("", "nb", "nb", "CDATA", String.valueOf(this.termList.size()));
        }
        atts.addAttribute("", "start", "start", "CDATA", String.valueOf(sIdx + 1));
        atts.addAttribute("", "end", "end", "CDATA", String.valueOf(eIdx + 1));
        if (this.id != null) {
            atts.addAttribute("", "id", "id", "CDATA", this.id);
        }
        atts.addAttribute("", "currentPage", "currentPage", "CDATA", String.valueOf(page));
        atts.addAttribute("", "nbPages", "nbPages", "CDATA", String.valueOf(this.nbPages));
        hdl.startElement(sdxNsUri, localName, qName, atts);
        if (this.filter != null) {
            this.filter.toSAX(hdl);
        }
        if (this.hitsPerPage != 0 && this.termList != null) {
            Iterator it = this.termList.keySet().iterator();
            int i = 0;
            while (it.hasNext()) {
                if (++i > sIdx && i <= eIdx + 1) {
                    TermInfo term = (TermInfo)this.termList.get(it.next());
                    String subLocalName = "term";
                    String subQName = sdxNsPrefix + ":" + subLocalName;
                    AttributesImpl subAtts = new AttributesImpl();
                    subAtts.addAttribute("", "no", "no", "CDATA", String.valueOf(i));
                    String fieldname = term.getField();
                    int fieldType = -1;
                    try {
                        fieldType = this.searchLocations.getFieldType(fieldname);
                    }
                    catch (SDXException sdxE) {
                        throw new SAXException(sdxE.getMessage(), sdxE);
                    }
                    String content = this.searchLocations != null && fieldType == 2 ? Date.formatDate(DateField.stringToDate(term.getContent())) : term.getContent();
                    String esc = null;
                    esc = Utilities.encodeURL(content, this.encoding);
                    subAtts.addAttribute("", "value", "value", "CDATA", content);
                    subAtts.addAttribute("", "escapedValue", "escapedValue", "CDATA", esc);
                    subAtts.addAttribute("", "field", "field", "CDATA", fieldname);
                    subAtts.addAttribute("", "docs", "docs", "CDATA", String.valueOf(term.getDocFrequency()));
                    if (term.getDocFrequency() == 1) {
                        subAtts.addAttribute("", "id", "id", "CDATA", term.getDocId());
                        subAtts.addAttribute("", "base", "base", "CDATA", term.getDbId());
                        subAtts.addAttribute("", "app", "app", "CDATA", term.getAppId());
                        subAtts.addAttribute("", "docId", "docId", "CDATA", term.getDocId());
                    }
                    subAtts.addAttribute("", "docFreq", "docFreq", "CDATA", String.valueOf(term.getDocFrequency()));
                    hdl.startElement(sdxNsUri, subLocalName, subQName, subAtts);
                    hdl.endElement(sdxNsUri, subLocalName, subQName);
                    continue;
                }
                if (i > eIdx + 1) break;
                it.next();
            }
        }
        hdl.endElement(sdxNsUri, localName, qName);
    }

    public TreeMap getList() {
        return this.termList;
    }

    private static RE getRE(String str) throws RESyntaxException {
        if (str == null) {
            return null;
        }
        StringBuffer st = new StringBuffer("^");
        block5: for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '*': {
                    st.append("(.*)");
                    continue block5;
                }
                case '?': {
                    st.append("(.?)");
                    continue block5;
                }
                case '$': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    st.append('\\');
                    st.append(c);
                    continue block5;
                }
                default: {
                    st.append(c);
                }
            }
        }
        st.append("$");
        return new RE(st.toString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TreeMap getTerms(IndexReader r, Field f, String pattern) throws SDXException {
        TreeMap<Object, TermInfo> ret = null;
        if (r == null) return ret;
        if (f == null) return ret;
        if (pattern == null) {
            return ret;
        }
        String internedfieldName = "";
        if (Utilities.checkString(f.getCode())) {
            internedfieldName = f.getCode().intern();
        }
        ret = f.getLocale() != null ? new TreeMap<Object, TermInfo>(Collator.getInstance(f.getLocale())) : new TreeMap(Collator.getInstance(new Locale("fr", "FR")));
        TermEnum ts = null;
        try {
            block14: {
                try {
                    RE re = Terms.getRE(pattern);
                    ts = r.terms(new Term(internedfieldName, ""));
                    boolean collecting = false;
                    if (ts == null) break block14;
                    do {
                        if (ts.term() != null && ts.term().field() == internedfieldName) {
                            collecting = true;
                            if (ts.term() == null || re == null || !re.match(ts.term().text())) continue;
                            TermInfo ti = (TermInfo)ret.get(ts.term().text());
                            if (ti != null) {
                                ti.update(r, ts.term());
                                continue;
                            }
                            ti = new TermInfo();
                            ti.enableLogging(logger);
                            ti.setUp(r, ts.term());
                            ret.put(ts.term().text(), ti);
                            continue;
                        }
                        if (collecting) break;
                    } while (ts.next());
                }
                catch (RESyntaxException e) {
                    String[] args = new String[]{e.getMessage()};
                    throw new SDXException(null, 4202, args, e);
                }
                catch (IOException e) {
                    String[] args = new String[]{e.getMessage()};
                    throw new SDXException(null, 4202, args, e);
                }
            }
            Object var10_13 = null;
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            try {
                if (ts == null) throw throwable;
                ts.close();
                throw throwable;
            }
            catch (IOException e) {
                String[] args = new String[]{f.getCode(), e.getMessage()};
                throw new SDXException(null, 210, args, e);
            }
        }
        try {}
        catch (IOException e) {
            String[] args = new String[]{f.getCode(), e.getMessage()};
            throw new SDXException(null, 210, args, e);
        }
        if (ts == null) return ret;
        ts.close();
        return ret;
    }

    private TreeMap getTerms(Hits hits, String[] fields, String[] values) throws SDXException {
        TreeMap ret = new TreeMap();
        if (hits == null || hits.length() == 0) {
            return ret;
        }
        Hashtable fieldMaps = new Hashtable();
        for (int i = 0; i < hits.length(); ++i) {
            try {
                Document hitDoc = hits.doc(i);
                if (hitDoc == null) continue;
                for (int j = 0; j < fields.length; ++j) {
                    Field f = this.searchLocations.getField(fields[j]);
                    String lfname = f.getCode();
                    if (f == null) continue;
                    TreeMap<Object, Object> map = null;
                    map = fieldMaps.size() > 0 && fieldMaps.containsKey(lfname) ? (TreeMap<Object, TermInfo>)fieldMaps.get(lfname) : (f.getCollator() == null ? new TreeMap(Collator.getInstance(new Locale("fr", "FR"))) : new TreeMap<Object, TermInfo>(f.getCollator()));
                    String[] fieldsValues = hitDoc.getValues(lfname);
                    if (fieldsValues != null) {
                        HashSet<String> termsCollected = new HashSet<String>();
                        for (int k = 0; k < fieldsValues.length; ++k) {
                            String lftext = fieldsValues[k];
                            if (!Utilities.checkString(lftext) || values != null && values.length != 0 && (j >= values.length || Utilities.checkString(values[j]) && !lftext.equals(values[j])) || termsCollected.contains(lftext)) continue;
                            TermInfo ti = (TermInfo)map.get(lftext);
                            if (ti != null) {
                                ti.update(lfname, lftext);
                            } else {
                                ti = new TermInfo();
                                ti.enableLogging(logger);
                                ti.setUp(lfname, lftext);
                                ti.update(lfname, lftext);
                                ti.setDocId(hitDoc.getField("sdxdocid").stringValue());
                                ti.setDbId(hitDoc.getField("sdxdbid").stringValue());
                                ti.setAppId(hitDoc.getField("sdxappid").stringValue());
                                map.put(lftext, ti);
                            }
                            termsCollected.add(lftext);
                        }
                    }
                    if (map == null) continue;
                    fieldMaps.put(lfname, map);
                }
                continue;
            }
            catch (IOException e) {
                String[] args = new String[]{e.getMessage()};
                new SDXException(null, 4202, args, e);
            }
        }
        Enumeration maps = fieldMaps.elements();
        if (maps != null) {
            while (maps.hasMoreElements()) {
                TreeMap outmap = (TreeMap)maps.nextElement();
                ret.putAll(outmap);
            }
            maps = null;
        }
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TreeMap getTerms(IndexReader r, Field f, BitSet docs) throws SDXException {
        TreeMap<Object, TermInfo> treeMap;
        if (f == null) {
            return new TreeMap();
        }
        String internedfieldName = "";
        if (Utilities.checkString(f.getCode())) {
            internedfieldName = f.getCode().intern();
        }
        TreeMap<Object, TermInfo> ret = f.getCollator() == null ? new TreeMap(Collator.getInstance(new Locale("fr", "FR"))) : new TreeMap<Object, TermInfo>(f.getCollator());
        TermEnum ts = null;
        try {
            try {
                ts = r.terms(new Term(internedfieldName, ""));
                boolean collecting = false;
                do {
                    if (ts.term() != null && ts.term().field() == internedfieldName) {
                        int nbDocs;
                        collecting = true;
                        BitSet termDocumentSet = Terms.getDocumentSet(r, ts.term());
                        if (docs != null) {
                            termDocumentSet.and(docs);
                        }
                        if ((nbDocs = Bits.countBits(termDocumentSet)) <= 0) continue;
                        TermInfo ti = (TermInfo)ret.get(ts.term().text());
                        if (ti != null) {
                            ti.update(r, ts.term());
                            continue;
                        }
                        ti = new TermInfo();
                        ti.enableLogging(logger);
                        ti.setUp(r, ts.term());
                        ret.put(ts.term().text(), ti);
                        continue;
                    }
                    if (collecting) break;
                } while (ts.next());
                treeMap = ret;
                Object var12_13 = null;
            }
            catch (IOException e) {
                String[] args = new String[]{e.getMessage()};
                throw new SDXException(null, 4202, args, e);
            }
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            try {
                if (ts == null) throw throwable;
                ts.close();
                throw throwable;
            }
            catch (IOException e2) {
                String[] args = new String[]{f.getCode(), e2.getMessage()};
                throw new SDXException(null, 210, args, e2);
            }
        }
        try {}
        catch (IOException e2) {
            String[] args = new String[]{f.getCode(), e2.getMessage()};
            throw new SDXException(null, 210, args, e2);
        }
        if (ts == null) return treeMap;
        ts.close();
        return treeMap;
    }

    public static BitSet getDocumentSet(IndexReader r, Term term) throws IOException {
        BitSet bits = new BitSet(r.numDocs());
        TermDocs docs = r.termDocs(term);
        while (docs.next()) {
            bits.set(docs.doc());
        }
        return bits;
    }

    private int countPages() {
        if (this.termList == null) {
            return 0;
        }
        if (this.termList.size() == 0) {
            return 0;
        }
        if (this.hitsPerPage == 0) {
            return 1;
        }
        float temp = (float)this.termList.size() / (float)this.hitsPerPage;
        if (temp != (float)Math.round(temp)) {
            return (int)Math.round(Math.floor(temp) + 1.0);
        }
        return Math.round(temp);
    }

    public void setId(String id) {
        this.id = id;
    }

    public int getHitsPerPage() {
        return this.hitsPerPage;
    }

    public void setHitsPerPage(int nb) {
        if (nb < 0) {
            this.setAllHits();
        } else {
            this.hitsPerPage = nb;
            this.nbPages = this.countPages();
        }
    }

    private void initCollator(Field field) {
        if (field != null) {
            sortCollator = field.getCollator();
        }
    }

    public void setAllHits() {
        if (this.termList != null) {
            this.hitsPerPage = this.termList.size();
        }
        this.nbPages = 1;
    }

    public void enableLogging(Logger logger) {
        Terms.logger = logger;
    }

    public SearchLocations getSearchLocations() {
        return this.searchLocations;
    }
}

