/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.util.apache.cocoon.components.source;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.jar.JarEntry;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.components.source.AbstractStreamSource;
import org.apache.excalibur.source.SourceParameters;
import org.apache.excalibur.source.SourceUtil;

public class URLSource
extends AbstractStreamSource {
    private final String FILE = "file:";
    private long lastModificationDate;
    private long contentLength;
    private boolean isHTMLContent = false;
    private String systemId;
    private URL url;
    private URLConnection connection;
    private boolean isFile;
    private boolean gotInfos;
    private SourceParameters postParameters;
    protected SourceParameters requestProperties;
    private static boolean checkedURLClass = false;
    private static boolean urlSupportsGetUserInfo = false;
    private static Method urlGetUserInfo = null;
    private static Object[] emptyParams = new Object[0];

    public URLSource(URL url, ComponentManager manager) throws IOException {
        super(manager);
        this.systemId = url.toExternalForm();
        this.isFile = this.systemId.startsWith("file:");
        if (this.isFile && (this.systemId.endsWith(".htm") || this.systemId.endsWith(".html"))) {
            this.isHTMLContent = true;
        }
        this.url = url;
        this.gotInfos = false;
    }

    protected boolean isHTMLContent() {
        return this.isHTMLContent;
    }

    private void getInfos() {
        if (!this.gotInfos) {
            if (this.isFile) {
                File file = new File(this.systemId.substring("file:".length()));
                this.lastModificationDate = file.lastModified();
                this.contentLength = file.length();
            } else if (this.postParameters == null) {
                try {
                    if (this.connection == null) {
                        this.connection = this.url.openConnection();
                        String userInfo = this.getUserInfo();
                        this.addRequestProperties();
                        if (this.url.getProtocol().startsWith("http") && userInfo != null) {
                            this.connection.setRequestProperty("Authorization", "Basic " + SourceUtil.encodeBASE64((String)userInfo));
                        }
                    }
                    if (this.connection instanceof JarURLConnection) {
                        JarEntry entry = ((JarURLConnection)this.connection).getJarEntry();
                        this.lastModificationDate = entry.getTime();
                    } else {
                        this.lastModificationDate = this.connection.getLastModified();
                    }
                    this.contentLength = this.connection.getContentLength();
                }
                catch (IOException ignore) {
                    this.lastModificationDate = 0L;
                    this.contentLength = -1L;
                }
            } else {
                this.lastModificationDate = 0L;
                this.contentLength = -1L;
            }
            this.gotInfos = true;
        }
    }

    public long getLastModified() {
        this.getInfos();
        return this.lastModificationDate;
    }

    public long getContentLength() {
        this.getInfos();
        return this.contentLength;
    }

    public InputStream getInputStream() throws IOException, ProcessingException {
        this.getInfos();
        try {
            InputStream input = null;
            if (this.isFile) {
                input = new FileInputStream(this.systemId.substring("file:".length()));
            } else {
                if (this.connection == null) {
                    this.connection = this.url.openConnection();
                    String userInfo = this.getUserInfo();
                    this.addRequestProperties();
                    if (this.url.getProtocol().startsWith("http") && userInfo != null) {
                        this.connection.setRequestProperty("Authorization", "Basic " + SourceUtil.encodeBASE64((String)userInfo));
                    }
                    if (this.connection instanceof HttpURLConnection && this.postParameters != null) {
                        StringBuffer buffer = new StringBuffer(2000);
                        Iterator i = this.postParameters.getParameterNames();
                        boolean first = true;
                        while (i.hasNext()) {
                            String key = (String)i.next();
                            Iterator values = this.postParameters.getParameterValues(key);
                            while (values.hasNext()) {
                                String value = SourceUtil.encode((String)((String)values.next()));
                                if (!first) {
                                    buffer.append('&');
                                }
                                first = false;
                                buffer.append(key.toString());
                                buffer.append('=');
                                buffer.append(value);
                            }
                        }
                        HttpURLConnection httpCon = (HttpURLConnection)this.connection;
                        httpCon.setDoInput(true);
                        if (buffer.length() > 1) {
                            String postString = buffer.toString();
                            httpCon.setRequestMethod("POST");
                            httpCon.setDoOutput(true);
                            httpCon.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
                            httpCon.setRequestProperty("Content-length", Integer.toString(postString.length()));
                            BufferedOutputStream out = new BufferedOutputStream(httpCon.getOutputStream());
                            ((OutputStream)out).write(postString.getBytes());
                            ((OutputStream)out).close();
                        }
                        if ("text/html".equals(httpCon.getContentType())) {
                            this.isHTMLContent = true;
                        }
                        input = httpCon.getInputStream();
                        this.connection = null;
                        return input;
                    }
                }
                if ("text/html".equals(this.connection.getContentType())) {
                    this.isHTMLContent = true;
                }
                input = this.connection.getInputStream();
                this.connection = null;
            }
            return input;
        }
        catch (FileNotFoundException e) {
            throw new ResourceNotFoundException("Resource not found " + this.systemId, (Throwable)e);
        }
    }

    private String getUserInfo() {
        if (checkedURLClass) {
            if (urlSupportsGetUserInfo) {
                try {
                    return (String)urlGetUserInfo.invoke((Object)this.url, emptyParams);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return null;
        }
        try {
            urlGetUserInfo = URL.class.getMethod("getUserInfo", null);
            String ui = (String)urlGetUserInfo.invoke((Object)this.url, emptyParams);
            checkedURLClass = true;
            urlSupportsGetUserInfo = true;
            return ui;
        }
        catch (Exception exception) {
            checkedURLClass = true;
            urlSupportsGetUserInfo = false;
            urlGetUserInfo = null;
            return null;
        }
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void refresh() {
        this.connection = null;
        this.gotInfos = false;
    }

    public void recycle() {
        this.refresh();
    }

    public void setPostParameters(SourceParameters pars) {
        this.postParameters = pars;
    }

    public void setRequestProperties(SourceParameters pars) {
        this.requestProperties = pars;
    }

    protected void addRequestProperties() {
        if (this.connection != null && this.requestProperties != null) {
            Iterator i = this.requestProperties.getParameterNames();
            boolean first = true;
            while (i.hasNext()) {
                String key = (String)i.next();
                Iterator values = this.requestProperties.getParameterValues(key);
                while (values.hasNext()) {
                    String value = (String)values.next();
                    this.connection.setRequestProperty(key, value);
                }
            }
        }
    }
}

