/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.utils.save;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.utils.Utilities;
import java.io.File;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;

public class SaveParameters
extends DefaultConfiguration {
    String _storePath;
    String _storeBasePath;
    long _unique_ID = 0L;

    public SaveParameters(Configuration config, String storeBasePath) throws ConfigurationException {
        super(config.getName(), config.getLocation(), "", "");
        this._storeBasePath = storeBasePath;
        this._storePath = config.getAttribute("path", File.separator);
        this.addAll(config);
    }

    public SaveParameters(Configuration config, SaveParameters parent_config) throws ConfigurationException {
        super(config.getName(), config.getLocation(), "", "");
        if (parent_config != null) {
            parent_config.addChild((Configuration)this);
            this._storeBasePath = parent_config.getStoreBasePath();
            this._storePath = config.getAttribute("path", parent_config.getStorePath());
        }
        this.addAll(config);
    }

    public SaveParameters(String name, String storeBasePath) {
        this(name, null, storeBasePath, null);
    }

    public SaveParameters(String name, SaveParameters parent_config) {
        this(name, parent_config, null, null);
    }

    public SaveParameters(String name, SaveParameters parent_config, String storeRelativeDirectory) {
        this(name, parent_config, null, storeRelativeDirectory);
    }

    public SaveParameters(String name, SaveParameters parent_config, String storeBasePath, String storeRelativeDirectory) {
        super(name);
        this.setAttribute("all", String.valueOf(true));
        if (parent_config != null) {
            parent_config.addChild((Configuration)this);
            this._storePath = storeRelativeDirectory != null ? parent_config.getStorePath() + File.separator + storeRelativeDirectory : parent_config.getStorePath();
            this._storeBasePath = parent_config.getStoreBasePath();
        } else {
            this._storePath = storeRelativeDirectory != null ? storeRelativeDirectory : "";
            this._storeBasePath = storeBasePath;
        }
    }

    public void addAllChildren(Configuration other) {
        this.checkWriteable();
        Configuration[] children = other.getChildren();
        try {
            for (int i = 0; i < children.length; ++i) {
                new SaveParameters(children[i], this);
            }
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
    }

    public SaveParameters getSaveParametersById(String sdxobjectid) throws SDXException {
        SaveParameters saveparams = null;
        for (int i = 0; i < this.getChildren().length; ++i) {
            if (!(this.getChildren()[i] instanceof SaveParameters)) continue;
            saveparams = (SaveParameters)this.getChildren()[i];
            String id = "";
            try {
                id = saveparams.getAttribute("id");
            }
            catch (ConfigurationException e) {
                throw new SDXException("Unable to get ID value in an entity", e);
            }
            if (!id.equals(sdxobjectid)) continue;
            return saveparams;
        }
        return null;
    }

    public String getStorePath() {
        return this._storePath;
    }

    public String getStoreBasePath() {
        return this._storeBasePath;
    }

    public String getStoreCompletePath() {
        return this._storeBasePath + this._storePath;
    }

    public void setUniqueID(long id) {
        this._unique_ID = id;
    }

    public long getUniqueID() {
        return this._unique_ID++;
    }

    public String getUniqueIDString() {
        return String.valueOf(this.getUniqueID());
    }

    public void savePathInConfig(String pathleaf) {
        String path = "";
        path = pathleaf != null ? this._storePath + File.separator + pathleaf : this._storePath;
        path = Utilities.replaceAllSubString(path, File.separator, "/");
        this.setAttribute("path", path);
    }

    public boolean isAllElementSelected() {
        return this.getAttributeAsBoolean("all", false);
    }
}

