/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.disk.hsql;

import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.AuxiliaryCache;
import org.apache.jcs.auxiliary.AuxiliaryCacheManager;
import org.apache.jcs.auxiliary.disk.hsql.HSQLCache;
import org.apache.jcs.auxiliary.disk.hsql.HSQLCacheAttributes;

public class HSQLCacheManager
implements AuxiliaryCacheManager {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$auxiliary$disk$hsql$HSQLCacheManager == null ? (class$org$apache$jcs$auxiliary$disk$hsql$HSQLCacheManager = HSQLCacheManager.class$("org.apache.jcs.auxiliary.disk.hsql.HSQLCacheManager")) : class$org$apache$jcs$auxiliary$disk$hsql$HSQLCacheManager));
    private static int clients;
    private static Hashtable caches;
    private static HSQLCacheManager instance;
    private static HSQLCacheAttributes defaultCattr;
    static /* synthetic */ Class class$org$apache$jcs$auxiliary$disk$hsql$HSQLCacheManager;

    private HSQLCacheManager(HSQLCacheAttributes cattr) {
        defaultCattr = cattr;
    }

    public HSQLCacheAttributes getDefaultCattr() {
        return defaultCattr;
    }

    public static HSQLCacheManager getInstance(HSQLCacheAttributes cattr) {
        if (instance == null) {
            Class clazz = class$org$apache$jcs$auxiliary$disk$hsql$HSQLCacheManager == null ? (class$org$apache$jcs$auxiliary$disk$hsql$HSQLCacheManager = HSQLCacheManager.class$("org.apache.jcs.auxiliary.disk.hsql.HSQLCacheManager")) : class$org$apache$jcs$auxiliary$disk$hsql$HSQLCacheManager;
            synchronized (clazz) {
                if (instance == null) {
                    instance = new HSQLCacheManager(cattr);
                }
            }
        }
        ++clients;
        return instance;
    }

    public AuxiliaryCache getCache(String cacheName) {
        HSQLCacheAttributes cattr = (HSQLCacheAttributes)defaultCattr.copy();
        cattr.setCacheName(cacheName);
        return this.getCache(cattr);
    }

    public AuxiliaryCache getCache(HSQLCacheAttributes cattr) {
        AuxiliaryCache raf = null;
        log.debug((Object)("cacheName = " + cattr.getCacheName()));
        Hashtable hashtable = caches;
        synchronized (hashtable) {
            raf = (AuxiliaryCache)caches.get(cattr.getCacheName());
            if (raf == null) {
                raf = new HSQLCache(cattr);
                caches.put(cattr.getCacheName(), raf);
            }
        }
        return raf;
    }

    public void freeCache(String name) {
        HSQLCache raf = (HSQLCache)caches.get(name);
        if (raf != null) {
            raf.dispose();
        }
    }

    public int getCacheType() {
        return 2;
    }

    public void release() {
        if (--clients != 0) {
            return;
        }
        Hashtable hashtable = caches;
        synchronized (hashtable) {
            Enumeration allCaches = caches.elements();
            while (allCaches.hasMoreElements()) {
                HSQLCache raf = (HSQLCache)allCaches.nextElement();
                if (raf == null) continue;
                raf.dispose();
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        caches = new Hashtable();
    }
}

