/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.source.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.CascadingIOException;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.Cache;
import org.apache.cocoon.caching.CachedResponse;
import org.apache.cocoon.caching.IdentifierCacheKey;
import org.apache.cocoon.components.sax.XMLDeserializer;
import org.apache.cocoon.components.sax.XMLSerializer;
import org.apache.cocoon.components.source.impl.CachedSourceResponse;
import org.apache.cocoon.components.source.impl.Refresher;
import org.apache.cocoon.xml.ContentHandlerWrapper;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceNotFoundException;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.TraversableSource;
import org.apache.excalibur.source.impl.validity.ExpiresValidity;
import org.apache.excalibur.source.impl.validity.TimeStampValidity;
import org.apache.excalibur.xml.sax.XMLizable;
import org.apache.excalibur.xmlizer.XMLizer;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class CachingSource
extends AbstractLogEnabled
implements Source,
Serviceable,
Initializable,
XMLizable {
    protected ServiceManager manager;
    protected SourceResolver resolver;
    protected Cache cache;
    protected Refresher refresher;
    protected Source source;
    protected CachedSourceResponse response;
    protected boolean freshMeta;
    protected final String uri;
    protected final String protocol;
    protected final IdentifierCacheKey cacheKey;
    protected final int expires;
    protected final Parameters parameters;
    protected final boolean async;

    public CachingSource(String protocol, String uri, Source source, Parameters parameters, int expires, boolean async) {
        this.protocol = protocol;
        this.uri = uri;
        this.source = source;
        this.expires = expires;
        this.async = async;
        this.parameters = parameters;
        String key = "source:" + source.getURI();
        String cacheName = parameters.getParameter("cache-name", null);
        if (cacheName != null) {
            key = key + ":" + cacheName;
        }
        this.cacheKey = new IdentifierCacheKey(key, false);
    }

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
    }

    public void initialize() throws Exception {
        boolean checkValidity = true;
        if (this.expires == -1) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Using cached response if available.");
            }
            checkValidity = false;
        }
        if (this.async && this.expires != 0) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Not invalidating cached response for asynch source " + this.getSourceURI());
            }
            checkValidity = false;
        }
        this.response = (CachedSourceResponse)this.cache.get((Serializable)this.cacheKey);
        if (this.response == null) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("No cached response found for source " + this.getSourceURI());
            }
            checkValidity = false;
        }
        if (checkValidity) {
            ExpiresValidity cacheValidity = (ExpiresValidity)this.response.getValidityObjects()[0];
            SourceValidity sourceValidity = this.response.getValidityObjects()[1];
            boolean remove = false;
            if (this.expires == 0) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Force invalidation of cached response of source " + this.getSourceURI());
                }
                remove = true;
            } else {
                boolean expired;
                boolean bl = expired = cacheValidity.isValid() != 1;
                if (expired) {
                    boolean invalid;
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Cached response of source " + this.getSourceURI() + " is expired.");
                    }
                    boolean bl2 = invalid = !CachingSource.isValid(sourceValidity, this.source);
                    if (invalid) {
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("Cached response of source " + this.getSourceURI() + " is invalid.");
                        }
                        remove = true;
                    } else {
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("Cached response of source " + this.getSourceURI() + " is still valid.");
                        }
                        this.response.getValidityObjects()[0] = new ExpiresValidity(this.getExpiration());
                    }
                }
            }
            if (remove) {
                this.response = null;
                if (!this.exists()) {
                    this.cache.remove((Serializable)this.cacheKey);
                }
            }
        }
        if (this.async && this.expires > 0) {
            this.refresher.refresh(this.cacheKey, this.getSourceURI(), this.parameters.getParameter("cache-role", null), this.parameters);
        }
    }

    public void dispose() {
        if (this.source != null) {
            this.resolver.release(this.source);
            this.source = null;
        }
        this.manager = null;
        this.resolver = null;
        this.cache = null;
    }

    protected void initMetaResponse() throws IOException {
        boolean storeResponse = false;
        CachedSourceResponse response = this.response;
        if (response == null) {
            if (this.expires != 0) {
                ExpiresValidity cacheValidity = new ExpiresValidity(this.getExpiration());
                SourceValidity sourceValidity = this.source.getValidity();
                response = new CachedSourceResponse(new SourceValidity[]{cacheValidity, sourceValidity});
                storeResponse = true;
            } else {
                response = new CachedSourceResponse(null);
            }
        }
        if (response.getExtra() == null) {
            response.setExtra(CachingSource.readMeta(this.source));
            this.freshMeta = true;
        }
        if (storeResponse) {
            this.response = response;
            try {
                this.cache.store((Serializable)this.cacheKey, (CachedResponse)this.response);
            }
            catch (ProcessingException e) {
                throw new CascadingIOException("Failure storing response.", (Throwable)e);
            }
        }
    }

    protected void initBinaryResponse() throws IOException {
        boolean storeResponse = false;
        CachedSourceResponse response = this.response;
        if (response == null) {
            if (this.expires != 0) {
                ExpiresValidity cacheValidity = new ExpiresValidity(this.getExpiration());
                SourceValidity sourceValidity = this.source.getValidity();
                response = new CachedSourceResponse(new SourceValidity[]{cacheValidity, sourceValidity});
                storeResponse = true;
            } else {
                response = new CachedSourceResponse(null);
            }
        }
        if (response.getBinaryResponse() == null) {
            response.setBinaryResponse(CachingSource.readBinaryResponse(this.source));
            if (!this.freshMeta) {
                response.setExtra(CachingSource.readMeta(this.source));
            }
        }
        if (storeResponse) {
            this.response = response;
            try {
                this.cache.store((Serializable)this.cacheKey, (CachedResponse)this.response);
            }
            catch (ProcessingException e) {
                throw new CascadingIOException("Failure storing response.", (Throwable)e);
            }
        }
    }

    protected void initXMLResponse(boolean refresh) throws SAXException, IOException, CascadingIOException {
        boolean storeResponse = false;
        CachedSourceResponse response = this.response;
        if (response == null) {
            if (this.expires != 0) {
                ExpiresValidity cacheValidity = new ExpiresValidity(this.getExpiration());
                SourceValidity sourceValidity = this.source.getValidity();
                response = new CachedSourceResponse(new SourceValidity[]{cacheValidity, sourceValidity});
                storeResponse = true;
            } else {
                response = new CachedSourceResponse(null);
            }
        }
        if (response.getXMLResponse() == null || refresh) {
            byte[] binary = response.getBinaryResponse();
            response.setXMLResponse(CachingSource.readXMLResponse(this.source, binary, this.manager));
            if (!this.freshMeta) {
                response.setExtra(CachingSource.readMeta(this.source));
            }
        }
        if (storeResponse) {
            this.response = response;
            try {
                this.cache.store((Serializable)this.cacheKey, (CachedResponse)this.response);
            }
            catch (ProcessingException e) {
                throw new CascadingIOException("Failure storing response.", (Throwable)e);
            }
        }
    }

    public String getScheme() {
        return this.protocol;
    }

    public long getContentLength() {
        return -1L;
    }

    public long getLastModified() {
        try {
            this.initMetaResponse();
        }
        catch (IOException io) {
            return 0L;
        }
        return ((SourceMeta)this.response.getExtra()).getLastModified();
    }

    public String getMimeType() {
        try {
            this.initMetaResponse();
        }
        catch (IOException io) {
            return null;
        }
        return ((SourceMeta)this.response.getExtra()).getMimeType();
    }

    public InputStream getInputStream() throws IOException, SourceException {
        try {
            this.initBinaryResponse();
        }
        catch (IOException se) {
            throw new SourceException("Failure getting input stream", (Throwable)se);
        }
        return new ByteArrayInputStream(this.response.getBinaryResponse());
    }

    public String getURI() {
        return this.uri;
    }

    public boolean exists() {
        return this.source.exists();
    }

    public SourceValidity getValidity() {
        long lastModified = this.getLastModified();
        if (lastModified > 0L) {
            return new TimeStampValidity(lastModified);
        }
        return null;
    }

    public void refresh() {
        this.response = null;
        this.source.refresh();
    }

    public void toSAX(ContentHandler contentHandler) throws SAXException {
        XMLDeserializer deserializer = null;
        try {
            try {
                this.initXMLResponse(false);
                deserializer = (XMLDeserializer)this.manager.lookup(XMLDeserializer.ROLE);
                if (contentHandler instanceof XMLConsumer) {
                    deserializer.setConsumer((XMLConsumer)contentHandler);
                } else {
                    deserializer.setConsumer((XMLConsumer)new ContentHandlerWrapper(contentHandler));
                }
                deserializer.deserialize((Object)this.response.getXMLResponse());
            }
            catch (CascadingIOException e) {
                throw new SAXException(e.getMessage(), (Exception)e.getCause());
            }
            catch (IOException e) {
                throw new SAXException("Failure reading SAX response.", e);
            }
            catch (ServiceException se) {
                throw new SAXException("Missing service dependency: XMLdeserializer.", (Exception)((Object)se));
            }
            Object var7_3 = null;
        }
        catch (Throwable throwable) {
            Object var7_4 = null;
            this.manager.release(deserializer);
            throw throwable;
        }
        this.manager.release((Object)deserializer);
    }

    protected String getSourceURI() {
        return this.source.getURI();
    }

    protected IdentifierCacheKey getCacheKey() {
        return this.cacheKey;
    }

    protected long getExpiration() {
        return this.expires * 1000;
    }

    protected static byte[] readXMLResponse(Source source, byte[] binary, ServiceManager manager) throws SAXException, IOException, CascadingIOException {
        XMLSerializer serializer = null;
        XMLizer xmlizer = null;
        byte[] result = null;
        try {
            try {
                serializer = (XMLSerializer)manager.lookup(XMLSerializer.ROLE);
                if (source instanceof XMLizable) {
                    ((XMLizable)source).toSAX((ContentHandler)serializer);
                } else {
                    String mimeType;
                    if (binary == null) {
                        binary = CachingSource.readBinaryResponse(source);
                    }
                    if ((mimeType = source.getMimeType()) != null) {
                        xmlizer = (XMLizer)manager.lookup(XMLizer.ROLE);
                        xmlizer.toSAX((InputStream)new ByteArrayInputStream(binary), mimeType, source.getURI(), (ContentHandler)serializer);
                    }
                }
                result = (byte[])serializer.getSAXFragment();
            }
            catch (ServiceException se) {
                throw new CascadingIOException("Missing service dependency.", (Throwable)se);
            }
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            manager.release(xmlizer);
            manager.release((Object)serializer);
            throw throwable;
        }
        manager.release((Object)xmlizer);
        manager.release((Object)serializer);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    protected static byte[] readBinaryResponse(Source source) throws IOException, SourceNotFoundException {
        int length;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[2048];
        InputStream inputStream = source.getInputStream();
        while ((length = inputStream.read(buffer)) > -1) {
            void var4_4;
            baos.write(buffer, 0, (int)var4_4);
        }
        baos.flush();
        inputStream.close();
        return baos.toByteArray();
    }

    protected static SourceMeta readMeta(Source source) throws IOException {
        SourceMeta meta;
        if (source instanceof TraversableSource) {
            Collection children;
            TraversableSourceMeta tmeta = new TraversableSourceMeta();
            TraversableSource tsource = (TraversableSource)source;
            tmeta.setName(tsource.getName());
            tmeta.setIsCollection(tsource.isCollection());
            if (tmeta.isCollection() && (children = tsource.getChildren()) != null) {
                String[] names = new String[children.size()];
                Iterator iter = children.iterator();
                int count = 0;
                while (iter.hasNext()) {
                    TraversableSource child = (TraversableSource)iter.next();
                    names[count] = child.getName();
                    ++count;
                }
                tmeta.setChildren(names);
            }
            meta = tmeta;
        } else {
            meta = new SourceMeta();
        }
        long lastModified = source.getLastModified();
        if (lastModified > 0L) {
            meta.setLastModified(lastModified);
        } else {
            meta.setLastModified(System.currentTimeMillis());
        }
        meta.setMimeType(source.getMimeType());
        return meta;
    }

    protected static boolean isValid(SourceValidity validity, Source source) {
        if (validity == null) {
            return false;
        }
        return validity.isValid() == 1 || validity.isValid() == 0 && validity.isValid(source.getValidity()) == 1;
    }

    protected static class TraversableSourceMeta
    extends SourceMeta {
        private String m_name;
        private boolean m_isCollection;
        private String[] m_children;

        protected TraversableSourceMeta() {
        }

        protected String getName() {
            return this.m_name;
        }

        protected void setName(String name) {
            this.m_name = name;
        }

        protected boolean isCollection() {
            return this.m_isCollection;
        }

        protected void setIsCollection(boolean isCollection) {
            this.m_isCollection = isCollection;
        }

        protected String[] getChildren() {
            return this.m_children;
        }

        protected void setChildren(String[] children) {
            this.m_children = children;
        }
    }

    protected static class SourceMeta
    implements Serializable {
        private String m_mimeType;
        private long m_lastModified;
        private boolean m_exists;

        protected SourceMeta() {
        }

        protected String getMimeType() {
            return this.m_mimeType;
        }

        protected void setMimeType(String mimeType) {
            this.m_mimeType = mimeType;
        }

        protected long getLastModified() {
            return this.m_lastModified;
        }

        protected void setLastModified(long lastModified) {
            this.m_lastModified = lastModified;
        }

        protected boolean exists() {
            return this.m_exists;
        }

        protected void setExists(boolean exists) {
            this.m_exists = exists;
        }
    }
}

