/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.generation;

import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.flow.FlowHelper;
import org.apache.cocoon.components.flow.WebContinuation;
import org.apache.cocoon.components.jxdom.DocumentAdapter;
import org.apache.cocoon.environment.Context;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.environment.Session;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.generation.Generator;
import org.apache.cocoon.transformation.TraxTransformer;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.commons.jxpath.DynamicPropertyHandler;
import org.apache.commons.jxpath.JXPathBeanInfo;
import org.apache.commons.jxpath.JXPathIntrospector;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class TraxGenerator
extends TraxTransformer
implements Generator {
    DocumentAdapter doc;

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters parameters) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, parameters);
        Object bean = FlowHelper.getContextObject((Map)objectModel);
        WebContinuation kont = FlowHelper.getWebContinuation((Map)objectModel);
        HashMap<String, Object> map = new HashMap<String, Object>();
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        Response response = ObjectModelHelper.getResponse((Map)objectModel);
        Context context = ObjectModelHelper.getContext((Map)objectModel);
        if (bean != null) {
            this.fillContext(bean, map);
            map.put("flowContext", bean);
            map.put("continuation", kont);
        }
        map.put("request", request);
        map.put("response", response);
        map.put("context", context);
        Session session = request.getSession(false);
        if (session != null) {
            map.put("session", session);
        }
        this.doc = new DocumentAdapter(map, "document");
    }

    private void fillContext(Object contextObject, Map map) {
        if (contextObject == null) {
            return;
        }
        JXPathBeanInfo bi = JXPathIntrospector.getBeanInfo(contextObject.getClass());
        if (bi.isDynamic()) {
            Class cl = bi.getDynamicPropertyHandlerClass();
            try {
                DynamicPropertyHandler h = (DynamicPropertyHandler)cl.newInstance();
                String[] result = h.getPropertyNames(contextObject);
                int i = 0;
                while (i < result.length) {
                    try {
                        map.put(result[i], h.getProperty(contextObject, result[i]));
                    }
                    catch (Exception exc) {
                        exc.printStackTrace();
                    }
                    ++i;
                }
            }
            catch (Exception ignored) {
                ignored.printStackTrace();
            }
        } else {
            PropertyDescriptor[] props = bi.getPropertyDescriptors();
            int i = 0;
            while (i < props.length) {
                try {
                    Method read = props[i].getReadMethod();
                    if (read != null) {
                        map.put(props[i].getName(), read.invoke(contextObject, null));
                    }
                }
                catch (Exception ignored) {
                    ignored.printStackTrace();
                }
                ++i;
            }
        }
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        Transformer transformer = this.transformerHandler.getTransformer();
        DOMSource src = new DOMSource(this.doc);
        SAXResult result = new SAXResult((ContentHandler)this.xmlConsumer);
        try {
            transformer.transform(src, result);
        }
        catch (TransformerException exc) {
            throw new SAXException(exc.getMessage(), exc);
        }
    }

    public void setConsumer(XMLConsumer consumer) {
        this.xmlConsumer = consumer;
    }

    public void recycle() {
        super.recycle();
        this.doc = null;
    }
}

