/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.portal.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.components.persistence.RequestDataStore;
import org.apache.cocoon.portal.PortalComponentManager;
import org.apache.cocoon.portal.PortalService;
import org.apache.cocoon.portal.impl.DefaultPortalComponentManager;
import org.apache.cocoon.portal.impl.PortalServiceInfo;

public class PortalServiceImpl
extends AbstractLogEnabled
implements Serviceable,
ThreadSafe,
PortalService,
Contextualizable,
Disposable,
Configurable {
    protected Context context;
    protected ServiceManager manager;
    protected Map portalComponentManagers = new HashMap();
    protected RequestDataStore dataStore;
    protected final String key = this.getClass().getName();

    public void service(ServiceManager serviceManager) throws ServiceException {
        this.manager = serviceManager;
        this.dataStore = (RequestDataStore)this.manager.lookup(RequestDataStore.ROLE);
    }

    protected PortalServiceInfo getInfo() {
        PortalServiceInfo info = (PortalServiceInfo)this.dataStore.getRequestData(this.key);
        if (info == null) {
            info = new PortalServiceInfo();
            info.setup(ContextHelper.getObjectModel((Context)this.context), this.portalComponentManagers);
            this.dataStore.setRequestData(this.key, (Object)info);
        }
        return info;
    }

    public String getPortalName() {
        return this.getInfo().getPortalName();
    }

    public void setPortalName(String value) {
        this.getInfo().setPortalName(value);
    }

    public Object getAttribute(String key) {
        return this.getInfo().getAttribute(key);
    }

    public void setAttribute(String key, Object value) {
        this.getInfo().setAttribute(key, value);
    }

    public void removeAttribute(String key) {
        this.getInfo().removeAttribute(key);
    }

    public Iterator getAttributeNames() {
        return this.getInfo().getAttributeNames();
    }

    public Object getTemporaryAttribute(String key) {
        return this.getInfo().getTemporaryAttribute(key);
    }

    public void setTemporaryAttribute(String key, Object value) {
        this.getInfo().setTemporaryAttribute(key, value);
    }

    public void removeTemporaryAttribute(String key) {
        this.getInfo().removeTemporaryAttribute(key);
    }

    public Iterator getTemporaryAttributeNames() {
        return this.getInfo().getTemporaryAttributeNames();
    }

    public PortalComponentManager getComponentManager() {
        return this.getInfo().getComponentManager();
    }

    public void contextualize(Context context) throws ContextException {
        this.context = context;
    }

    public void dispose() {
        if (this.manager != null) {
            this.manager.release((Object)this.dataStore);
            this.manager = null;
            this.dataStore = null;
        }
        Iterator i = this.portalComponentManagers.values().iterator();
        while (i.hasNext()) {
            ContainerUtil.dispose(i.next());
        }
        this.portalComponentManagers.clear();
    }

    public void configure(Configuration config) throws ConfigurationException {
        Configuration[] portals = config.getChild("portals").getChildren("portal");
        int i = 0;
        while (i < portals.length) {
            Configuration current = portals[i];
            String name = current.getAttribute("name");
            try {
                DefaultPortalComponentManager c = new DefaultPortalComponentManager();
                this.portalComponentManagers.put(name, c);
                ContainerUtil.enableLogging((Object)c, (Logger)this.getLogger());
                ContainerUtil.contextualize((Object)c, (Context)this.context);
                ContainerUtil.service((Object)c, (ServiceManager)this.manager);
                ContainerUtil.configure((Object)c, (Configuration)current);
                ContainerUtil.initialize((Object)c);
            }
            catch (Exception e) {
                throw new ConfigurationException("Unable to setup new portal component manager for portal " + name, (Throwable)e);
            }
            ++i;
        }
    }
}

