/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor.variables;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.ComponentSelector;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.modules.input.InputModule;
import org.apache.cocoon.components.treeprocessor.InvokeContext;
import org.apache.cocoon.components.treeprocessor.variables.VariableResolver;
import org.apache.cocoon.sitemap.PatternException;

public final class PreparedVariableResolver
extends VariableResolver
implements Disposable {
    private ComponentManager manager;
    private ComponentSelector selector;
    private List tokens;
    private boolean needsMapStack;
    private static final int OPEN = -2;
    private static final int CLOSE = -3;
    private static final int COLON = -4;
    private static final int TEXT = -5;
    private static final int EVAL = -6;
    private static final int EXPR = -7;
    private static final int SITEMAP_VAR = -8;
    private static final int PREFIXED_SITEMAP_VAR = -9;
    private static final int THREADSAFE_MODULE = -10;
    private static final int STATEFUL_MODULE = -11;
    private static final int ROOT_SITEMAP_VARIABLE = 0;
    private static final int ANCHOR_VAR = -1;
    private static Token COLON_TOKEN = new Token(-4);
    private static Token OPEN_TOKEN = new Token(-2);
    private static Token CLOSE_TOKEN = new Token(-3);
    private static Token EMPTY_TOKEN = new Token(-7);

    public PreparedVariableResolver(String expr, ComponentManager manager) throws PatternException {
        super(expr);
        this.manager = manager;
        this.selector = null;
        int openCount = 0;
        int closeCount = 0;
        this.needsMapStack = false;
        this.tokens = new ArrayList();
        int pos = 0;
        boolean escape = false;
        int i = 0;
        while (i < expr.length()) {
            int lastTokenType;
            char c = expr.charAt(i);
            if (escape) {
                escape = false;
            } else if (c == '\\' && i < expr.length()) {
                char nextChar = expr.charAt(i + 1);
                if (nextChar == '{' || nextChar == '}') {
                    expr = expr.substring(0, i) + expr.substring(i + 1);
                    escape = true;
                    --i;
                }
            } else if (c == '{') {
                if (i > pos) {
                    this.tokens.add(new Token(expr.substring(pos, i)));
                }
                ++openCount;
                this.tokens.add(OPEN_TOKEN);
                int colonPos = this.indexOf(expr, ":", i);
                int closePos = this.indexOf(expr, "}", i);
                int openPos = this.indexOf(expr, "{", i);
                if (openPos < colonPos && openPos < closePos) {
                    throw new PatternException("Invalid '{' at position " + i + " in expression " + expr);
                }
                if (colonPos < closePos) {
                    Token token;
                    String module = expr.substring(i + 1, colonPos);
                    if (module.equals("sitemap")) {
                        this.needsMapStack = true;
                        token = new Token(-9);
                    } else if (module.startsWith("#")) {
                        this.needsMapStack = true;
                        token = new Token(-1, module.substring(1));
                    } else {
                        token = this.getNewModuleToken(module);
                    }
                    this.tokens.add(token);
                    i = colonPos - 1;
                } else {
                    this.needsMapStack = true;
                    this.tokens.add(this.getNewSitemapToken(expr.substring(i + 1, closePos)));
                    i = closePos - 1;
                }
                pos = i + 1;
            } else if (c == '}') {
                if (i <= 0 || expr.charAt(i - 1) != '\\') {
                    if (i > pos) {
                        this.tokens.add(new Token(expr.substring(pos, i)));
                    }
                    ++closeCount;
                    this.tokens.add(CLOSE_TOKEN);
                    pos = i + 1;
                }
            } else if (c == ':' && (this.tokens.size() <= 0 || (lastTokenType = ((Token)this.tokens.get(this.tokens.size() - 1)).getType()) == -9 || lastTokenType == -1 || lastTokenType == -10 || lastTokenType == -11) && i == pos && this.tokens.size() != 0) {
                if (i > pos) {
                    this.tokens.add(new Token(expr.substring(pos, i)));
                }
                this.tokens.add(COLON_TOKEN);
                pos = i + 1;
            }
            ++i;
        }
        if (i > pos) {
            this.tokens.add(new Token(expr.substring(pos, i)));
        }
        if (openCount != closeCount) {
            throw new PatternException("Mismatching braces in expression: " + expr);
        }
    }

    private int indexOf(String expr, String chr, int pos) {
        int location = expr.indexOf(chr, pos + 1);
        return location != -1 ? location : expr.length();
    }

    private Token getNewSitemapToken(String variable) {
        if (variable.startsWith("/")) {
            return new Token(0, variable.substring(1));
        }
        int level = 1;
        int pos = 0;
        while (variable.startsWith("../", pos)) {
            ++level;
            pos += "../".length();
        }
        return new Token(level, variable.substring(pos));
    }

    private Token getNewModuleToken(String moduleName) throws PatternException {
        Token token;
        InputModule module;
        if (this.selector == null) {
            try {
                this.selector = (ComponentSelector)this.manager.lookup(InputModule.ROLE + "Selector");
            }
            catch (ComponentException ce) {
                throw new PatternException("Cannot access input modules selector", ce);
            }
        }
        try {
            module = (InputModule)this.selector.select((Object)moduleName);
        }
        catch (ComponentException ce) {
            throw new PatternException("Cannot get InputModule named '" + moduleName + "' in expression '" + this.originalExpr + "'", ce);
        }
        if (module instanceof ThreadSafe) {
            token = new Token(-10, module);
        } else {
            this.selector.release((Component)module);
            token = new Token(-11, moduleName);
        }
        return token;
    }

    public final String resolve(InvokeContext context, Map objectModel) throws PatternException {
        List mapStack = null;
        int stackSize = 0;
        if (this.needsMapStack) {
            if (context == null) {
                throw new PatternException("Need an invoke context to resolve " + this);
            }
            mapStack = context.getMapStack();
            stackSize = mapStack.size();
        }
        Stack<Token> stack = new Stack<Token>();
        Iterator i = this.tokens.iterator();
        while (i.hasNext()) {
            Token token = (Token)i.next();
            switch (token.getType()) {
                case -5: {
                    if (stack.empty()) {
                        stack.push(new Token(-7, token.getStringValue()));
                        break;
                    }
                    Token last = (Token)stack.peek();
                    if (last.hasType(-7)) {
                        last.merge(token);
                        break;
                    }
                    stack.push(new Token(-7, token.getStringValue()));
                    break;
                }
                case -3: {
                    Token result;
                    Token expr = (Token)stack.pop();
                    Token lastButOne = (Token)stack.pop();
                    if (expr.hasType(-4)) {
                        stack.pop();
                        result = this.processModule(lastButOne, EMPTY_TOKEN, objectModel, context, mapStack, stackSize);
                    } else if (lastButOne.hasType(-4)) {
                        Token module = (Token)stack.pop();
                        stack.pop();
                        result = this.processModule(module, expr, objectModel, context, mapStack, stackSize);
                    } else {
                        result = this.processVariable(expr, mapStack, stackSize);
                    }
                    if (stack.empty()) {
                        stack.push(result);
                        break;
                    }
                    Token last = (Token)stack.peek();
                    if (last.hasType(-7)) {
                        last.merge(result);
                        break;
                    }
                    stack.push(result);
                    break;
                }
                default: {
                    stack.push(token);
                }
            }
        }
        if (stack.size() != 1) {
            throw new PatternException("Evaluation error in expression: " + this.originalExpr);
        }
        return ((Token)stack.pop()).getStringValue();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Token processModule(Token module, Token expr, Map objectModel, InvokeContext context, List mapStack, int stackSize) throws PatternException {
        Token token;
        int type = module.getType();
        if (type == -1) {
            String string;
            Map levelResult = context.getMapByAnchor(module.getStringValue());
            if (levelResult == null) {
                throw new PatternException("Error while evaluating '" + this.originalExpr + "' : no anchor '" + String.valueOf(module.getStringValue()) + "' found in context");
            }
            Object result = levelResult.get(expr.getStringValue());
            if (result == null) {
                string = "";
                return new Token(-7, string);
            }
            string = result.toString();
            return new Token(-7, string);
        }
        if (type == -10) {
            try {
                String string;
                InputModule im = module.getModule();
                Object result = im.getAttribute(expr.getStringValue(), null, objectModel);
                if (result == null) {
                    string = "";
                    return new Token(-7, string);
                }
                string = result.toString();
                return new Token(-7, string);
            }
            catch (ConfigurationException confEx) {
                throw new PatternException("Cannot get variable '" + expr.getStringValue() + "' in expression '" + this.originalExpr + "'", confEx);
            }
        }
        if (type == -11) {
            Token token2;
            InputModule im = null;
            String moduleName = module.getStringValue();
            try {
                try {
                    im = (InputModule)this.selector.select((Object)moduleName);
                    Object result = im.getAttribute(expr.getStringValue(), null, objectModel);
                    token2 = new Token(-7, result == null ? "" : result.toString());
                    Object var13_23 = null;
                }
                catch (ComponentException compEx) {
                    throw new PatternException("Cannot get module '" + moduleName + "' in expression '" + this.originalExpr + "'", compEx);
                }
                catch (ConfigurationException confEx) {
                    throw new PatternException("Cannot get variable '" + expr.getStringValue() + "' in expression '" + this.originalExpr + "'", confEx);
                }
            }
            catch (Throwable throwable) {
                Object var13_24 = null;
                this.selector.release((Component)im);
                throw throwable;
            }
            this.selector.release((Component)im);
            return token2;
        }
        if (type != -9) throw new PatternException("Unknown token type: " + expr.getType());
        String variable = expr.getStringValue();
        if (variable.startsWith("/")) {
            token = new Token(0, variable.substring(1));
            return this.processVariable(token, mapStack, stackSize);
        }
        int level = 1;
        int pos = 0;
        while (true) {
            if (!variable.startsWith("../", pos)) {
                token = new Token(level, variable.substring(pos));
                return this.processVariable(token, mapStack, stackSize);
            }
            ++level;
            pos += "../".length();
        }
    }

    private Token processVariable(Token expr, List mapStack, int stackSize) throws PatternException {
        int type = expr.getType();
        String value = expr.getStringValue();
        if (type == 0) {
            Object result = ((Map)mapStack.get(0)).get(value);
            return new Token(-7, result == null ? "" : result.toString());
        }
        if (type > stackSize) {
            throw new PatternException("Error while evaluating '" + this.originalExpr + "' : not so many levels");
        }
        Object result = ((Map)mapStack.get(stackSize - type)).get(value);
        return new Token(-7, result == null ? "" : result.toString());
    }

    public final void dispose() {
        if (this.selector != null) {
            Iterator i = this.tokens.iterator();
            while (i.hasNext()) {
                Token token = (Token)i.next();
                if (!token.hasType(-10)) continue;
                InputModule im = token.getModule();
                this.selector.release((Component)im);
            }
            this.manager.release((Component)this.selector);
            this.selector = null;
            this.manager = null;
        }
    }

    private static class Token {
        private Object value;
        private int type;

        public Token(int type) {
            this.value = type == -7 ? "" : null;
            this.type = type;
        }

        public Token(int type, String value) {
            this.value = value;
            this.type = type;
        }

        public Token(int type, InputModule module) {
            this.value = module;
            this.type = type;
        }

        public Token(char c) {
            this.value = null;
            if (c == '{') {
                this.type = -2;
            } else if (c == '}') {
                this.type = -3;
            } else if (c == ':') {
                this.type = -4;
            }
        }

        public Token(String value) {
            this.type = -5;
            this.value = value;
        }

        public int getType() {
            return this.type;
        }

        public String getStringValue() {
            if (this.value instanceof String) {
                return (String)this.value;
            }
            return null;
        }

        public boolean hasType(int type) {
            return this.type == type;
        }

        public boolean equals(Object o) {
            if (o instanceof Token) {
                return ((Token)o).hasType(this.type);
            }
            return false;
        }

        public void merge(Token newToken) {
            this.value = this.value + newToken.getStringValue();
        }

        public InputModule getModule() {
            if (this.value instanceof InputModule) {
                return (InputModule)this.value;
            }
            return null;
        }
    }
}

