/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.source.impl;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.ServiceSelector;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceFactory;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.SourceUtil;
import org.apache.excalibur.source.URIAbsolutizer;

public class SourceResolverImpl
extends AbstractLogEnabled
implements Serviceable,
Contextualizable,
Disposable,
SourceResolver,
ThreadSafe {
    protected ServiceManager m_manager;
    protected ServiceSelector m_factorySelector;
    protected URL m_baseURL;

    public void contextualize(Context context) throws ContextException {
        try {
            this.m_baseURL = context.get((Object)"context-root") instanceof URL ? (URL)context.get((Object)"context-root") : ((File)context.get((Object)"context-root")).toURL();
        }
        catch (ContextException ce) {
            try {
                this.m_baseURL = new File(System.getProperty("user.dir")).toURL();
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("SourceResolver: Using base URL: " + this.m_baseURL);
                }
            }
            catch (MalformedURLException mue) {
                this.getLogger().warn("Malformed URL for user.dir, and no container.rootDir exists", (Throwable)mue);
                throw new ContextException("Malformed URL for user.dir, and no container.rootDir exists", (Throwable)mue);
            }
        }
        catch (MalformedURLException mue) {
            this.getLogger().warn("Malformed URL for container.rootDir", (Throwable)mue);
            throw new ContextException("Malformed URL for container.rootDir", (Throwable)mue);
        }
    }

    public void service(ServiceManager manager) throws ServiceException {
        this.m_manager = manager;
        if (this.m_manager.hasService(SourceFactory.ROLE + "Selector")) {
            this.m_factorySelector = (ServiceSelector)this.m_manager.lookup(SourceFactory.ROLE + "Selector");
        }
    }

    public void dispose() {
        if (null != this.m_manager) {
            this.m_manager.release((Object)this.m_factorySelector);
            this.m_factorySelector = null;
        }
    }

    public Source resolveURI(String location) throws MalformedURLException, IOException, SourceException {
        return this.resolveURI(location, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Source resolveURI(String location, String baseURI, Map parameters) throws MalformedURLException, IOException, SourceException {
        SourceFactory factory;
        Source source;
        String systemID;
        block18: {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Resolving '" + location + "' with base '" + baseURI + "' in context '" + this.m_baseURL + "'");
            }
            if (location == null) {
                throw new MalformedURLException("Invalid System ID");
            }
            if (null != baseURI && SourceUtil.indexOfSchemeColon(baseURI) == -1) {
                throw new MalformedURLException("BaseURI is not valid, it must contain a protocol: " + baseURI);
            }
            if (baseURI == null) {
                baseURI = this.m_baseURL.toExternalForm();
            }
            systemID = location;
            if (location.length() > 1 && location.charAt(1) == ':') {
                systemID = "file:/" + location;
            } else if (location.length() > 2 && location.charAt(0) == '/' && location.charAt(2) == ':') {
                systemID = "file:" + location;
            }
            int protocolPos = SourceUtil.indexOfSchemeColon(systemID);
            String protocol = protocolPos != -1 ? systemID.substring(0, protocolPos) : ((protocolPos = SourceUtil.indexOfSchemeColon(baseURI)) != -1 ? baseURI.substring(0, protocolPos) : "*");
            source = null;
            factory = null;
            try {
                try {
                    factory = (SourceFactory)this.m_factorySelector.select((Object)protocol);
                    systemID = this.absolutize(factory, baseURI, systemID);
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Resolved to systemID : " + systemID);
                    }
                    source = factory.getSource(systemID, parameters);
                }
                catch (ServiceException ce) {
                    Object var11_10 = null;
                    this.m_factorySelector.release((Object)factory);
                    break block18;
                }
                Object var11_9 = null;
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                this.m_factorySelector.release((Object)factory);
                throw throwable;
            }
            this.m_factorySelector.release((Object)factory);
        }
        if (null != source) return source;
        try {
            try {
                factory = (SourceFactory)this.m_factorySelector.select((Object)"*");
                systemID = this.absolutize(factory, baseURI, systemID);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Resolved to systemID : " + systemID);
                }
                source = factory.getSource(systemID, parameters);
            }
            catch (ServiceException se) {
                throw new SourceException("Unable to select source factory for " + systemID, se);
            }
            Object var13_15 = null;
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            this.m_factorySelector.release((Object)factory);
            throw throwable;
        }
        this.m_factorySelector.release((Object)factory);
        return source;
    }

    private String absolutize(SourceFactory factory, String baseURI, String systemID) {
        systemID = factory instanceof URIAbsolutizer ? ((URIAbsolutizer)((Object)factory)).absolutize(baseURI, systemID) : SourceUtil.absolutize(baseURI, systemID);
        return systemID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void release(Source source) {
        if (source == null) {
            return;
        }
        String scheme = source.getScheme();
        SourceFactory factory = null;
        try {
            try {
                factory = (SourceFactory)this.m_factorySelector.select((Object)scheme);
                factory.release(source);
            }
            catch (ServiceException se) {
                try {
                    factory = (SourceFactory)this.m_factorySelector.select((Object)"*");
                    factory.release(source);
                }
                catch (ServiceException sse) {
                    throw new CascadingRuntimeException("Unable to select source factory for " + source.getURI(), (Throwable)se);
                }
                Object var7_5 = null;
                this.m_factorySelector.release((Object)factory);
                return;
            }
            Object var7_4 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this.m_factorySelector.release((Object)factory);
            throw throwable;
        }
        this.m_factorySelector.release((Object)factory);
    }
}

