package fr.gouv.culture.sdx.search.lucene.analysis;

import java.io.IOException;
import java.io.StringReader;

import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;

import fr.gouv.culture.sdx.search.lucene.analysis.AbstractAnalyzer;
import fr.gouv.culture.sdx.search.lucene.analysis.Analyzer_ar;
import fr.gouv.culture.sdx.search.lucene.analysis.Analyzer_br;
import fr.gouv.culture.sdx.search.lucene.analysis.Analyzer_cz;
import fr.gouv.culture.sdx.search.lucene.analysis.Analyzer_de;
import fr.gouv.culture.sdx.search.lucene.analysis.Analyzer_en;
import fr.gouv.culture.sdx.search.lucene.analysis.Analyzer_fr;
import fr.gouv.culture.sdx.search.lucene.analysis.DefaultAnalyzer;


/**
 * On souhaite passer une String dans un analyseur de mots depuis une feuille XSLT.
 * @author Malo Pichot
 * @see fr.gouv.culture.sdx.search.lucene.analysis.AbstractAnalyzer
 * @see fr.gouv.culture.sdx.search.lucene.analysis.DefaultAnalyzer
 * @see fr.gouv.culture.sdx.search.lucene.analysis.Analyzer_ar
 * @see fr.gouv.culture.sdx.search.lucene.analysis.Analyzer_br
 * @see fr.gouv.culture.sdx.search.lucene.analysis.Analyzer_cz
 * @see fr.gouv.culture.sdx.search.lucene.analysis.Analyzer_de
 * @see fr.gouv.culture.sdx.search.lucene.analysis.Analyzer_en
 * @see fr.gouv.culture.sdx.search.lucene.analysis.Analyzer_fr
 */
public class AnalyzeString {

	/** Retourne la String à sa sortie de l'analyseur de mots par défaut : Analyzer_fr
	 * @param content La string à analyser.
	 * @return Si la String n'est pas vide retourne la String à sa sortie de l'analyseur de mots français.
	 */
	public static String getAnalyzedString(String content){

		if(!content.trim().equals(""))
			return getAnalyzedString(content, "Analyzer_fr");
		else return "";

	}

	/** Retourne la String sortie de l'analyseur correspondant
	 * @param content La String à analyser
	 * @param className le nom de la class représentant l'analyseur souhaité (p.e., Analyzer_fr pour l'analyseur français)
	 * @return Retourne la String à sa sortie de l'analyseur de mots. Si la String est vide, on la retourne telle quelle. S'il y a un problème de lecture dans le processus, on retourne "-1".
	 */
	public static String getAnalyzedString(String content, String className){

		//System.out.println("dans getAnalyzedString avec content="+content+" className="+className);

		if( !content.trim().equals("") ){
			String result = content;
			StringReader str = new StringReader(content);
			Token tmpToken;
			StringBuffer strb = new StringBuffer(content.length());
			AbstractAnalyzer _analyzer = null;

			//On choisit l'analyseur de mots suivant le nom de classe reçu
			if( className.equals("Analyzer_ar") ){
				_analyzer = new Analyzer_ar();
			}
			else if( className.equals("Analyzer_br") ){
				//_analyzer = new Analyzer_br();
				System.out.println("L'analyseur Brésilien ne fonctionne pas :-(");
				_analyzer = new DefaultAnalyzer();
			}
			else if( className.equals("Analyzer_cz") ){
				_analyzer = new Analyzer_cz();
			}
			else if( className.equals("Analyzer_de") ){
				_analyzer = new Analyzer_de();
			}
			else if( className.equals("Analyzer_en") ){
				_analyzer = new Analyzer_en();
			}
			else if( className.equals("Analyzer_fr") ){
				_analyzer = new Analyzer_fr();
			}
			else if( className.equals("Analyzer_ru") ){
				_analyzer = new Analyzer_ar();
			}
			else{// Par défaut, on prend l'analyseur français
				_analyzer = new Analyzer_fr();
			}

			//On envoie le tout dans l'analyseur de mots.
			TokenStream tmpTokenStream = _analyzer.tokenStream("dummy", str);

			//Maintenant, on va récupérer la sortie et en faire une String
			try {

				while( (tmpToken = tmpTokenStream.next())!=null ){
					if( !tmpToken.termText().trim().equals("") )
						strb.append(tmpToken.termText());
				}

				result = strb.toString();

			} catch (IOException e) {//Problème de lecture, on renvoie "-1"
				System.err.println(e);
				result = "-1";
			}

			//C'est fini !
			return result;
		}
		//content est vide
		else return "";

	}

}
