/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.pipeline;

import fr.gouv.culture.sdx.application.Application;
import fr.gouv.culture.sdx.document.AbstractIndexableDocument;
import fr.gouv.culture.sdx.document.Document;
import fr.gouv.culture.sdx.document.HTMLDocument;
import fr.gouv.culture.sdx.document.XMLDocument;
import fr.gouv.culture.sdx.documentbase.DocumentBase;
import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.framework.FrameworkImpl;
import fr.gouv.culture.sdx.pipeline.AbstractTransformation;
import fr.gouv.culture.sdx.utils.Utilities;
import fr.gouv.culture.sdx.utils.configuration.ConfigurationUtils;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class DeleteResultsTransformation
extends AbstractTransformation {
    private String deleteAppId = "";
    private boolean withinSdxInternalField = false;
    private String currentField = "";
    private String appId = "";
    private String dbId = "";
    private String docId = "";
    private String doctype = "";
    private Hashtable deletions = null;

    public void setApplicationId(String appId) throws SDXException {
        if (!Utilities.checkString(appId)) {
            throw new SDXException(super.getLog(), 8100, null, null);
        }
        this.deleteAppId = appId;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
    }

    public void startElement(String uri, String local, String qName, Attributes attr) throws SAXException {
        if (qName.equals("sdx:results")) {
            this.contentHandler.startElement("http://www.culture.gouv.fr/ns/sdx/sdx", "deletions", "sdx:deletions", attr);
        }
        if (qName.equals("sdx:query")) {
            this.contentHandler.startElement(uri, local, qName, attr);
        }
        this.determineParsingPosition(uri, local, qName, attr);
    }

    public void characters(char[] c, int start, int len) throws SAXException {
        if (this.withinSdxInternalField) {
            StringBuffer stringBuff = new StringBuffer();
            stringBuff.append(c, start, len);
            if (Utilities.checkString(this.currentField)) {
                if (this.currentField.equals("sdxappid")) {
                    this.appId = stringBuff.toString();
                }
                if (this.currentField.equals("sdxdocid")) {
                    this.docId = stringBuff.toString();
                }
                if (this.currentField.equals("sdxdbid")) {
                    this.dbId = stringBuff.toString();
                }
                if (this.currentField.equals("sdxdoctype")) {
                    this.doctype = stringBuff.toString();
                }
            }
        }
    }

    public void endElement(String uri, String local, String qName) throws SAXException {
        if (qName.equals("sdx:query")) {
            this.contentHandler.endElement(uri, local, qName);
        }
        try {
            if (this.isCurrentAppDeleteApp() && qName.equals("sdx:result")) {
                this.queueDocumentForDeletion();
            }
        }
        catch (SDXException e) {
            throw new SAXException(e.getMessage(), (Exception)((Object)e));
        }
        if (qName.equals("sdx:results")) {
            try {
                this.deleteDocuments();
            }
            catch (SDXException e) {
                throw new SAXException(e.getMessage(), (Exception)((Object)e));
            }
            finally {
                this.contentHandler.endElement("http://www.culture.gouv.fr/ns/sdx/sdx", "deletions", "sdx:deletions");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void deleteDocuments() throws SDXException, SAXException {
        ServiceManager manager = super.getServiceManager();
        FrameworkImpl frame = null;
        try {
            Application app;
            ConfigurationUtils.checkServiceManager(manager);
            frame = (FrameworkImpl)manager.lookup("fr.gouv.culture.sdx.framework.Framework");
            if (frame == null || (app = frame.getApplicationById(this.deleteAppId)) == null) return;
            Enumeration docbaseIds = null;
            if (this.deletions != null) {
                docbaseIds = this.deletions.keys();
            }
            if (docbaseIds == null) return;
            while (docbaseIds.hasMoreElements()) {
                DocumentBase docbase = null;
                Document[] docs = null;
                String docbaseId = "";
                ArrayList listDocs = null;
                docbaseId = (String)docbaseIds.nextElement();
                if (Utilities.checkString(docbaseId)) {
                    listDocs = (ArrayList)this.deletions.get(docbaseId);
                    docbase = app.getDocumentBase(docbaseId);
                }
                if (listDocs != null) {
                    listDocs.trimToSize();
                    docs = new Document[listDocs.size()];
                    docs = listDocs.toArray(docs);
                }
                if ((docbase = app.getDocumentBase(docbaseId)) == null || docs == null) continue;
                try {
                    docbase.delete(docs, this.contentHandler);
                }
                catch (ProcessingException e) {
                    throw new SAXException(e.getMessage(), (Exception)((Object)e));
                    return;
                }
            }
        }
        catch (ServiceException e) {
            throw new SDXException(super.getLog(), 222, null, e);
        }
        finally {
            if (frame != null) {
                manager.release((Object)frame);
            }
            this.deletions = new Hashtable();
        }
    }

    private void determineParsingPosition(String uri, String local, String qName, Attributes attr) {
        this.withinSdxInternalField = false;
        boolean withinSdxElement = false;
        if (Utilities.checkString(uri)) {
            withinSdxElement = uri.equals("http://www.culture.gouv.fr/ns/sdx/sdx");
        }
        if (withinSdxElement && Utilities.checkString(local) && local.equals("field")) {
            String fieldName;
            if (attr != null && Utilities.checkString(fieldName = attr.getValue("", "name"))) {
                this.currentField = fieldName;
            }
            if (this.currentField.startsWith("sdx")) {
                this.withinSdxInternalField = true;
            }
        }
    }

    private synchronized void queueDocumentForDeletion() throws SDXException, SAXException {
        if (Utilities.checkString(this.appId) && Utilities.checkString(this.dbId) && Utilities.checkString(this.docId) && Utilities.checkString(this.doctype)) {
            ArrayList dbDocs;
            AbstractIndexableDocument doc = null;
            if (this.doctype.equalsIgnoreCase("html")) {
                doc = new HTMLDocument(this.docId);
            } else if (this.doctype.equalsIgnoreCase("xml")) {
                doc = new XMLDocument(this.docId);
            }
            if (this.deletions == null) {
                this.deletions = new Hashtable();
            }
            if (!this.deletions.containsKey(this.dbId)) {
                this.deletions.put(this.dbId, new ArrayList());
            }
            if ((dbDocs = (ArrayList)this.deletions.get(this.dbId)) != null) {
                dbDocs.add(doc);
            }
            this.resetDocDeletionFields();
        }
    }

    private void sendInfoElement() throws SAXException {
        String sdxNsUri = "http://www.culture.gouv.fr/ns/sdx/sdx";
        String sdxNsPrefix = "sdx";
        String localName = "deletion";
        String qName = sdxNsPrefix + ":" + localName;
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "id", "id", "CDATA", this.docId);
        atts.addAttribute("", "base", "base", "CDATA", this.dbId);
        atts.addAttribute("", "app", "app", "CDATA", this.appId);
        atts.addAttribute("", "doctype", "doctype", "CDATA", this.doctype);
        this.contentHandler.startElement(sdxNsUri, localName, qName, atts);
        this.contentHandler.endElement(sdxNsUri, sdxNsPrefix, qName);
    }

    private void resetDocDeletionFields() {
        this.currentField = "";
        this.docId = "";
        this.dbId = "";
        this.appId = "";
        this.doctype = "";
    }

    private boolean isCurrentAppDeleteApp() throws SDXException {
        if (!Utilities.checkString(this.deleteAppId)) {
            throw new SDXException(super.getLog(), 8100, null, null);
        }
        return this.deleteAppId.equalsIgnoreCase(this.appId);
    }

    protected boolean initToSax() {
        if (!super.initToSax()) {
            return false;
        }
        this._xmlizable_objects.put("Name", this.getClass().getName());
        return true;
    }
}

