/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor.sitemap;

import java.util.ArrayList;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.pipeline.ProcessingPipeline;
import org.apache.cocoon.components.treeprocessor.AbstractParentProcessingNodeBuilder;
import org.apache.cocoon.components.treeprocessor.ProcessingNode;
import org.apache.cocoon.components.treeprocessor.ProcessingNodeBuilder;
import org.apache.cocoon.components.treeprocessor.sitemap.HandleErrorsNode;
import org.apache.cocoon.components.treeprocessor.sitemap.HandleErrorsNodeBuilder;
import org.apache.cocoon.components.treeprocessor.sitemap.PipelineNode;

public class PipelineNodeBuilder
extends AbstractParentProcessingNodeBuilder
implements ThreadSafe {
    protected boolean hasParameters() {
        return true;
    }

    public ProcessingNode buildNode(Configuration config) throws Exception {
        String type = this.treeBuilder.getTypeForStatement(config, ProcessingPipeline.ROLE + "Selector");
        PipelineNode node = new PipelineNode(type);
        this.treeBuilder.setupNode(node, config);
        node.setInternalOnly(config.getAttributeAsBoolean("internal-only", false));
        HandleErrorsNode mainHandler = null;
        HandleErrorsNode error404Handler = null;
        HandleErrorsNode error500Handler = null;
        Configuration[] childConfigs = config.getChildren();
        ArrayList<ProcessingNode> children = new ArrayList<ProcessingNode>();
        for (int i = 0; i < childConfigs.length; ++i) {
            Configuration childConfig = childConfigs[i];
            if (!this.isChild(childConfig)) continue;
            ProcessingNodeBuilder builder = this.treeBuilder.createNodeBuilder(childConfig);
            if (builder instanceof HandleErrorsNodeBuilder) {
                HandleErrorsNode handler = (HandleErrorsNode)builder.buildNode(childConfig);
                int status = handler.getStatusCode();
                switch (status) {
                    case -1: {
                        if (mainHandler != null) {
                            throw new ConfigurationException("Duplicate <handle-errors> at " + handler.getLocation());
                        }
                        if (error500Handler != null || error404Handler != null) {
                            throw new ConfigurationException("Cannot mix <handle-errors> with and without 'type' attribute at " + handler.getLocation());
                        }
                        mainHandler = handler;
                        break;
                    }
                    case 404: {
                        if (error404Handler != null) {
                            throw new ConfigurationException("Duplicate <handle-errors type='404' at " + handler.getLocation());
                        }
                        if (mainHandler != null) {
                            throw new ConfigurationException("Cannot mix <handle-errors> with and without 'type' attribute at " + handler.getLocation());
                        }
                        error404Handler = handler;
                        break;
                    }
                    case 500: {
                        if (error500Handler != null) {
                            throw new ConfigurationException("Duplicate <handle-errors type='500' at " + handler.getLocation());
                        }
                        if (mainHandler != null) {
                            throw new ConfigurationException("Cannot mix <handle-errors> with and without 'type' attribute at " + handler.getLocation());
                        }
                        error500Handler = handler;
                        break;
                    }
                    default: {
                        throw new ConfigurationException("Unknown handle-errors type (" + type + ") at " + handler.getLocation());
                    }
                }
                continue;
            }
            children.add(builder.buildNode(childConfig));
        }
        node.setChildren(PipelineNodeBuilder.toNodeArray(children));
        node.set404Handler(error404Handler);
        node.set500Handler(error500Handler == null ? mainHandler : error500Handler);
        return node;
    }
}

