/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.util;

import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.DefaultContext;
import org.apache.avalon.framework.logger.Logger;
import org.apache.cocoon.util.PropertySettings;
import org.apache.cocoon.util.Settings;
import org.apache.cocoon.util.SimpleSourceResolver;

public class SettingsHelper {
    public static void createSettings(DefaultContext context, Logger logger) throws ContextException {
        SimpleSourceResolver resolver = new SimpleSourceResolver();
        resolver.enableLogging(logger);
        resolver.contextualize((Context)context);
        PropertySettings settings = new PropertySettings(resolver, logger);
        context.put((Object)"org.apache.cocoon.settings", (Object)settings);
    }

    public static Settings getSettings(Context context) {
        Settings settings = null;
        try {
            settings = (Settings)context.get((Object)"org.apache.cocoon.settings");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return settings;
    }

    public static String replace(String value, Settings settings, Logger logger) {
        int pos;
        if (value == null || value.indexOf("${") == -1 || settings == null) {
            return value;
        }
        StringBuffer buffer = new StringBuffer();
        int prev = 0;
        while ((pos = value.indexOf("$", prev)) >= 0) {
            if (pos > prev) {
                buffer.append(value.substring(prev, pos));
            }
            if (pos == value.length() - 1) {
                buffer.append("$");
                prev = pos + 1;
                continue;
            }
            if (value.charAt(pos + 1) != '{') {
                buffer.append(value.substring(pos, pos + 2));
                prev = pos + 2;
                continue;
            }
            int endName = value.indexOf(125, pos);
            if (endName == -1) {
                buffer.append(value.substring(pos));
                prev = value.length();
                continue;
            }
            String propertyName = value.substring(pos + 2, endName);
            String propertyValue = SettingsHelper.getProperty(propertyName, settings);
            if (propertyValue == null) {
                logger.warn("Property " + propertyName + " not found.");
                buffer.append("${");
                buffer.append(propertyName);
                buffer.append('}');
            } else {
                buffer.append(propertyValue);
            }
            prev = endName + 1;
        }
        if (prev < value.length()) {
            buffer.append(value.substring(prev));
        }
        return buffer.toString();
    }

    static String getProperty(String name, Settings settings) {
        String value = null;
        if (settings != null) {
            value = settings.getProperty(name);
        }
        if (value == null) {
            value = System.getProperty(name);
        }
        return value;
    }
}

