/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.generation;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.components.language.generator.ProgramGenerator;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.generation.AbstractServerPage;
import org.apache.cocoon.generation.ServletGenerator;
import org.apache.cocoon.xml.AbstractXMLPipe;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.commons.collections.ArrayStack;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceValidity;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.LocatorImpl;

public class ServerPagesGenerator
extends ServletGenerator
implements CacheableProcessingComponent,
Configurable {
    protected ProgramGenerator programGenerator = null;
    protected AbstractServerPage generator = null;
    private Source inputSource;
    private CompletionPipe completionPipe;
    protected String markupLanguage;
    protected String programmingLanguage;
    public static final String DEFAULT_MARKUP_LANGUAGE = "xsp";
    public static final String DEFAULT_PROGRAMMING_LANGUAGE = "java";
    private static final int DOCUMENT = 0;
    private static final int ELEMENT = 1;
    private static final int PREFIX_MAPPING = 2;
    private static final int CDATA = 3;
    private static final int DTD = 4;
    private static final int ENTITY = 5;
    private static final Integer DOCUMENT_OBJ = new Integer(0);
    private static final Integer ELEMENT_OBJ = new Integer(1);
    private static final Integer PREFIX_MAPPING_OBJ = new Integer(2);
    private static final Integer CDATA_OBJ = new Integer(3);
    private static final Integer DTD_OBJ = new Integer(4);
    private static final Integer ENTITY_OBJ = new Integer(5);

    public void compose(ComponentManager manager) throws ComponentException {
        super.compose(manager);
        if (this.programGenerator == null) {
            this.programGenerator = (ProgramGenerator)manager.lookup(ProgramGenerator.ROLE);
        }
    }

    public void configure(Configuration config) throws ConfigurationException {
        boolean autoComplete = config.getChild("autocomplete-documents").getValueAsBoolean(false);
        if (autoComplete) {
            this.completionPipe = new CompletionPipe();
            this.completionPipe.enableLogging(this.getLogger());
        }
        this.markupLanguage = config.getChild("markup-language").getValue(DEFAULT_MARKUP_LANGUAGE);
        this.programmingLanguage = config.getChild("programming-language").getValue(DEFAULT_PROGRAMMING_LANGUAGE);
    }

    public Serializable getKey() {
        Serializable key = this.generator.getKey();
        if (key == null) {
            return this.inputSource.getURI();
        }
        return this.inputSource.getURI() + '-' + key;
    }

    public SourceValidity getValidity() {
        return this.generator.getValidity();
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, par);
        String markupLanguage = this.parameters.getParameter("markup-language", this.markupLanguage);
        String programmingLanguage = this.parameters.getParameter("programming-language", this.programmingLanguage);
        try {
            this.inputSource = this.resolver.resolveURI(src);
        }
        catch (SourceException se) {
            throw SourceUtil.handle((String)("Error during resolving of '" + src + "'."), (SourceException)se);
        }
        try {
            this.generator = (AbstractServerPage)this.programGenerator.load(this.manager, this.inputSource, markupLanguage, programmingLanguage, this.resolver);
        }
        catch (ProcessingException e) {
            throw e;
        }
        catch (Exception e) {
            this.getLogger().warn("setup()", (Throwable)e);
            throw new ProcessingException(e.getMessage(), (Throwable)e);
        }
        catch (NoClassDefFoundError e) {
            this.getLogger().warn("Failed to load class: " + e);
            throw new ResourceNotFoundException(e.getMessage());
        }
        this.generator.enableLogging(this.getLogger());
        this.generator.setup(this.resolver, this.objectModel, this.source, this.parameters);
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        if (this.completionPipe != null) {
            this.generator.setConsumer((XMLConsumer)this.completionPipe);
            if (this.xmlConsumer != null) {
                this.completionPipe.setConsumer(this.xmlConsumer);
            } else {
                this.completionPipe.setContentHandler(this.contentHandler);
                this.completionPipe.setLexicalHandler(this.lexicalHandler);
            }
        } else if (this.xmlConsumer != null) {
            this.generator.setConsumer(this.xmlConsumer);
        } else {
            this.generator.setContentHandler(this.contentHandler);
            this.generator.setLexicalHandler(this.lexicalHandler);
        }
        LocatorImpl locator = new LocatorImpl();
        locator.setSystemId(this.inputSource.getURI());
        this.contentHandler.setDocumentLocator(locator);
        try {
            try {
                this.generator.generate();
            }
            catch (IOException e) {
                this.getLogger().debug("IOException in generate()", (Throwable)e);
                throw e;
            }
            catch (SAXException e) {
                this.getLogger().debug("SAXException in generate()", (Throwable)e);
                throw e;
            }
            catch (ProcessingException e) {
                this.getLogger().debug("ProcessingException in generate()", (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                this.getLogger().debug("Exception in generate()", (Throwable)e);
                throw new ProcessingException("Exception in ServerPagesGenerator.generate()", (Throwable)e);
            }
            Object var4_2 = null;
            if (this.generator != null) {
                this.programGenerator.release(this.generator);
            }
            this.generator = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            if (this.generator != null) {
                this.programGenerator.release(this.generator);
            }
            this.generator = null;
            throw throwable;
        }
        if (this.completionPipe != null) {
            this.completionPipe.flushEvents();
        }
    }

    public void recycle() {
        if (this.generator != null) {
            this.programGenerator.release(this.generator);
            this.generator = null;
        }
        if (this.inputSource != null) {
            this.resolver.release(this.inputSource);
            this.inputSource = null;
        }
        if (this.completionPipe != null) {
            this.completionPipe.recycle();
            this.completionPipe = null;
        }
        super.recycle();
    }

    public void dispose() {
        this.manager.release((Component)this.programGenerator);
        this.programGenerator = null;
        this.manager = null;
    }

    public class CompletionPipe
    extends AbstractXMLPipe {
        protected ArrayStack eventStack = new ArrayStack();

        public void startDocument() throws SAXException {
            super.startDocument();
            this.eventStack.push((Object)DOCUMENT_OBJ);
        }

        public void endDocument() throws SAXException {
            this.eventStack.pop();
            super.endDocument();
        }

        public void startElement(String namespaceURI, String localName, String rawName, Attributes atts) throws SAXException {
            super.startElement(namespaceURI, localName, rawName, atts);
            this.eventStack.push((Object)rawName);
            this.eventStack.push((Object)localName);
            this.eventStack.push((Object)namespaceURI);
            this.eventStack.push((Object)ELEMENT_OBJ);
        }

        public void endElement(String namespaceURI, String localName, String rawName) throws SAXException {
            this.eventStack.pop();
            this.eventStack.pop();
            this.eventStack.pop();
            this.eventStack.pop();
            super.endElement(namespaceURI, localName, rawName);
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            super.startPrefixMapping(prefix, uri);
            this.eventStack.push((Object)prefix);
            this.eventStack.push((Object)PREFIX_MAPPING_OBJ);
        }

        public void endPrefixMapping(String prefix) throws SAXException {
            this.eventStack.pop();
            this.eventStack.pop();
            super.endPrefixMapping(prefix);
        }

        public void startCDATA() throws SAXException {
            super.startCDATA();
            this.eventStack.push((Object)CDATA_OBJ);
        }

        public void endCDATA() throws SAXException {
            this.eventStack.pop();
            super.endCDATA();
        }

        public void startDTD(String name, String publicId, String systemId) throws SAXException {
            super.startDTD(name, publicId, systemId);
            this.eventStack.push((Object)DTD_OBJ);
        }

        public void endDTD() throws SAXException {
            this.eventStack.pop();
            super.endDTD();
        }

        public void startEntity(String name) throws SAXException {
            super.startEntity(name);
            this.eventStack.push((Object)name);
            this.eventStack.push((Object)ENTITY_OBJ);
        }

        public void endEntity(String name) throws SAXException {
            this.eventStack.pop();
            this.eventStack.pop();
            super.endEntity(name);
        }

        public void flushEvents() throws SAXException {
            if (this.getLogger().isWarnEnabled() && this.eventStack.size() > 0) {
                this.getLogger().warn("Premature end of document generated by " + ServerPagesGenerator.this.inputSource.getURI());
            }
            while (this.eventStack.size() != 0) {
                int event = (Integer)this.eventStack.pop();
                switch (event) {
                    case 0: {
                        super.endDocument();
                        break;
                    }
                    case 1: {
                        String namespaceURI = (String)this.eventStack.pop();
                        String localName = (String)this.eventStack.pop();
                        String rawName = (String)this.eventStack.pop();
                        super.endElement(namespaceURI, localName, rawName);
                        break;
                    }
                    case 2: {
                        super.endPrefixMapping((String)this.eventStack.pop());
                        break;
                    }
                    case 3: {
                        super.endCDATA();
                        break;
                    }
                    case 4: {
                        super.endDTD();
                        break;
                    }
                    case 5: {
                        super.endEntity((String)this.eventStack.pop());
                    }
                }
            }
        }

        public void recycle() {
            this.eventStack.clear();
            super.recycle();
        }
    }
}

