/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.apps.svgbrowser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.print.PrinterException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.text.PlainDocument;
import org.apache.batik.apps.svgbrowser.AboutDialog;
import org.apache.batik.apps.svgbrowser.Application;
import org.apache.batik.apps.svgbrowser.FindDialog;
import org.apache.batik.apps.svgbrowser.JPEGOptionPanel;
import org.apache.batik.apps.svgbrowser.LocalHistory;
import org.apache.batik.apps.svgbrowser.PNGOptionPanel;
import org.apache.batik.apps.svgbrowser.Resources;
import org.apache.batik.apps.svgbrowser.SVGInputHandler;
import org.apache.batik.apps.svgbrowser.SquiggleInputHandler;
import org.apache.batik.apps.svgbrowser.SquiggleInputHandlerFilter;
import org.apache.batik.apps.svgbrowser.StatusBar;
import org.apache.batik.apps.svgbrowser.ThumbnailDialog;
import org.apache.batik.apps.svgbrowser.TransformHistory;
import org.apache.batik.apps.svgbrowser.WindowsAltFileSystemView;
import org.apache.batik.bridge.DefaultExternalResourceSecurity;
import org.apache.batik.bridge.DefaultScriptSecurity;
import org.apache.batik.bridge.EmbededExternalResourceSecurity;
import org.apache.batik.bridge.EmbededScriptSecurity;
import org.apache.batik.bridge.ExternalResourceSecurity;
import org.apache.batik.bridge.NoLoadExternalResourceSecurity;
import org.apache.batik.bridge.NoLoadScriptSecurity;
import org.apache.batik.bridge.RelaxedExternalResourceSecurity;
import org.apache.batik.bridge.RelaxedScriptSecurity;
import org.apache.batik.bridge.ScriptSecurity;
import org.apache.batik.bridge.UpdateManagerEvent;
import org.apache.batik.bridge.UpdateManagerListener;
import org.apache.batik.dom.StyleSheetProcessingInstruction;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.util.HashTable;
import org.apache.batik.ext.swing.JAffineTransformChooser;
import org.apache.batik.swing.JSVGCanvas;
import org.apache.batik.swing.gvt.GVTTreeRendererEvent;
import org.apache.batik.swing.gvt.GVTTreeRendererListener;
import org.apache.batik.swing.svg.GVTTreeBuilderEvent;
import org.apache.batik.swing.svg.GVTTreeBuilderListener;
import org.apache.batik.swing.svg.LinkActivationEvent;
import org.apache.batik.swing.svg.LinkActivationListener;
import org.apache.batik.swing.svg.SVGDocumentLoaderEvent;
import org.apache.batik.swing.svg.SVGDocumentLoaderListener;
import org.apache.batik.swing.svg.SVGFileFilter;
import org.apache.batik.swing.svg.SVGLoadEventDispatcherEvent;
import org.apache.batik.swing.svg.SVGLoadEventDispatcherListener;
import org.apache.batik.swing.svg.SVGUserAgent;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.transcoder.image.JPEGTranscoder;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.apache.batik.transcoder.image.TIFFTranscoder;
import org.apache.batik.transcoder.print.PrintTranscoder;
import org.apache.batik.util.ParsedURL;
import org.apache.batik.util.Service;
import org.apache.batik.util.gui.DOMViewer;
import org.apache.batik.util.gui.JErrorPane;
import org.apache.batik.util.gui.LocationBar;
import org.apache.batik.util.gui.MemoryMonitor;
import org.apache.batik.util.gui.URIChooser;
import org.apache.batik.util.gui.resource.ActionMap;
import org.apache.batik.util.gui.resource.JComponentModifier;
import org.apache.batik.util.gui.resource.MenuFactory;
import org.apache.batik.util.gui.resource.MissingListenerException;
import org.apache.batik.util.gui.resource.ResourceManager;
import org.apache.batik.util.gui.resource.ToolBarFactory;
import org.apache.batik.xml.XMLUtilities;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextListener;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.css.ViewCSS;
import org.w3c.dom.svg.SVGDocument;

public class JSVGViewerFrame
extends JFrame
implements ActionMap,
SVGDocumentLoaderListener,
GVTTreeBuilderListener,
SVGLoadEventDispatcherListener,
GVTTreeRendererListener,
LinkActivationListener,
UpdateManagerListener {
    protected static boolean priorJDK1_4 = true;
    protected static final String JDK_1_4_PRESENCE_TEST_CLASS = "java.util.logging.LoggingPermission";
    static JFrame debuggerFrame;
    static Class debuggerClass;
    static Method clearAllBreakpoints;
    static Method scriptGo;
    static Method setExitAction;
    public static final String RESOURCES = "org.apache.batik.apps.svgbrowser.resources.GUI";
    public static final String ABOUT_ACTION = "AboutAction";
    public static final String OPEN_ACTION = "OpenAction";
    public static final String OPEN_LOCATION_ACTION = "OpenLocationAction";
    public static final String NEW_WINDOW_ACTION = "NewWindowAction";
    public static final String RELOAD_ACTION = "ReloadAction";
    public static final String BACK_ACTION = "BackAction";
    public static final String FORWARD_ACTION = "ForwardAction";
    public static final String FULL_SCREEN_ACTION = "FullScreenAction";
    public static final String PRINT_ACTION = "PrintAction";
    public static final String EXPORT_AS_JPG_ACTION = "ExportAsJPGAction";
    public static final String EXPORT_AS_PNG_ACTION = "ExportAsPNGAction";
    public static final String EXPORT_AS_TIFF_ACTION = "ExportAsTIFFAction";
    public static final String PREFERENCES_ACTION = "PreferencesAction";
    public static final String CLOSE_ACTION = "CloseAction";
    public static final String VIEW_SOURCE_ACTION = "ViewSourceAction";
    public static final String EXIT_ACTION = "ExitAction";
    public static final String RESET_TRANSFORM_ACTION = "ResetTransformAction";
    public static final String ZOOM_IN_ACTION = "ZoomInAction";
    public static final String ZOOM_OUT_ACTION = "ZoomOutAction";
    public static final String PREVIOUS_TRANSFORM_ACTION = "PreviousTransformAction";
    public static final String NEXT_TRANSFORM_ACTION = "NextTransformAction";
    public static final String USE_STYLESHEET_ACTION = "UseStylesheetAction";
    public static final String PLAY_ACTION = "PlayAction";
    public static final String PAUSE_ACTION = "PauseAction";
    public static final String STOP_ACTION = "StopAction";
    public static final String MONITOR_ACTION = "MonitorAction";
    public static final String DOM_VIEWER_ACTION = "DOMViewerAction";
    public static final String SET_TRANSFORM_ACTION = "SetTransformAction";
    public static final String FIND_DIALOG_ACTION = "FindDialogAction";
    public static final String THUMBNAIL_DIALOG_ACTION = "ThumbnailDialogAction";
    public static final String FLUSH_ACTION = "FlushAction";
    public static final String TOGGLE_DEBUGGER_ACTION = "ToggleDebuggerAction";
    public static final Cursor WAIT_CURSOR;
    public static final Cursor DEFAULT_CURSOR;
    public static final String PROPERTY_OS_NAME;
    public static final String PROPERTY_OS_NAME_DEFAULT;
    public static final String PROPERTY_OS_WINDOWS_PREFIX;
    protected static Vector handlers;
    protected static SquiggleInputHandler defaultHandler;
    protected static ResourceBundle bundle;
    protected static ResourceManager resources;
    protected Application application;
    protected JSVGCanvas svgCanvas;
    protected JPanel svgCanvasPanel;
    protected JWindow window;
    protected static JFrame memoryMonitorFrame;
    protected File currentPath = new File("");
    protected File currentExportPath = new File("");
    protected BackAction backAction = new BackAction();
    protected ForwardAction forwardAction = new ForwardAction();
    protected PlayAction playAction = new PlayAction();
    protected PauseAction pauseAction = new PauseAction();
    protected StopAction stopAction = new StopAction();
    protected PreviousTransformAction previousTransformAction = new PreviousTransformAction();
    protected NextTransformAction nextTransformAction = new NextTransformAction();
    protected UseStylesheetAction useStylesheetAction = new UseStylesheetAction();
    protected boolean debug;
    protected boolean autoAdjust = true;
    protected boolean managerStopped;
    protected SVGUserAgent userAgent = new UserAgent();
    protected SVGDocument svgDocument;
    protected URIChooser uriChooser;
    protected DOMViewer domViewer;
    protected FindDialog findDialog;
    protected ThumbnailDialog thumbnailDialog;
    protected JAffineTransformChooser.Dialog transformDialog;
    protected LocationBar locationBar;
    protected StatusBar statusBar;
    protected String title;
    protected LocalHistory localHistory;
    protected TransformHistory transformHistory = new TransformHistory();
    protected String alternateStyleSheet;
    protected Map listeners = new HashMap();
    long time;
    static /* synthetic */ Class class$org$apache$batik$apps$svgbrowser$JSVGViewerFrame;
    static /* synthetic */ Class class$java$lang$Runnable;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$apache$batik$apps$svgbrowser$SquiggleInputHandler;

    public static void showDebugger() {
        if (debuggerClass == null) {
            return;
        }
        if (debuggerFrame == null) {
            try {
                Constructor constructor = debuggerClass.getConstructor(class$java$lang$String == null ? (class$java$lang$String = JSVGViewerFrame.class$("java.lang.String")) : class$java$lang$String);
                debuggerFrame = (JFrame)constructor.newInstance("Rhino JavaScript Debugger");
                JMenuBar jMenuBar = debuggerFrame.getJMenuBar();
                JMenu jMenu = jMenuBar.getMenu(0);
                jMenu.getItem(0).setEnabled(false);
                jMenu.getItem(1).setEnabled(false);
                jMenu.getItem(3).setText(Resources.getString("Close.text"));
                jMenu.getItem(3).setAccelerator(KeyStroke.getKeyStroke(87, 2));
                debuggerFrame.setSize(600, 460);
                debuggerFrame.pack();
                WindowAdapter windowAdapter = new WindowAdapter(){

                    public void windowClosing(WindowEvent windowEvent) {
                        JSVGViewerFrame.hideDebugger();
                    }
                };
                setExitAction.invoke((Object)debuggerFrame, new Runnable(){

                    public void run() {
                        JSVGViewerFrame.hideDebugger();
                    }
                });
                debuggerFrame.addWindowListener(windowAdapter);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }
        if (debuggerFrame != null) {
            debuggerFrame.setVisible(true);
            Context.addContextListener((ContextListener)((ContextListener)debuggerFrame));
        }
    }

    public static void hideDebugger() {
        if (debuggerFrame == null) {
            return;
        }
        Context.removeContextListener((ContextListener)((ContextListener)debuggerFrame));
        debuggerFrame.setVisible(false);
        try {
            clearAllBreakpoints.invoke((Object)debuggerFrame, null);
            scriptGo.invoke((Object)debuggerFrame, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public JSVGViewerFrame(Application application) {
        this.application = application;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                JSVGViewerFrame.this.application.closeJSVGViewerFrame(JSVGViewerFrame.this);
            }
        });
        this.svgCanvas = new JSVGCanvas(this.userAgent, true, true){
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            {
                this.setMaximumSize(this.screenSize);
            }

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                if (dimension.width > this.screenSize.width) {
                    dimension.width = this.screenSize.width;
                }
                if (dimension.height > this.screenSize.height) {
                    dimension.height = this.screenSize.height;
                }
                return dimension;
            }

            public void setMySize(Dimension dimension) {
                this.setPreferredSize(dimension);
                this.invalidate();
                if (JSVGViewerFrame.this.autoAdjust) {
                    JSVGViewerFrame.this.pack();
                }
            }

            public void setDisableInteractions(boolean bl) {
                super.setDisableInteractions(bl);
                ((Action)JSVGViewerFrame.this.listeners.get(JSVGViewerFrame.SET_TRANSFORM_ACTION)).setEnabled(!bl);
                if (JSVGViewerFrame.this.thumbnailDialog != null) {
                    JSVGViewerFrame.this.thumbnailDialog.setInteractionEnabled(!bl);
                }
            }
        };
        javax.swing.ActionMap actionMap = this.svgCanvas.getActionMap();
        actionMap.put(FULL_SCREEN_ACTION, new FullScreenAction());
        InputMap inputMap = this.svgCanvas.getInputMap(0);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(122, 0);
        inputMap.put(keyStroke, FULL_SCREEN_ACTION);
        this.svgCanvas.setDoubleBufferedRendering(true);
        this.listeners.put(ABOUT_ACTION, new AboutAction());
        this.listeners.put(OPEN_ACTION, new OpenAction());
        this.listeners.put(OPEN_LOCATION_ACTION, new OpenLocationAction());
        this.listeners.put(NEW_WINDOW_ACTION, new NewWindowAction());
        this.listeners.put(RELOAD_ACTION, new ReloadAction());
        this.listeners.put(BACK_ACTION, this.backAction);
        this.listeners.put(FORWARD_ACTION, this.forwardAction);
        this.listeners.put(PRINT_ACTION, new PrintAction());
        this.listeners.put(EXPORT_AS_JPG_ACTION, new ExportAsJPGAction());
        this.listeners.put(EXPORT_AS_PNG_ACTION, new ExportAsPNGAction());
        this.listeners.put(EXPORT_AS_TIFF_ACTION, new ExportAsTIFFAction());
        this.listeners.put(PREFERENCES_ACTION, new PreferencesAction());
        this.listeners.put(CLOSE_ACTION, new CloseAction());
        this.listeners.put(EXIT_ACTION, this.application.createExitAction(this));
        this.listeners.put(VIEW_SOURCE_ACTION, new ViewSourceAction());
        javax.swing.ActionMap actionMap2 = this.svgCanvas.getActionMap();
        this.listeners.put(RESET_TRANSFORM_ACTION, actionMap2.get("ResetTransform"));
        this.listeners.put(ZOOM_IN_ACTION, actionMap2.get("ZoomIn"));
        this.listeners.put(ZOOM_OUT_ACTION, actionMap2.get("ZoomOut"));
        this.listeners.put(PREVIOUS_TRANSFORM_ACTION, this.previousTransformAction);
        keyStroke = KeyStroke.getKeyStroke(75, 2);
        inputMap.put(keyStroke, this.previousTransformAction);
        this.listeners.put(NEXT_TRANSFORM_ACTION, this.nextTransformAction);
        keyStroke = KeyStroke.getKeyStroke(76, 2);
        inputMap.put(keyStroke, this.nextTransformAction);
        this.listeners.put(USE_STYLESHEET_ACTION, this.useStylesheetAction);
        this.listeners.put(PLAY_ACTION, this.playAction);
        this.listeners.put(PAUSE_ACTION, this.pauseAction);
        this.listeners.put(STOP_ACTION, this.stopAction);
        this.listeners.put(MONITOR_ACTION, new MonitorAction());
        this.listeners.put(DOM_VIEWER_ACTION, new DOMViewerAction());
        this.listeners.put(SET_TRANSFORM_ACTION, new SetTransformAction());
        this.listeners.put(FIND_DIALOG_ACTION, new FindDialogAction());
        this.listeners.put(THUMBNAIL_DIALOG_ACTION, new ThumbnailDialogAction());
        this.listeners.put(FLUSH_ACTION, new FlushAction());
        this.listeners.put(TOGGLE_DEBUGGER_ACTION, new ToggleDebuggerAction());
        JPanel jPanel = null;
        try {
            MenuFactory menuFactory = new MenuFactory(bundle, this);
            JMenuBar jMenuBar = menuFactory.createJMenuBar("MenuBar");
            this.setJMenuBar(jMenuBar);
            this.localHistory = new LocalHistory(jMenuBar, this);
            String[] stringArray = this.application.getVisitedURIs();
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null || "".equals(stringArray[i])) continue;
                this.localHistory.update(stringArray[i]);
            }
            jPanel = new JPanel(new BorderLayout());
            ToolBarFactory toolBarFactory = new ToolBarFactory(bundle, this);
            JToolBar jToolBar = toolBarFactory.createJToolBar("ToolBar");
            jToolBar.setFloatable(false);
            this.getContentPane().add((Component)jPanel, "North");
            jPanel.add((Component)jToolBar, "North");
            jPanel.add((Component)new JSeparator(), "Center");
            this.locationBar = new LocationBar();
            jPanel.add((Component)this.locationBar, "South");
        }
        catch (MissingResourceException missingResourceException) {
            System.out.println(missingResourceException.getMessage());
            System.exit(0);
        }
        this.svgCanvasPanel = new JPanel(new BorderLayout());
        this.svgCanvasPanel.setBorder(BorderFactory.createEtchedBorder());
        this.svgCanvasPanel.add((Component)this.svgCanvas, "Center");
        jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.svgCanvasPanel, "Center");
        this.statusBar = new StatusBar();
        jPanel.add((Component)this.statusBar, "South");
        this.getContentPane().add((Component)jPanel, "Center");
        this.svgCanvas.addSVGDocumentLoaderListener(this);
        this.svgCanvas.addGVTTreeBuilderListener(this);
        this.svgCanvas.addSVGLoadEventDispatcherListener(this);
        this.svgCanvas.addGVTTreeRendererListener(this);
        this.svgCanvas.addLinkActivationListener(this);
        this.svgCanvas.addUpdateManagerListener(this);
        this.svgCanvas.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent mouseEvent) {
                if (JSVGViewerFrame.this.svgDocument == null) {
                    JSVGViewerFrame.this.statusBar.setXPosition(mouseEvent.getX());
                    JSVGViewerFrame.this.statusBar.setYPosition(mouseEvent.getY());
                } else {
                    try {
                        AffineTransform affineTransform = JSVGViewerFrame.this.svgCanvas.getViewBoxTransform();
                        if (affineTransform != null) {
                            affineTransform = affineTransform.createInverse();
                            Point2D point2D = affineTransform.transform(new Point2D.Float(mouseEvent.getX(), mouseEvent.getY()), null);
                            JSVGViewerFrame.this.statusBar.setXPosition((float)point2D.getX());
                            JSVGViewerFrame.this.statusBar.setYPosition((float)point2D.getY());
                            return;
                        }
                    }
                    catch (NoninvertibleTransformException noninvertibleTransformException) {
                        // empty catch block
                    }
                    JSVGViewerFrame.this.statusBar.setXPosition(mouseEvent.getX());
                    JSVGViewerFrame.this.statusBar.setYPosition(mouseEvent.getY());
                }
            }
        });
        this.svgCanvas.addMouseListener(new MouseAdapter(){

            public void mouseExited(MouseEvent mouseEvent) {
                Dimension dimension = JSVGViewerFrame.this.svgCanvas.getSize();
                if (JSVGViewerFrame.this.svgDocument == null) {
                    JSVGViewerFrame.this.statusBar.setWidth(dimension.width);
                    JSVGViewerFrame.this.statusBar.setHeight(dimension.height);
                } else {
                    try {
                        AffineTransform affineTransform = JSVGViewerFrame.this.svgCanvas.getViewBoxTransform();
                        if (affineTransform != null) {
                            affineTransform = affineTransform.createInverse();
                            Point2D point2D = affineTransform.transform(new Point2D.Float(0.0f, 0.0f), null);
                            Point2D point2D2 = affineTransform.transform(new Point2D.Float(dimension.width, dimension.height), null);
                            JSVGViewerFrame.this.statusBar.setWidth((float)(point2D2.getX() - point2D.getX()));
                            JSVGViewerFrame.this.statusBar.setHeight((float)(point2D2.getY() - point2D.getY()));
                            return;
                        }
                    }
                    catch (NoninvertibleTransformException noninvertibleTransformException) {
                        // empty catch block
                    }
                    JSVGViewerFrame.this.statusBar.setWidth(dimension.width);
                    JSVGViewerFrame.this.statusBar.setHeight(dimension.height);
                }
            }
        });
        this.svgCanvas.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                Dimension dimension = JSVGViewerFrame.this.svgCanvas.getSize();
                if (JSVGViewerFrame.this.svgDocument == null) {
                    JSVGViewerFrame.this.statusBar.setWidth(dimension.width);
                    JSVGViewerFrame.this.statusBar.setHeight(dimension.height);
                } else {
                    try {
                        AffineTransform affineTransform = JSVGViewerFrame.this.svgCanvas.getViewBoxTransform();
                        if (affineTransform != null) {
                            affineTransform = affineTransform.createInverse();
                            Point2D point2D = affineTransform.transform(new Point2D.Float(0.0f, 0.0f), null);
                            Point2D point2D2 = affineTransform.transform(new Point2D.Float(dimension.width, dimension.height), null);
                            JSVGViewerFrame.this.statusBar.setWidth((float)(point2D2.getX() - point2D.getX()));
                            JSVGViewerFrame.this.statusBar.setHeight((float)(point2D2.getY() - point2D.getY()));
                            return;
                        }
                    }
                    catch (NoninvertibleTransformException noninvertibleTransformException) {
                        // empty catch block
                    }
                    JSVGViewerFrame.this.statusBar.setWidth(dimension.width);
                    JSVGViewerFrame.this.statusBar.setHeight(dimension.height);
                }
            }
        });
        this.locationBar.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = JSVGViewerFrame.this.locationBar.getText().trim();
                int n = string.indexOf("#");
                String string2 = "";
                if (n != -1) {
                    string2 = string.substring(n + 1);
                    string = string.substring(0, n);
                }
                if (!string.equals("")) {
                    Object object;
                    block12: {
                        try {
                            object = new File(string);
                            if (!((File)object).exists()) break block12;
                            if (((File)object).isDirectory()) {
                                string = null;
                                break block12;
                            }
                            try {
                                string = ((File)object).getCanonicalPath();
                                if (string.startsWith("/")) {
                                    string = "file:" + string;
                                    break block12;
                                }
                                string = "file:/" + string;
                            }
                            catch (IOException iOException) {}
                        }
                        catch (SecurityException securityException) {
                            // empty catch block
                        }
                    }
                    if (string != null) {
                        if (JSVGViewerFrame.this.svgDocument != null) {
                            object = new ParsedURL(JSVGViewerFrame.this.svgDocument.getURL());
                            ParsedURL parsedURL = new ParsedURL((ParsedURL)object, string);
                            String string3 = JSVGViewerFrame.this.svgCanvas.getFragmentIdentifier();
                            String string4 = string3 = string3 == null ? "" : string3;
                            if (((ParsedURL)object).equals(parsedURL) && string2.equals(string3)) {
                                return;
                            }
                        }
                        if (string2.length() != 0) {
                            string = string + "#" + string2;
                        }
                        JSVGViewerFrame.this.locationBar.setText(string);
                        JSVGViewerFrame.this.locationBar.addToHistory(string);
                        JSVGViewerFrame.this.showSVGDocument(string);
                    }
                }
            }
        });
    }

    public void dispose() {
        this.svgCanvas.dispose();
        super.dispose();
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public void setAutoAdjust(boolean bl) {
        this.autoAdjust = bl;
    }

    public JSVGCanvas getJSVGCanvas() {
        return this.svgCanvas;
    }

    private static File makeAbsolute(File file) {
        if (!file.isAbsolute()) {
            return file.getAbsoluteFile();
        }
        return file;
    }

    public void showSVGDocument(String string) {
        block2: {
            try {
                ParsedURL parsedURL = new ParsedURL(string);
                SquiggleInputHandler squiggleInputHandler = this.getInputHandler(parsedURL);
                squiggleInputHandler.handle(parsedURL, this);
            }
            catch (Exception exception) {
                if (this.userAgent == null) break block2;
                this.userAgent.displayError(exception);
            }
        }
    }

    public SquiggleInputHandler getInputHandler(ParsedURL parsedURL) throws IOException {
        Iterator iterator = JSVGViewerFrame.getHandlers().iterator();
        SquiggleInputHandler squiggleInputHandler = null;
        while (iterator.hasNext()) {
            SquiggleInputHandler squiggleInputHandler2 = (SquiggleInputHandler)iterator.next();
            if (!squiggleInputHandler2.accept(parsedURL)) continue;
            squiggleInputHandler = squiggleInputHandler2;
            break;
        }
        if (squiggleInputHandler == null) {
            squiggleInputHandler = defaultHandler;
        }
        return squiggleInputHandler;
    }

    protected static Vector getHandlers() {
        if (handlers != null) {
            return handlers;
        }
        handlers = new Vector();
        JSVGViewerFrame.registerHandler(new SVGInputHandler());
        Iterator iterator = Service.providers(class$org$apache$batik$apps$svgbrowser$SquiggleInputHandler == null ? (class$org$apache$batik$apps$svgbrowser$SquiggleInputHandler = JSVGViewerFrame.class$("org.apache.batik.apps.svgbrowser.SquiggleInputHandler")) : class$org$apache$batik$apps$svgbrowser$SquiggleInputHandler);
        while (iterator.hasNext()) {
            SquiggleInputHandler squiggleInputHandler = (SquiggleInputHandler)iterator.next();
            JSVGViewerFrame.registerHandler(squiggleInputHandler);
        }
        return handlers;
    }

    public static synchronized void registerHandler(SquiggleInputHandler squiggleInputHandler) {
        Vector vector = JSVGViewerFrame.getHandlers();
        vector.addElement(squiggleInputHandler);
    }

    public Action getAction(String string) throws MissingListenerException {
        Action action = (Action)this.listeners.get(string);
        if (action == null) {
            throw new MissingListenerException("Can't find action.", RESOURCES, string);
        }
        return action;
    }

    public void documentLoadingStarted(SVGDocumentLoaderEvent sVGDocumentLoaderEvent) {
        if (this.debug) {
            System.out.println("Document load started...");
            this.time = System.currentTimeMillis();
        }
        this.statusBar.setMainMessage(resources.getString("Message.documentLoad"));
        this.stopAction.update(true);
        this.svgCanvas.setCursor(WAIT_CURSOR);
    }

    public void documentLoadingCompleted(SVGDocumentLoaderEvent sVGDocumentLoaderEvent) {
        if (this.debug) {
            System.out.print("Document load completed in ");
            System.out.println(System.currentTimeMillis() - this.time + " ms");
        }
        this.setSVGDocument(sVGDocumentLoaderEvent.getSVGDocument(), sVGDocumentLoaderEvent.getSVGDocument().getURL(), sVGDocumentLoaderEvent.getSVGDocument().getTitle());
    }

    public void setSVGDocument(SVGDocument sVGDocument, String string, String string2) {
        String string3;
        this.svgDocument = sVGDocument;
        if (this.domViewer != null) {
            if (this.domViewer.isVisible() && sVGDocument != null) {
                this.domViewer.setDocument(sVGDocument, (ViewCSS)((Object)sVGDocument.getDocumentElement()));
            } else {
                this.domViewer.dispose();
                this.domViewer = null;
            }
        }
        this.stopAction.update(false);
        this.svgCanvas.setCursor(DEFAULT_CURSOR);
        String string4 = string;
        String string5 = this.svgCanvas.getFragmentIdentifier();
        if (string5 != null) {
            string4 = string4 + "#" + string5;
        }
        this.locationBar.setText(string4);
        if (this.title == null) {
            this.title = this.getTitle();
        }
        if ((string3 = string2).length() != 0) {
            this.setTitle(this.title + ":" + string3);
        } else {
            int n = string4.lastIndexOf("/");
            if (n == -1) {
                n = string4.lastIndexOf("\\");
                if (n == -1) {
                    this.setTitle(this.title + ":" + string4);
                } else {
                    this.setTitle(this.title + ":" + string4.substring(n + 1));
                }
            } else {
                this.setTitle(this.title + ":" + string4.substring(n + 1));
            }
        }
        this.localHistory.update(string4);
        this.application.addVisitedURI(string4);
        this.backAction.update();
        this.forwardAction.update();
        this.transformHistory = new TransformHistory();
        this.previousTransformAction.update();
        this.nextTransformAction.update();
        this.useStylesheetAction.update();
    }

    public void documentLoadingCancelled(SVGDocumentLoaderEvent sVGDocumentLoaderEvent) {
        if (this.debug) {
            System.out.println("Document load cancelled");
        }
        this.statusBar.setMainMessage("");
        this.statusBar.setMessage(resources.getString("Message.documentCancelled"));
        this.stopAction.update(false);
        this.svgCanvas.setCursor(DEFAULT_CURSOR);
    }

    public void documentLoadingFailed(SVGDocumentLoaderEvent sVGDocumentLoaderEvent) {
        if (this.debug) {
            System.out.println("Document load failed");
        }
        this.statusBar.setMainMessage("");
        this.statusBar.setMessage(resources.getString("Message.documentFailed"));
        this.stopAction.update(false);
        this.svgCanvas.setCursor(DEFAULT_CURSOR);
    }

    public void gvtBuildStarted(GVTTreeBuilderEvent gVTTreeBuilderEvent) {
        if (this.debug) {
            System.out.println("GVT build started...");
            this.time = System.currentTimeMillis();
        }
        this.statusBar.setMainMessage(resources.getString("Message.treeBuild"));
        this.stopAction.update(true);
        this.svgCanvas.setCursor(WAIT_CURSOR);
    }

    public void gvtBuildCompleted(GVTTreeBuilderEvent gVTTreeBuilderEvent) {
        if (this.debug) {
            System.out.print("GVT build completed in ");
            System.out.println(System.currentTimeMillis() - this.time + " ms");
        }
        if (this.findDialog != null) {
            if (this.findDialog.isVisible()) {
                this.findDialog.setGraphicsNode(this.svgCanvas.getGraphicsNode());
            } else {
                this.findDialog.dispose();
                this.findDialog = null;
            }
        }
        this.stopAction.update(false);
        this.svgCanvas.setCursor(DEFAULT_CURSOR);
        this.svgCanvas.setSelectionOverlayXORMode(this.application.isSelectionOverlayXORMode());
        this.svgCanvas.requestFocus();
    }

    public void gvtBuildCancelled(GVTTreeBuilderEvent gVTTreeBuilderEvent) {
        if (this.debug) {
            System.out.println("GVT build cancelled");
        }
        this.statusBar.setMainMessage("");
        this.statusBar.setMessage(resources.getString("Message.treeCancelled"));
        this.stopAction.update(false);
        this.svgCanvas.setCursor(DEFAULT_CURSOR);
        this.svgCanvas.setSelectionOverlayXORMode(this.application.isSelectionOverlayXORMode());
    }

    public void gvtBuildFailed(GVTTreeBuilderEvent gVTTreeBuilderEvent) {
        if (this.debug) {
            System.out.println("GVT build failed");
        }
        this.statusBar.setMainMessage("");
        this.statusBar.setMessage(resources.getString("Message.treeFailed"));
        this.stopAction.update(false);
        this.svgCanvas.setCursor(DEFAULT_CURSOR);
        this.svgCanvas.setSelectionOverlayXORMode(this.application.isSelectionOverlayXORMode());
        if (this.autoAdjust) {
            this.pack();
        }
    }

    public void svgLoadEventDispatchStarted(SVGLoadEventDispatcherEvent sVGLoadEventDispatcherEvent) {
        if (this.debug) {
            System.out.println("Onload dispatch started...");
            this.time = System.currentTimeMillis();
        }
        this.stopAction.update(true);
        this.statusBar.setMainMessage(resources.getString("Message.onload"));
    }

    public void svgLoadEventDispatchCompleted(SVGLoadEventDispatcherEvent sVGLoadEventDispatcherEvent) {
        if (this.debug) {
            System.out.print("Onload dispatch completed in ");
            System.out.println(System.currentTimeMillis() - this.time + " ms");
        }
        this.stopAction.update(false);
        this.statusBar.setMainMessage("");
        this.statusBar.setMessage(resources.getString("Message.done"));
    }

    public void svgLoadEventDispatchCancelled(SVGLoadEventDispatcherEvent sVGLoadEventDispatcherEvent) {
        if (this.debug) {
            System.out.println("Onload dispatch cancelled.");
        }
        this.stopAction.update(false);
        this.statusBar.setMainMessage("");
        this.statusBar.setMessage(resources.getString("Message.onloadCancelled"));
    }

    public void svgLoadEventDispatchFailed(SVGLoadEventDispatcherEvent sVGLoadEventDispatcherEvent) {
        if (this.debug) {
            System.out.println("Onload dispatch failed.");
        }
        this.stopAction.update(false);
        this.statusBar.setMainMessage("");
        this.statusBar.setMessage(resources.getString("Message.onloadFailed"));
    }

    public void gvtRenderingPrepare(GVTTreeRendererEvent gVTTreeRendererEvent) {
        if (this.debug) {
            System.out.println("GVT rendering preparation...");
            this.time = System.currentTimeMillis();
        }
        this.stopAction.update(true);
        this.svgCanvas.setCursor(WAIT_CURSOR);
        this.statusBar.setMainMessage(resources.getString("Message.treeRendering"));
    }

    public void gvtRenderingStarted(GVTTreeRendererEvent gVTTreeRendererEvent) {
        if (this.debug) {
            System.out.print("GVT rendering prepared in ");
            System.out.println(System.currentTimeMillis() - this.time + " ms");
            this.time = System.currentTimeMillis();
            System.out.println("GVT rendering started...");
        }
    }

    public void gvtRenderingCompleted(GVTTreeRendererEvent gVTTreeRendererEvent) {
        if (this.debug) {
            System.out.print("GVT rendering completed in ");
            System.out.println(System.currentTimeMillis() - this.time + " ms");
        }
        this.statusBar.setMainMessage("");
        this.statusBar.setMessage(resources.getString("Message.done"));
        if (!this.svgCanvas.isDynamic() || this.managerStopped) {
            this.stopAction.update(false);
        }
        this.svgCanvas.setCursor(DEFAULT_CURSOR);
        this.transformHistory.update(this.svgCanvas.getRenderingTransform());
        this.previousTransformAction.update();
        this.nextTransformAction.update();
    }

    public void gvtRenderingCancelled(GVTTreeRendererEvent gVTTreeRendererEvent) {
        if (this.debug) {
            System.out.println("GVT rendering cancelled");
        }
        this.statusBar.setMainMessage("");
        if (!this.svgCanvas.isDynamic()) {
            this.stopAction.update(false);
        }
        this.svgCanvas.setCursor(DEFAULT_CURSOR);
    }

    public void gvtRenderingFailed(GVTTreeRendererEvent gVTTreeRendererEvent) {
        if (this.debug) {
            System.out.println("GVT rendering failed");
        }
        this.statusBar.setMainMessage("");
        if (!this.svgCanvas.isDynamic()) {
            this.stopAction.update(false);
        }
        this.svgCanvas.setCursor(DEFAULT_CURSOR);
    }

    public void linkActivated(LinkActivationEvent linkActivationEvent) {
        String string = linkActivationEvent.getReferencedURI();
        if (this.svgDocument != null) {
            ParsedURL parsedURL = new ParsedURL(this.svgDocument.getURL());
            ParsedURL parsedURL2 = new ParsedURL(parsedURL, string);
            if (!parsedURL2.sameFile(parsedURL)) {
                return;
            }
            if (string.indexOf("#") != -1) {
                this.localHistory.update(string);
                this.application.addVisitedURI(string);
                this.backAction.update();
                this.forwardAction.update();
                this.transformHistory = new TransformHistory();
                this.previousTransformAction.update();
                this.nextTransformAction.update();
            }
        }
    }

    public void managerStarted(UpdateManagerEvent updateManagerEvent) {
        if (this.debug) {
            System.out.println("Update manager started...");
        }
        this.managerStopped = false;
        this.playAction.update(false);
        this.pauseAction.update(true);
        this.stopAction.update(true);
    }

    public void managerSuspended(UpdateManagerEvent updateManagerEvent) {
        if (this.debug) {
            System.out.println("Update manager suspended");
        }
        this.playAction.update(true);
        this.pauseAction.update(false);
    }

    public void managerResumed(UpdateManagerEvent updateManagerEvent) {
        if (this.debug) {
            System.out.println("Update manager resumed");
        }
        this.playAction.update(false);
        this.pauseAction.update(true);
    }

    public void managerStopped(UpdateManagerEvent updateManagerEvent) {
        if (this.debug) {
            System.out.println("Update manager stopped");
        }
        this.managerStopped = true;
        this.playAction.update(false);
        this.pauseAction.update(false);
        this.stopAction.update(false);
    }

    public void updateStarted(UpdateManagerEvent updateManagerEvent) {
    }

    public void updateCompleted(UpdateManagerEvent updateManagerEvent) {
    }

    public void updateFailed(UpdateManagerEvent updateManagerEvent) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(JDK_1_4_PRESENCE_TEST_CLASS);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (clazz != null) {
            priorJDK1_4 = false;
        }
        debuggerFrame = null;
        debuggerClass = null;
        clearAllBreakpoints = null;
        scriptGo = null;
        setExitAction = null;
        try {
            debuggerClass = (class$org$apache$batik$apps$svgbrowser$JSVGViewerFrame == null ? (class$org$apache$batik$apps$svgbrowser$JSVGViewerFrame = JSVGViewerFrame.class$("org.apache.batik.apps.svgbrowser.JSVGViewerFrame")) : class$org$apache$batik$apps$svgbrowser$JSVGViewerFrame).getClassLoader().loadClass("org.mozilla.javascript.tools.debugger.Main");
            clearAllBreakpoints = debuggerClass.getMethod("clearAllBreakpoints", null);
            scriptGo = debuggerClass.getMethod("go", null);
            setExitAction = debuggerClass.getMethod("setExitAction", class$java$lang$Runnable == null ? (class$java$lang$Runnable = JSVGViewerFrame.class$("java.lang.Runnable")) : class$java$lang$Runnable);
        }
        catch (ThreadDeath threadDeath) {
            debuggerClass = null;
            clearAllBreakpoints = null;
            scriptGo = null;
            setExitAction = null;
            throw threadDeath;
        }
        catch (Throwable throwable) {
            debuggerClass = null;
            clearAllBreakpoints = null;
            scriptGo = null;
            setExitAction = null;
        }
        WAIT_CURSOR = new Cursor(3);
        DEFAULT_CURSOR = new Cursor(0);
        PROPERTY_OS_NAME = Resources.getString("JSVGViewerFrame.property.os.name");
        PROPERTY_OS_NAME_DEFAULT = Resources.getString("JSVGViewerFrame.property.os.name.default");
        PROPERTY_OS_WINDOWS_PREFIX = Resources.getString("JSVGViewerFrame.property.os.windows.prefix");
        defaultHandler = new SVGInputHandler();
        bundle = ResourceBundle.getBundle(RESOURCES, Locale.getDefault());
        resources = new ResourceManager(bundle);
    }

    protected static class ImageFileFilter
    extends FileFilter {
        protected String extension;

        public ImageFileFilter(String string) {
            this.extension = string;
        }

        public boolean accept(File file) {
            boolean bl = false;
            String string = null;
            if (file != null) {
                if (file.isDirectory()) {
                    bl = true;
                } else {
                    string = file.getPath().toLowerCase();
                    if (string.endsWith(this.extension)) {
                        bl = true;
                    }
                }
            }
            return bl;
        }

        public String getDescription() {
            return this.extension;
        }
    }

    protected class UserAgent
    implements SVGUserAgent {
        protected UserAgent() {
        }

        public void displayError(String string) {
            if (JSVGViewerFrame.this.debug) {
                System.err.println(string);
            }
            JOptionPane jOptionPane = new JOptionPane(string, 0);
            JDialog jDialog = jOptionPane.createDialog(JSVGViewerFrame.this, "ERROR");
            jDialog.setModal(false);
            jDialog.show();
        }

        public void displayError(Exception exception) {
            if (JSVGViewerFrame.this.debug) {
                exception.printStackTrace();
            }
            JErrorPane jErrorPane = new JErrorPane(exception, 0);
            JDialog jDialog = jErrorPane.createDialog(JSVGViewerFrame.this, "ERROR");
            jDialog.setModal(false);
            jDialog.show();
        }

        public void displayMessage(String string) {
            JSVGViewerFrame.this.statusBar.setMessage(string);
        }

        public void showAlert(String string) {
            JSVGViewerFrame.this.svgCanvas.showAlert(string);
        }

        public String showPrompt(String string) {
            return JSVGViewerFrame.this.svgCanvas.showPrompt(string);
        }

        public String showPrompt(String string, String string2) {
            return JSVGViewerFrame.this.svgCanvas.showPrompt(string, string2);
        }

        public boolean showConfirm(String string) {
            return JSVGViewerFrame.this.svgCanvas.showConfirm(string);
        }

        public float getPixelUnitToMillimeter() {
            return 0.26458332f;
        }

        public float getPixelToMM() {
            return this.getPixelUnitToMillimeter();
        }

        public String getDefaultFontFamily() {
            return JSVGViewerFrame.this.application.getDefaultFontFamily();
        }

        public float getMediumFontSize() {
            return 228.59999f / (72.0f * this.getPixelUnitToMillimeter());
        }

        public float getLighterFontWeight(float f) {
            int n = (int)((f + 50.0f) / 100.0f) * 100;
            switch (n) {
                case 100: {
                    return 100.0f;
                }
                case 200: {
                    return 100.0f;
                }
                case 300: {
                    return 200.0f;
                }
                case 400: {
                    return 300.0f;
                }
                case 500: {
                    return 400.0f;
                }
                case 600: {
                    return 400.0f;
                }
                case 700: {
                    return 400.0f;
                }
                case 800: {
                    return 400.0f;
                }
                case 900: {
                    return 400.0f;
                }
            }
            throw new IllegalArgumentException("Bad Font Weight: " + f);
        }

        public float getBolderFontWeight(float f) {
            int n = (int)((f + 50.0f) / 100.0f) * 100;
            switch (n) {
                case 100: {
                    return 600.0f;
                }
                case 200: {
                    return 600.0f;
                }
                case 300: {
                    return 600.0f;
                }
                case 400: {
                    return 600.0f;
                }
                case 500: {
                    return 600.0f;
                }
                case 600: {
                    return 700.0f;
                }
                case 700: {
                    return 800.0f;
                }
                case 800: {
                    return 900.0f;
                }
                case 900: {
                    return 900.0f;
                }
            }
            throw new IllegalArgumentException("Bad Font Weight: " + f);
        }

        public String getLanguages() {
            return JSVGViewerFrame.this.application.getLanguages();
        }

        public String getUserStyleSheetURI() {
            return JSVGViewerFrame.this.application.getUserStyleSheetURI();
        }

        public String getXMLParserClassName() {
            return JSVGViewerFrame.this.application.getXMLParserClassName();
        }

        public boolean isXMLParserValidating() {
            return JSVGViewerFrame.this.application.isXMLParserValidating();
        }

        public String getMedia() {
            return JSVGViewerFrame.this.application.getMedia();
        }

        public String getAlternateStyleSheet() {
            return JSVGViewerFrame.this.alternateStyleSheet;
        }

        public void openLink(String string, boolean bl) {
            if (bl) {
                JSVGViewerFrame.this.application.openLink(string);
            } else {
                JSVGViewerFrame.this.showSVGDocument(string);
            }
        }

        public boolean supportExtension(String string) {
            return false;
        }

        public void handleElement(Element element, Object object) {
        }

        public ScriptSecurity getScriptSecurity(String string, ParsedURL parsedURL, ParsedURL parsedURL2) {
            if (!JSVGViewerFrame.this.application.canLoadScriptType(string)) {
                return new NoLoadScriptSecurity(string);
            }
            switch (JSVGViewerFrame.this.application.getAllowedScriptOrigin()) {
                case 1: {
                    return new RelaxedScriptSecurity(string, parsedURL, parsedURL2);
                }
                case 2: {
                    return new DefaultScriptSecurity(string, parsedURL, parsedURL2);
                }
                case 4: {
                    return new EmbededScriptSecurity(string, parsedURL, parsedURL2);
                }
            }
            return new NoLoadScriptSecurity(string);
        }

        public void checkLoadScript(String string, ParsedURL parsedURL, ParsedURL parsedURL2) throws SecurityException {
            ScriptSecurity scriptSecurity = this.getScriptSecurity(string, parsedURL, parsedURL2);
            if (scriptSecurity != null) {
                scriptSecurity.checkLoadScript();
            }
        }

        public ExternalResourceSecurity getExternalResourceSecurity(ParsedURL parsedURL, ParsedURL parsedURL2) {
            switch (JSVGViewerFrame.this.application.getAllowedExternalResourceOrigin()) {
                case 1: {
                    return new RelaxedExternalResourceSecurity(parsedURL, parsedURL2);
                }
                case 2: {
                    return new DefaultExternalResourceSecurity(parsedURL, parsedURL2);
                }
                case 4: {
                    return new EmbededExternalResourceSecurity(parsedURL);
                }
            }
            return new NoLoadExternalResourceSecurity();
        }

        public void checkLoadExternalResource(ParsedURL parsedURL, ParsedURL parsedURL2) throws SecurityException {
            ExternalResourceSecurity externalResourceSecurity = this.getExternalResourceSecurity(parsedURL, parsedURL2);
            if (externalResourceSecurity != null) {
                externalResourceSecurity.checkLoadExternalResource();
            }
        }
    }

    public class DOMViewerAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            if (JSVGViewerFrame.this.domViewer == null) {
                JSVGViewerFrame.this.domViewer = new DOMViewer();
                if (JSVGViewerFrame.this.svgDocument != null) {
                    JSVGViewerFrame.this.domViewer.setDocument(JSVGViewerFrame.this.svgDocument, (ViewCSS)((Object)JSVGViewerFrame.this.svgDocument.getDocumentElement()));
                }
                Rectangle rectangle = JSVGViewerFrame.this.getBounds();
                Dimension dimension = JSVGViewerFrame.this.domViewer.getSize();
                JSVGViewerFrame.this.domViewer.setLocation(rectangle.x + (rectangle.width - dimension.width) / 2, rectangle.y + (rectangle.height - dimension.height) / 2);
            }
            JSVGViewerFrame.this.domViewer.show();
        }
    }

    public class FullScreenAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            if (JSVGViewerFrame.this.window == null || !JSVGViewerFrame.this.window.isVisible()) {
                if (JSVGViewerFrame.this.window == null) {
                    JSVGViewerFrame.this.window = new JWindow(JSVGViewerFrame.this);
                    Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                    JSVGViewerFrame.this.window.setSize(dimension);
                }
                JSVGViewerFrame.this.svgCanvas.getParent().remove(JSVGViewerFrame.this.svgCanvas);
                JSVGViewerFrame.this.window.getContentPane().add(JSVGViewerFrame.this.svgCanvas);
                JSVGViewerFrame.this.window.setVisible(true);
                JSVGViewerFrame.this.window.toFront();
                JSVGViewerFrame.this.svgCanvas.requestFocus();
            } else {
                JSVGViewerFrame.this.svgCanvas.getParent().remove(JSVGViewerFrame.this.svgCanvas);
                JSVGViewerFrame.this.svgCanvasPanel.add((Component)JSVGViewerFrame.this.svgCanvas, "Center");
                JSVGViewerFrame.this.window.setVisible(false);
            }
        }
    }

    public class ThumbnailDialogAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            if (JSVGViewerFrame.this.thumbnailDialog == null) {
                JSVGViewerFrame.this.thumbnailDialog = new ThumbnailDialog((Frame)JSVGViewerFrame.this, JSVGViewerFrame.this.svgCanvas);
                JSVGViewerFrame.this.thumbnailDialog.pack();
                Rectangle rectangle = JSVGViewerFrame.this.getBounds();
                Dimension dimension = JSVGViewerFrame.this.thumbnailDialog.getSize();
                JSVGViewerFrame.this.thumbnailDialog.setLocation(rectangle.x + (rectangle.width - dimension.width) / 2, rectangle.y + (rectangle.height - dimension.height) / 2);
            }
            JSVGViewerFrame.this.thumbnailDialog.setInteractionEnabled(!JSVGViewerFrame.this.svgCanvas.getDisableInteractions());
            JSVGViewerFrame.this.thumbnailDialog.show();
        }
    }

    public class FindDialogAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            if (JSVGViewerFrame.this.findDialog == null) {
                JSVGViewerFrame.this.findDialog = new FindDialog((Frame)JSVGViewerFrame.this, JSVGViewerFrame.this.svgCanvas);
                JSVGViewerFrame.this.findDialog.setGraphicsNode(JSVGViewerFrame.this.svgCanvas.getGraphicsNode());
                JSVGViewerFrame.this.findDialog.pack();
                Rectangle rectangle = JSVGViewerFrame.this.getBounds();
                Dimension dimension = JSVGViewerFrame.this.findDialog.getSize();
                JSVGViewerFrame.this.findDialog.setLocation(rectangle.x + (rectangle.width - dimension.width) / 2, rectangle.y + (rectangle.height - dimension.height) / 2);
            }
            JSVGViewerFrame.this.findDialog.show();
        }
    }

    public class MonitorAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            if (memoryMonitorFrame == null) {
                memoryMonitorFrame = new MemoryMonitor();
                Rectangle rectangle = JSVGViewerFrame.this.getBounds();
                Dimension dimension = memoryMonitorFrame.getSize();
                memoryMonitorFrame.setLocation(rectangle.x + (rectangle.width - dimension.width) / 2, rectangle.y + (rectangle.height - dimension.height) / 2);
            }
            memoryMonitorFrame.show();
        }
    }

    public class SetTransformAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            AffineTransform affineTransform;
            if (JSVGViewerFrame.this.transformDialog == null) {
                JSVGViewerFrame.this.transformDialog = JAffineTransformChooser.createDialog(JSVGViewerFrame.this, resources.getString("SetTransform.title"));
            }
            if ((affineTransform = JSVGViewerFrame.this.transformDialog.showDialog()) != null) {
                AffineTransform affineTransform2 = JSVGViewerFrame.this.svgCanvas.getRenderingTransform();
                if (affineTransform2 == null) {
                    affineTransform2 = new AffineTransform();
                }
                affineTransform.concatenate(affineTransform2);
                JSVGViewerFrame.this.svgCanvas.setRenderingTransform(affineTransform);
            }
        }
    }

    public class StopAction
    extends AbstractAction
    implements JComponentModifier {
        List components = new LinkedList();

        public void actionPerformed(ActionEvent actionEvent) {
            JSVGViewerFrame.this.svgCanvas.stopProcessing();
        }

        public void addJComponent(JComponent jComponent) {
            this.components.add(jComponent);
            jComponent.setEnabled(false);
        }

        public void update(boolean bl) {
            Iterator iterator = this.components.iterator();
            while (iterator.hasNext()) {
                ((JComponent)iterator.next()).setEnabled(bl);
            }
        }
    }

    public class PauseAction
    extends AbstractAction
    implements JComponentModifier {
        List components = new LinkedList();

        public void actionPerformed(ActionEvent actionEvent) {
            JSVGViewerFrame.this.svgCanvas.suspendProcessing();
        }

        public void addJComponent(JComponent jComponent) {
            this.components.add(jComponent);
            jComponent.setEnabled(false);
        }

        public void update(boolean bl) {
            Iterator iterator = this.components.iterator();
            while (iterator.hasNext()) {
                ((JComponent)iterator.next()).setEnabled(bl);
            }
        }
    }

    public class PlayAction
    extends AbstractAction
    implements JComponentModifier {
        List components = new LinkedList();

        public void actionPerformed(ActionEvent actionEvent) {
            JSVGViewerFrame.this.svgCanvas.resumeProcessing();
        }

        public void addJComponent(JComponent jComponent) {
            this.components.add(jComponent);
            jComponent.setEnabled(false);
        }

        public void update(boolean bl) {
            Iterator iterator = this.components.iterator();
            while (iterator.hasNext()) {
                ((JComponent)iterator.next()).setEnabled(bl);
            }
        }
    }

    public class UseStylesheetAction
    extends AbstractAction
    implements JComponentModifier {
        List components = new LinkedList();

        public void actionPerformed(ActionEvent actionEvent) {
        }

        public void addJComponent(JComponent jComponent) {
            this.components.add(jComponent);
            jComponent.setEnabled(false);
        }

        protected void update() {
            JSVGViewerFrame.this.alternateStyleSheet = null;
            Iterator iterator = this.components.iterator();
            SVGDocument sVGDocument = JSVGViewerFrame.this.svgCanvas.getSVGDocument();
            while (iterator.hasNext()) {
                JComponent jComponent = (JComponent)iterator.next();
                jComponent.removeAll();
                jComponent.setEnabled(false);
                ButtonGroup buttonGroup = new ButtonGroup();
                for (Node node = sVGDocument.getFirstChild(); node != null && node.getNodeType() != 1; node = node.getNextSibling()) {
                    if (!(node instanceof StyleSheetProcessingInstruction)) continue;
                    StyleSheetProcessingInstruction styleSheetProcessingInstruction = (StyleSheetProcessingInstruction)node;
                    HashTable hashTable = styleSheetProcessingInstruction.getPseudoAttributes();
                    String string = (String)hashTable.get("title");
                    String string2 = (String)hashTable.get("alternate");
                    if (string == null || !"yes".equals(string2)) continue;
                    JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(string);
                    jRadioButtonMenuItem.addActionListener(new ActionListener(this, string){
                        private final /* synthetic */ String val$title;
                        private final /* synthetic */ UseStylesheetAction this$1;
                        {
                            this.this$1 = useStylesheetAction;
                            this.val$title = string;
                        }

                        public void actionPerformed(ActionEvent actionEvent) {
                            SVGOMDocument sVGOMDocument = (SVGOMDocument)UseStylesheetAction.access$600((UseStylesheetAction)this.this$1).svgCanvas.getSVGDocument();
                            sVGOMDocument.clearViewCSS();
                            UseStylesheetAction.access$600((UseStylesheetAction)this.this$1).alternateStyleSheet = this.val$title;
                            UseStylesheetAction.access$600((UseStylesheetAction)this.this$1).svgCanvas.setSVGDocument(sVGOMDocument);
                        }
                    });
                    buttonGroup.add(jRadioButtonMenuItem);
                    jComponent.add(jRadioButtonMenuItem);
                    jComponent.setEnabled(true);
                }
            }
        }

        static /* synthetic */ JSVGViewerFrame access$600(UseStylesheetAction useStylesheetAction) {
            return useStylesheetAction.JSVGViewerFrame.this;
        }
    }

    public class NextTransformAction
    extends AbstractAction
    implements JComponentModifier {
        List components = new LinkedList();

        public void actionPerformed(ActionEvent actionEvent) {
            if (JSVGViewerFrame.this.transformHistory.canGoForward()) {
                JSVGViewerFrame.this.transformHistory.forward();
                this.update();
                JSVGViewerFrame.this.previousTransformAction.update();
                JSVGViewerFrame.this.svgCanvas.setRenderingTransform(JSVGViewerFrame.this.transformHistory.currentTransform());
            }
        }

        public void addJComponent(JComponent jComponent) {
            this.components.add(jComponent);
            jComponent.setEnabled(false);
        }

        protected void update() {
            boolean bl = JSVGViewerFrame.this.transformHistory.canGoForward();
            Iterator iterator = this.components.iterator();
            while (iterator.hasNext()) {
                ((JComponent)iterator.next()).setEnabled(bl);
            }
        }
    }

    public class PreviousTransformAction
    extends AbstractAction
    implements JComponentModifier {
        List components = new LinkedList();

        public void actionPerformed(ActionEvent actionEvent) {
            if (JSVGViewerFrame.this.transformHistory.canGoBack()) {
                JSVGViewerFrame.this.transformHistory.back();
                this.update();
                JSVGViewerFrame.this.nextTransformAction.update();
                JSVGViewerFrame.this.svgCanvas.setRenderingTransform(JSVGViewerFrame.this.transformHistory.currentTransform());
            }
        }

        public void addJComponent(JComponent jComponent) {
            this.components.add(jComponent);
            jComponent.setEnabled(false);
        }

        protected void update() {
            boolean bl = JSVGViewerFrame.this.transformHistory.canGoBack();
            Iterator iterator = this.components.iterator();
            while (iterator.hasNext()) {
                ((JComponent)iterator.next()).setEnabled(bl);
            }
        }
    }

    public class ToggleDebuggerAction
    extends AbstractAction {
        public ToggleDebuggerAction() {
            super("Toggle Debugger Action");
            if (debuggerClass == null) {
                this.setEnabled(false);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (debuggerClass == null) {
                this.setEnabled(false);
                return;
            }
            if (debuggerFrame == null || !debuggerFrame.isShowing()) {
                JSVGViewerFrame.showDebugger();
            } else {
                JSVGViewerFrame.hideDebugger();
            }
        }
    }

    public class FlushAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            JSVGViewerFrame.this.svgCanvas.flush();
            JSVGViewerFrame.this.svgCanvas.setRenderingTransform(JSVGViewerFrame.this.svgCanvas.getRenderingTransform());
        }
    }

    public class ViewSourceAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            if (JSVGViewerFrame.this.svgDocument == null) {
                return;
            }
            ParsedURL parsedURL = new ParsedURL(JSVGViewerFrame.this.svgDocument.getURL());
            JFrame jFrame = new JFrame(parsedURL.toString());
            jFrame.setSize(resources.getInteger("ViewSource.width"), resources.getInteger("ViewSource.height"));
            JTextArea jTextArea = new JTextArea();
            jTextArea.setLineWrap(true);
            jTextArea.setFont(new Font("monospaced", 0, 12));
            JScrollPane jScrollPane = new JScrollPane();
            jScrollPane.getViewport().add(jTextArea);
            jScrollPane.setVerticalScrollBarPolicy(22);
            jFrame.getContentPane().add((Component)jScrollPane, "Center");
            new Thread(this, parsedURL, jTextArea, jFrame){
                private final /* synthetic */ ParsedURL val$u;
                private final /* synthetic */ JTextArea val$ta;
                private final /* synthetic */ JFrame val$fr;
                private final /* synthetic */ ViewSourceAction this$1;
                {
                    this.this$1 = viewSourceAction;
                    this.val$u = parsedURL;
                    this.val$ta = jTextArea;
                    this.val$fr = jFrame;
                }

                public void run() {
                    char[] cArray = new char[4096];
                    try {
                        int n;
                        PlainDocument plainDocument = new PlainDocument();
                        ParsedURL parsedURL = new ParsedURL(ViewSourceAction.access$500((ViewSourceAction)this.this$1).svgDocument.getURL());
                        InputStream inputStream = this.val$u.openStream(ViewSourceAction.access$500(this.this$1).getInputHandler(parsedURL).getHandledMimeTypes());
                        Reader reader = XMLUtilities.createXMLDocumentReader(inputStream);
                        while ((n = reader.read(cArray, 0, cArray.length)) != -1) {
                            plainDocument.insertString(plainDocument.getLength(), new String(cArray, 0, n), null);
                        }
                        this.val$ta.setDocument(plainDocument);
                        this.val$ta.setEditable(false);
                        this.val$ta.setBackground(Color.white);
                        this.val$fr.show();
                    }
                    catch (Exception exception) {
                        ViewSourceAction.access$500((ViewSourceAction)this.this$1).userAgent.displayError(exception);
                    }
                }
            }.start();
        }

        static /* synthetic */ JSVGViewerFrame access$500(ViewSourceAction viewSourceAction) {
            return viewSourceAction.JSVGViewerFrame.this;
        }
    }

    public class ExportAsTIFFAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser(JSVGViewerFrame.makeAbsolute(JSVGViewerFrame.this.currentExportPath));
            jFileChooser.setDialogTitle(resources.getString("ExportAsTIFF.title"));
            jFileChooser.setFileHidingEnabled(false);
            jFileChooser.setFileSelectionMode(0);
            jFileChooser.addChoosableFileFilter(new ImageFileFilter(".tiff"));
            int n = jFileChooser.showSaveDialog(JSVGViewerFrame.this);
            if (n == 0) {
                File file = jFileChooser.getSelectedFile();
                BufferedImage bufferedImage = JSVGViewerFrame.this.svgCanvas.getOffScreen();
                if (bufferedImage != null) {
                    JSVGViewerFrame.this.statusBar.setMessage(resources.getString("Message.exportAsTIFF"));
                    int n2 = bufferedImage.getWidth();
                    int n3 = bufferedImage.getHeight();
                    TIFFTranscoder tIFFTranscoder = new TIFFTranscoder();
                    tIFFTranscoder.addTranscodingHint(TIFFTranscoder.KEY_XML_PARSER_CLASSNAME, JSVGViewerFrame.this.application.getXMLParserClassName());
                    BufferedImage bufferedImage2 = ((ImageTranscoder)tIFFTranscoder).createImage(n2, n3);
                    Graphics2D graphics2D = bufferedImage2.createGraphics();
                    graphics2D.drawImage(bufferedImage, null, 0, 0);
                    new Thread(this, file, tIFFTranscoder, bufferedImage2){
                        private final /* synthetic */ File val$f;
                        private final /* synthetic */ ImageTranscoder val$trans;
                        private final /* synthetic */ BufferedImage val$img;
                        private final /* synthetic */ ExportAsTIFFAction this$1;
                        {
                            this.this$1 = exportAsTIFFAction;
                            this.val$f = file;
                            this.val$trans = imageTranscoder;
                            this.val$img = bufferedImage;
                        }

                        public void run() {
                            try {
                                ExportAsTIFFAction.access$400((ExportAsTIFFAction)this.this$1).currentExportPath = this.val$f;
                                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.val$f));
                                this.val$trans.writeImage(this.val$img, new TranscoderOutput(bufferedOutputStream));
                                ((OutputStream)bufferedOutputStream).flush();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            ExportAsTIFFAction.access$400((ExportAsTIFFAction)this.this$1).statusBar.setMessage(resources.getString("Message.done"));
                        }
                    }.start();
                }
            }
        }

        static /* synthetic */ JSVGViewerFrame access$400(ExportAsTIFFAction exportAsTIFFAction) {
            return exportAsTIFFAction.JSVGViewerFrame.this;
        }
    }

    public class ExportAsPNGAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser(JSVGViewerFrame.makeAbsolute(JSVGViewerFrame.this.currentExportPath));
            jFileChooser.setDialogTitle(resources.getString("ExportAsPNG.title"));
            jFileChooser.setFileHidingEnabled(false);
            jFileChooser.setFileSelectionMode(0);
            jFileChooser.addChoosableFileFilter(new ImageFileFilter(".png"));
            int n = jFileChooser.showSaveDialog(JSVGViewerFrame.this);
            if (n == 0) {
                boolean bl = PNGOptionPanel.showDialog(JSVGViewerFrame.this);
                File file = jFileChooser.getSelectedFile();
                BufferedImage bufferedImage = JSVGViewerFrame.this.svgCanvas.getOffScreen();
                if (bufferedImage != null) {
                    JSVGViewerFrame.this.statusBar.setMessage(resources.getString("Message.exportAsPNG"));
                    int n2 = bufferedImage.getWidth();
                    int n3 = bufferedImage.getHeight();
                    PNGTranscoder pNGTranscoder = new PNGTranscoder();
                    pNGTranscoder.addTranscodingHint(PNGTranscoder.KEY_XML_PARSER_CLASSNAME, JSVGViewerFrame.this.application.getXMLParserClassName());
                    pNGTranscoder.addTranscodingHint(PNGTranscoder.KEY_FORCE_TRANSPARENT_WHITE, new Boolean(true));
                    if (bl) {
                        pNGTranscoder.addTranscodingHint(PNGTranscoder.KEY_INDEXED, new Integer(256));
                    }
                    BufferedImage bufferedImage2 = ((ImageTranscoder)pNGTranscoder).createImage(n2, n3);
                    Graphics2D graphics2D = bufferedImage2.createGraphics();
                    graphics2D.drawImage(bufferedImage, null, 0, 0);
                    new Thread(this, file, pNGTranscoder, bufferedImage2){
                        private final /* synthetic */ File val$f;
                        private final /* synthetic */ ImageTranscoder val$trans;
                        private final /* synthetic */ BufferedImage val$img;
                        private final /* synthetic */ ExportAsPNGAction this$1;
                        {
                            this.this$1 = exportAsPNGAction;
                            this.val$f = file;
                            this.val$trans = imageTranscoder;
                            this.val$img = bufferedImage;
                        }

                        public void run() {
                            try {
                                ExportAsPNGAction.access$300((ExportAsPNGAction)this.this$1).currentExportPath = this.val$f;
                                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.val$f));
                                this.val$trans.writeImage(this.val$img, new TranscoderOutput(bufferedOutputStream));
                                ((OutputStream)bufferedOutputStream).flush();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            ExportAsPNGAction.access$300((ExportAsPNGAction)this.this$1).statusBar.setMessage(resources.getString("Message.done"));
                        }
                    }.start();
                }
            }
        }

        static /* synthetic */ JSVGViewerFrame access$300(ExportAsPNGAction exportAsPNGAction) {
            return exportAsPNGAction.JSVGViewerFrame.this;
        }
    }

    public class ExportAsJPGAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser(JSVGViewerFrame.makeAbsolute(JSVGViewerFrame.this.currentExportPath));
            jFileChooser.setDialogTitle(resources.getString("ExportAsJPG.title"));
            jFileChooser.setFileHidingEnabled(false);
            jFileChooser.setFileSelectionMode(0);
            jFileChooser.addChoosableFileFilter(new ImageFileFilter(".jpg"));
            int n = jFileChooser.showSaveDialog(JSVGViewerFrame.this);
            if (n == 0) {
                float f = JPEGOptionPanel.showDialog(JSVGViewerFrame.this);
                File file = jFileChooser.getSelectedFile();
                BufferedImage bufferedImage = JSVGViewerFrame.this.svgCanvas.getOffScreen();
                if (bufferedImage != null) {
                    JSVGViewerFrame.this.statusBar.setMessage(resources.getString("Message.exportAsJPG"));
                    int n2 = bufferedImage.getWidth();
                    int n3 = bufferedImage.getHeight();
                    JPEGTranscoder jPEGTranscoder = new JPEGTranscoder();
                    jPEGTranscoder.addTranscodingHint(JPEGTranscoder.KEY_XML_PARSER_CLASSNAME, JSVGViewerFrame.this.application.getXMLParserClassName());
                    jPEGTranscoder.addTranscodingHint(JPEGTranscoder.KEY_QUALITY, new Float(f));
                    BufferedImage bufferedImage2 = ((ImageTranscoder)jPEGTranscoder).createImage(n2, n3);
                    Graphics2D graphics2D = bufferedImage2.createGraphics();
                    graphics2D.setColor(Color.white);
                    graphics2D.fillRect(0, 0, n2, n3);
                    graphics2D.drawImage(bufferedImage, null, 0, 0);
                    new Thread(this, file, jPEGTranscoder, bufferedImage2){
                        private final /* synthetic */ File val$f;
                        private final /* synthetic */ ImageTranscoder val$trans;
                        private final /* synthetic */ BufferedImage val$img;
                        private final /* synthetic */ ExportAsJPGAction this$1;
                        {
                            this.this$1 = exportAsJPGAction;
                            this.val$f = file;
                            this.val$trans = imageTranscoder;
                            this.val$img = bufferedImage;
                        }

                        public void run() {
                            try {
                                ExportAsJPGAction.access$200((ExportAsJPGAction)this.this$1).currentExportPath = this.val$f;
                                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.val$f));
                                this.val$trans.writeImage(this.val$img, new TranscoderOutput(bufferedOutputStream));
                                ((OutputStream)bufferedOutputStream).flush();
                                ((OutputStream)bufferedOutputStream).close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            ExportAsJPGAction.access$200((ExportAsJPGAction)this.this$1).statusBar.setMessage(resources.getString("Message.done"));
                        }
                    }.start();
                }
            }
        }

        static /* synthetic */ JSVGViewerFrame access$200(ExportAsJPGAction exportAsJPGAction) {
            return exportAsJPGAction.JSVGViewerFrame.this;
        }
    }

    public class PrintAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            if (JSVGViewerFrame.this.svgDocument != null) {
                SVGDocument sVGDocument = JSVGViewerFrame.this.svgDocument;
                new Thread(this, sVGDocument){
                    private final /* synthetic */ SVGDocument val$doc;
                    private final /* synthetic */ PrintAction this$1;
                    {
                        this.this$1 = printAction;
                        this.val$doc = sVGDocument;
                    }

                    public void run() {
                        String string = this.val$doc.getURL();
                        String string2 = PrintAction.access$100((PrintAction)this.this$1).svgCanvas.getFragmentIdentifier();
                        if (string2 != null) {
                            string = string + "#" + string2;
                        }
                        PrintTranscoder printTranscoder = new PrintTranscoder();
                        printTranscoder.addTranscodingHint(PrintTranscoder.KEY_XML_PARSER_CLASSNAME, PrintAction.access$100((PrintAction)this.this$1).application.getXMLParserClassName());
                        printTranscoder.addTranscodingHint(PrintTranscoder.KEY_SHOW_PAGE_DIALOG, Boolean.TRUE);
                        printTranscoder.addTranscodingHint(PrintTranscoder.KEY_SHOW_PRINTER_DIALOG, Boolean.TRUE);
                        printTranscoder.transcode(new TranscoderInput(string), null);
                        try {
                            printTranscoder.print();
                        }
                        catch (PrinterException printerException) {
                            PrintAction.access$100((PrintAction)this.this$1).userAgent.displayError(printerException);
                        }
                    }
                }.start();
            }
        }

        static /* synthetic */ JSVGViewerFrame access$100(PrintAction printAction) {
            return printAction.JSVGViewerFrame.this;
        }
    }

    public class ForwardAction
    extends AbstractAction
    implements JComponentModifier {
        List components = new LinkedList();

        public void actionPerformed(ActionEvent actionEvent) {
            if (JSVGViewerFrame.this.localHistory.canGoForward()) {
                JSVGViewerFrame.this.localHistory.forward();
            }
        }

        public void addJComponent(JComponent jComponent) {
            this.components.add(jComponent);
            jComponent.setEnabled(false);
        }

        protected void update() {
            boolean bl = JSVGViewerFrame.this.localHistory.canGoForward();
            Iterator iterator = this.components.iterator();
            while (iterator.hasNext()) {
                ((JComponent)iterator.next()).setEnabled(bl);
            }
        }
    }

    public class BackAction
    extends AbstractAction
    implements JComponentModifier {
        List components = new LinkedList();

        public void actionPerformed(ActionEvent actionEvent) {
            if (JSVGViewerFrame.this.localHistory.canGoBack()) {
                JSVGViewerFrame.this.localHistory.back();
            }
        }

        public void addJComponent(JComponent jComponent) {
            this.components.add(jComponent);
            jComponent.setEnabled(false);
        }

        protected void update() {
            boolean bl = JSVGViewerFrame.this.localHistory.canGoBack();
            Iterator iterator = this.components.iterator();
            while (iterator.hasNext()) {
                ((JComponent)iterator.next()).setEnabled(bl);
            }
        }
    }

    public class ReloadAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            if ((actionEvent.getModifiers() & 1) == 1) {
                JSVGViewerFrame.this.svgCanvas.flushImageCache();
            }
            if (JSVGViewerFrame.this.svgDocument != null) {
                JSVGViewerFrame.this.localHistory.reload();
            }
        }
    }

    public class CloseAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            JSVGViewerFrame.this.application.closeJSVGViewerFrame(JSVGViewerFrame.this);
        }
    }

    public class PreferencesAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            JSVGViewerFrame.this.application.showPreferenceDialog(JSVGViewerFrame.this);
        }
    }

    public class NewWindowAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            JSVGViewerFrame jSVGViewerFrame = JSVGViewerFrame.this.application.createAndShowJSVGViewerFrame();
            jSVGViewerFrame.autoAdjust = JSVGViewerFrame.this.autoAdjust;
            jSVGViewerFrame.debug = JSVGViewerFrame.this.debug;
            jSVGViewerFrame.svgCanvas.setProgressivePaint(JSVGViewerFrame.this.svgCanvas.getProgressivePaint());
            jSVGViewerFrame.svgCanvas.setDoubleBufferedRendering(JSVGViewerFrame.this.svgCanvas.getDoubleBufferedRendering());
        }
    }

    public class OpenLocationAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            if (JSVGViewerFrame.this.uriChooser == null) {
                JSVGViewerFrame.this.uriChooser = new URIChooser(JSVGViewerFrame.this);
                JSVGViewerFrame.this.uriChooser.setFileFilter(new SVGFileFilter());
                JSVGViewerFrame.this.uriChooser.pack();
                object = JSVGViewerFrame.this.getBounds();
                Dimension dimension = JSVGViewerFrame.this.uriChooser.getSize();
                JSVGViewerFrame.this.uriChooser.setLocation(((Rectangle)object).x + (((Rectangle)object).width - dimension.width) / 2, ((Rectangle)object).y + (((Rectangle)object).height - dimension.height) / 2);
            }
            if (JSVGViewerFrame.this.uriChooser.showDialog() == 0) {
                object = JSVGViewerFrame.this.uriChooser.getText();
                int n = ((String)object).indexOf("#");
                String string = "";
                if (n != -1) {
                    string = ((String)object).substring(n + 1);
                    object = ((String)object).substring(0, n);
                }
                if (!((String)object).equals("")) {
                    File file = new File((String)object);
                    if (file.exists()) {
                        if (file.isDirectory()) {
                            object = null;
                        } else {
                            try {
                                object = file.getCanonicalPath();
                                object = ((String)object).startsWith("/") ? "file:" + (String)object : "file:/" + (String)object;
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }
                    if (object != null) {
                        if (JSVGViewerFrame.this.svgDocument != null) {
                            ParsedURL parsedURL = new ParsedURL(JSVGViewerFrame.this.svgDocument.getURL());
                            ParsedURL parsedURL2 = new ParsedURL(parsedURL, (String)object);
                            String string2 = JSVGViewerFrame.this.svgCanvas.getFragmentIdentifier();
                            if (parsedURL.equals(parsedURL2) && string.equals(string2)) {
                                return;
                            }
                        }
                        if (string.length() != 0) {
                            object = (String)object + "#" + string;
                        }
                        JSVGViewerFrame.this.showSVGDocument((String)object);
                    }
                }
            }
        }
    }

    public class OpenAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            block4: {
                JFileChooser jFileChooser = null;
                String string = System.getProperty(PROPERTY_OS_NAME, PROPERTY_OS_NAME_DEFAULT);
                SecurityManager securityManager = System.getSecurityManager();
                jFileChooser = priorJDK1_4 && securityManager != null && string.indexOf(PROPERTY_OS_WINDOWS_PREFIX) != -1 ? new JFileChooser(JSVGViewerFrame.makeAbsolute(JSVGViewerFrame.this.currentPath), (FileSystemView)new WindowsAltFileSystemView()) : new JFileChooser(JSVGViewerFrame.makeAbsolute(JSVGViewerFrame.this.currentPath));
                jFileChooser.setFileHidingEnabled(false);
                jFileChooser.setFileSelectionMode(0);
                Iterator iterator = JSVGViewerFrame.getHandlers().iterator();
                while (iterator.hasNext()) {
                    SquiggleInputHandler squiggleInputHandler = (SquiggleInputHandler)iterator.next();
                    jFileChooser.addChoosableFileFilter(new SquiggleInputHandlerFilter(squiggleInputHandler));
                }
                int n = jFileChooser.showOpenDialog(JSVGViewerFrame.this);
                if (n == 0) {
                    File file;
                    JSVGViewerFrame.this.currentPath = file = jFileChooser.getSelectedFile();
                    try {
                        String string2 = file.toURL().toString();
                        JSVGViewerFrame.this.showSVGDocument(string2);
                    }
                    catch (MalformedURLException malformedURLException) {
                        if (JSVGViewerFrame.this.userAgent == null) break block4;
                        JSVGViewerFrame.this.userAgent.displayError(malformedURLException);
                    }
                }
            }
        }
    }

    public class AboutAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            AboutDialog aboutDialog = new AboutDialog(JSVGViewerFrame.this);
            aboutDialog.setSize(aboutDialog.getPreferredSize());
            aboutDialog.setLocationRelativeTo(JSVGViewerFrame.this);
            aboutDialog.show();
            aboutDialog.toFront();
        }
    }
}

