/*
SDX: Documentary System in XML.
Copyright (C) 2000, 2001, 2002  Ministere de la culture et de la communication (France), AJLSM

Ministere de la culture et de la communication,
Mission de la recherche et de la technologie
3 rue de Valois, 75042 Paris Cedex 01 (France)
mrt@culture.fr, michel.bottin@culture.fr

AJLSM, 17, rue Vital Carles, 33000 Bordeaux (France)
sevigny@ajlsm.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
or connect to:
http://www.fsf.org/copyleft/gpl.html
*/
package fr.gouv.culture.sdx.documentbase;

import org.apache.excalibur.source.SourceValidity;

/**
 * A source validity for a document base.
 *
 * <p>The source is not valid is the document base has been updated.</p>
 * <p>This is used to cache pages when document base has not been updated.</p>
 */
public class DocumentBaseSourceValidity implements SourceValidity {

	/** The timestamp of the document base */
	private long timestamp;

	/**
	 * Creates a source validity from a document base.
	 *
	 * @param d		The document base.
	 */
	public DocumentBaseSourceValidity(DocumentBase d) {
		// Simply keeps a reference to the DB
		this.timestamp = d.lastModificationDate().getTime();
	}

	/**
	 * Checks to see if it is valid. Always return 0 (= don't know).
	 */
	public int isValid() {
		return 0;
	}

	/**
	 * Checks to see if it is valid agains a new validity.
	 *
	 * @param newValidity	The new validity object.
	 */
	public int isValid(SourceValidity newValidity) {
		if ( newValidity instanceof DocumentBaseSourceValidity ) {
			if ( timestamp == ((DocumentBaseSourceValidity)newValidity).getTimeStamp() ) return 1;
			else return -1;
		}
		else return -1;	// Wrong object, not valid anymore... (Excalibur classes do that...)
	}

	/**
	 * Returns the current timestamp
	 */
	public long getTimeStamp() {
		return timestamp;
	}

}
