/*
SDX: Documentary System in XML.
Copyright (C) 2000, 2001, 2002  Ministere de la culture et de la communication (France), AJLSM

Ministere de la culture et de la communication,
Mission de la recherche et de la technologie
3 rue de Valois, 75042 Paris Cedex 01 (France)
mrt@culture.fr, michel.bottin@culture.fr

AJLSM, 17, rue Vital Carles, 33000 Bordeaux (France)
sevigny@ajlsm.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
or connect to:
http://www.fsf.org/copyleft/gpl.html
*/
package fr.gouv.culture.sdx.oai;

import fr.gouv.culture.oai.OAIHarvester;
import fr.gouv.culture.oai.OAIObject;
import fr.gouv.culture.sdx.utils.save.Saveable;
import fr.gouv.culture.util.apache.avalon.cornerstone.services.scheduler.Target;

public interface DocumentBaseOAIHarvester extends OAIHarvester, Target, Saveable {

	interface ConfigurationNode {

		/**Configuration node name*/
		String OAI_DATA_PROVIDERS = "oai-data-providers";
		/**Configuration node name*/
		String OAI_VERB = "oai-verb";
		/**Configuration node name*/
		String OAI_IDENTIFIER = "oai-identifier";
		/**Configuration node name*/
		String NAME = "name";
		/**Configuration node name*/
		String ADMIN_EMAIL = OAIObject.Node.Name.ADMIN_EMAIL;
		/**Configuration node name*/
		String USER_AGENT = "userAgent";
		/**Configuration node name*/
		String URL = "url";
		/**Configuration node name*/
		String GRANULARITY = "granularity";
		/**Configuration node name*/
		String UPDATE = "update";
		/**Configuration node name*/
	    String ATTRIBUTE_USE_LAST_HARVEST_DATE = "useLastHarvestDate";
		/**Configuration node name*/
		String METADATA_PREFIX = OAIObject.Node.Name.METADATA_PREFIX;
		/**Configuration node name*/
		String SDX_REPOSITORY = "sdxRepository";
		/**Configuration node name*/
		String FROM = "from";
		/**Configuration node name*/
		String UNTIL = "until";
		/**Configuration node name*/
		String SET = "set";
		String KEEP_DELETED_RECORDS = "keepDeletedRecords";
		/**Configuration node name*/
		String NO_RECORDS_PER_BATCH = "noRecordsPerBatch";
	}
}
