/*
SDX: Documentary System in XML.
Copyright (C) 2000, 2001, 2002  Ministere de la culture et de la communication (France), AJLSM

Ministere de la culture et de la communication,
Mission de la recherche et de la technologie
3 rue de Valois, 75042 Paris Cedex 01 (France)
mrt@culture.fr, michel.bottin@culture.fr

AJLSM, 17, rue Vital Carles, 33000 Bordeaux (France)
sevigny@ajlsm.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
or connect to:
http://www.fsf.org/copyleft/gpl.html
*/

package fr.gouv.culture.sdx.pipeline;

import fr.gouv.culture.sdx.exception.SDXException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.logger.Logger;

/**
 * A simple extension of AbstractPipeline.
 * <p>This pipeline allows query results to pass through a sax filter ({@link GetDocumentsTransformation}).
 * In this pipeline, a list of applications is necessary for the aforementioned sax filter.
 */
public class DeleteResultsPipeline extends GenericPipeline {

    private DeleteResultsTransformation drt = new DeleteResultsTransformation();

    public DeleteResultsPipeline() throws SDXException {
        this.addTransformation(drt);
    }

    /** Sets the super.getLog() for the pipeline
     *
     * @param logger   The super.getLog() created from Cocoon's logkit.
     */
    public void enableLogging(Logger logger) {
        super.enableLogging(logger);
        drt.enableLogging(logger);
    }

    /**
     * Sets the pipeline's ServiceManager.
     *
     * @param manager  The ServiceManager to use.
     * @throws ServiceException
     */
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        drt.service(manager);
    }

    /**Set's the id of the application from which the document's should be deleted
     *
     * @param appId
     */
    public void setApplicationId(String appId) throws SDXException {
        this.drt.setApplicationId(appId);
    }

}
