/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.oai;

import fr.gouv.culture.oai.AbstractOAIRepository;
import fr.gouv.culture.oai.OAIRequest;
import fr.gouv.culture.oai.util.OAIUtilities;
import fr.gouv.culture.sdx.documentbase.DocumentBase;
import fr.gouv.culture.sdx.documentbase.IDGenerator;
import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.oai.DocumentBaseOAIRepository;
import fr.gouv.culture.sdx.utils.Utilities;
import fr.gouv.culture.sdx.utils.configuration.ConfigurationUtils;
import fr.gouv.culture.sdx.utils.database.Database;
import fr.gouv.culture.sdx.utils.database.DatabaseBacked;
import fr.gouv.culture.sdx.utils.database.DatabaseEntity;
import fr.gouv.culture.sdx.utils.logging.LoggingUtils;
import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.DefaultContext;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.environment.Request;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.impl.FileSource;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class AbstractDocumentBaseOAIRepository
extends AbstractOAIRepository
implements DocumentBaseOAIRepository {
    protected ServiceManager manager = null;
    protected DefaultContext context = null;
    protected DocumentBase documentBase = null;
    protected Database _database = null;
    protected String documentBaseId = null;
    protected int numRecordsPerResponse = 1000;
    protected IDGenerator resumptionTokenIdGen = null;
    protected String externalIdPrefix = null;
    protected String id = null;
    protected boolean isDefault = false;
    public static final String PARAMETER_NAME_SDX_FIELD = "sdxFieldName";
    public static final String PARAMETER_NAME_SET_NAME = "setName";
    public static final String PARAMETER_NAME_SET_SPEC = "setSpec";

    public void service(ServiceManager serviceManager) throws ServiceException {
        this.manager = serviceManager;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        ConfigurationUtils.checkConfiguration(configuration);
        this.configureAdminEmails(configuration);
        this.repositoryName = configuration.getAttribute("name");
        this.numRecordsPerResponse = configuration.getAttributeAsInteger("noPerResponse", 1000);
        this.configureBaseURL(configuration);
        this.configureId(configuration);
        this.configureDefault(configuration);
        this.configureExternalIdPrefix(configuration);
        this.configureDescription(configuration);
        this.configureDatabase(configuration);
        this.configureResumptionTokenIDGenerator(configuration);
    }

    protected void configureId(Configuration configuration) throws ConfigurationException {
        String str = configuration.getAttribute("id", this.documentBase.getOAIRepositoriesSize() + "");
        LoggingUtils.logDebug(this.logger, "Configures oai repository id: " + str);
        if (Utilities.checkString(str)) {
            this.id = str;
        }
    }

    protected void configureDefault(Configuration configuration) throws ConfigurationException {
        this.isDefault = configuration.getAttributeAsBoolean("default", false);
        if (!this.isDefault && this.documentBase.getOAIRepositoriesSize() == 0) {
            this.setDefault();
        }
        LoggingUtils.logDebug(this.logger, "Configures oai repository default flag: " + this.isDefault);
    }

    public void setDefault() {
        this.isDefault = true;
    }

    public void unsetDefault() {
        this.isDefault = false;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    protected void configureExternalIdPrefix(Configuration configuration) throws ConfigurationException {
        String str = configuration.getAttribute("oai-id-prefix", null);
        if (Utilities.checkString(str)) {
            this.externalIdPrefix = str + (str.endsWith(":") ? "" : ":");
        } else {
            String endSub;
            String scheme = "sdx";
            String beginSub = this.baseURL.indexOf("http://") != -1 ? this.baseURL.substring("http://".length()) : this.baseURL;
            String nsId = endSub = beginSub.substring(0, beginSub.indexOf("/"));
            this.externalIdPrefix = scheme + (nsId.endsWith(":") ? "" : ":") + nsId + (nsId.endsWith(":") ? "" : ":");
        }
        LoggingUtils.logDebug(this.logger, "Configures oai repository external id prefix: " + this.externalIdPrefix);
    }

    protected void configureResumptionTokenIDGenerator(Configuration configuration) throws ConfigurationException {
        this.resumptionTokenIdGen = ConfigurationUtils.configureIDGenerator(this.logger, configuration);
        this.resumptionTokenIdGen.setDatabase(this._database);
    }

    protected void configureBaseURL(Configuration configuration) throws ConfigurationException {
        this.baseURL = configuration.getAttribute("baseURL");
        LoggingUtils.logDebug(this.logger, "Configures oai repository base url: " + this.baseURL);
    }

    protected void configureDescription(Configuration configuration) throws ConfigurationException {
        Configuration descriptionConf = configuration.getChild("description", false);
        if (descriptionConf != null) {
            String src = descriptionConf.getAttribute("src");
            ConfigurationUtils.checkConfAttributeValue("src", src, descriptionConf.getLocation());
            File srcFile = null;
            try {
                srcFile = Utilities.resolveFile(null, descriptionConf.getLocation(), (Context)this.getContext(), src, false);
                src = srcFile.toURL().toExternalForm();
            }
            catch (SDXException e) {
                throw new ConfigurationException(e.getMessage(), (Throwable)((Object)e));
            }
            catch (MalformedURLException e) {
                throw new ConfigurationException(e.getMessage(), (Throwable)e);
            }
            try {
                this.description = new FileSource(src);
                this.getDescription((ContentHandler)((Object)this));
            }
            catch (SourceException e) {
                throw new ConfigurationException(e.getMessage(), (Throwable)e);
            }
            catch (MalformedURLException e) {
                throw new ConfigurationException(e.getMessage(), (Throwable)e);
            }
            catch (SAXException e) {
                throw new ConfigurationException(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void configureAdminEmails(Configuration configuration) throws ConfigurationException {
        ArrayList<String> locAdminEmailsList = new ArrayList<String>();
        String firstAdminEmail = configuration.getAttribute("adminEmail", null);
        Configuration[] locAdminEmails = configuration.getChildren("adminEmail");
        if (Utilities.checkString(firstAdminEmail)) {
            locAdminEmailsList.add(firstAdminEmail);
        }
        for (int i = 0; i < locAdminEmails.length; ++i) {
            String value;
            Configuration locAdminEmail = locAdminEmails[i];
            if (locAdminEmail == null || !Utilities.checkString(value = locAdminEmail.getValue())) continue;
            locAdminEmailsList.add(value);
        }
        if (locAdminEmailsList.size() <= 0) {
            ConfigurationUtils.checkConfAttributeValue("adminEmail", "", configuration.getLocation());
        }
        this.adminEmails = locAdminEmailsList.toArray(new String[0]);
        locAdminEmailsList.clear();
        locAdminEmailsList = null;
    }

    protected void configureDatabase(Configuration configuration) throws ConfigurationException {
        DatabaseBacked internalDb = new DatabaseBacked();
        try {
            internalDb.enableLogging(this.logger);
            internalDb.contextualize(Utilities.createNewReadOnlyContext((Context)this.getContext()));
            internalDb.service(this.manager);
            internalDb.setId(this.getRepositoryId());
            internalDb.configure(configuration);
            internalDb.init();
            this._database = internalDb.getDatabase();
        }
        catch (SDXException e) {
            throw new ConfigurationException(e.getMessage(), (Throwable)((Object)e));
        }
        catch (ServiceException e) {
            throw new ConfigurationException(e.getMessage(), (Throwable)e);
        }
        catch (ContextException e) {
            throw new ConfigurationException(e.getMessage(), (Throwable)e);
        }
    }

    protected String getRepositoryId() {
        return "sdx_oai_r_" + this.documentBaseId + "_" + this.getId();
    }

    public String getId() {
        if (this.isDefault) {
            return "default";
        }
        return this.id;
    }

    protected String buildExternalOaiId(OAIRequest request, String docId) {
        return this.buildExternalOaiId(docId);
    }

    protected String buildExternalOaiId(String docId) {
        String encoding = Utilities.getStringFromContext("sdx.encoding", (Context)this.getContext());
        String appId = Utilities.getStringFromContext("sdx.application.dirName", (Context)this.getContext());
        String suffix = Utilities.encodeURL(appId, encoding) + "/" + Utilities.encodeURL(this.documentBaseId, encoding) + "/" + Utilities.encodeURL(docId, encoding);
        LoggingUtils.logDebug(this.logger, "Builds external OAI id for " + docId + ": " + this.externalIdPrefix + suffix);
        return this.externalIdPrefix + suffix;
    }

    protected String deriveInternalSdxId(OAIRequest request, String fullOaiId) {
        return this.deriveInternalSdxId(fullOaiId);
    }

    protected String deriveInternalSdxId(String fullOaiId) {
        LoggingUtils.logDebug(this.logger, "Derives internal SDX id for " + fullOaiId);
        if (!Utilities.checkString(fullOaiId)) {
            return null;
        }
        String dummyId = "sdxDummyId";
        String dummyExternalId = this.buildExternalOaiId(dummyId);
        if (!fullOaiId.startsWith(dummyExternalId.substring(0, dummyExternalId.indexOf(dummyId)))) {
            return null;
        }
        String appId = Utilities.getStringFromContext("sdx.application.dirName", (Context)this.getContext());
        String substring = appId + "/" + this.documentBaseId + "/";
        String encoding = Utilities.getStringFromContext("sdx.encoding", (Context)this.getContext());
        int beginIdx = fullOaiId.indexOf(substring = Utilities.decodeURL(substring, encoding));
        beginIdx = beginIdx < 0 ? 0 : (beginIdx += substring.length());
        int endIdx = fullOaiId.length();
        String internalId = fullOaiId.substring(beginIdx, endIdx);
        internalId = Utilities.decodeURL(internalId, encoding);
        LoggingUtils.logDebug(this.logger, "Returns " + internalId);
        return internalId;
    }

    protected String buildUrlLocator(OAIRequest request, String docId) {
        String base;
        String requestUrl = request.getRequestURL();
        int endIdx = requestUrl.indexOf("?");
        if (endIdx < 0) {
            endIdx = requestUrl.length();
        }
        if (!(base = requestUrl.substring(0, endIdx)).endsWith("/")) {
            base = base + "/";
        }
        base = base + docId;
        LoggingUtils.logDebug(this.logger, "Builds URL locator for the doc " + docId + ": " + base);
        return base;
    }

    protected String createResumptionToken(OAIRequest request) throws SDXException {
        int cursor;
        String previousResumptionToken = request.getResumptionToken();
        DatabaseEntity rtEnt = this._database.getEntity(previousResumptionToken);
        String newResumptionToken = this.resumptionTokenIdGen.generate();
        String resultsId = "";
        Date date = OAIUtilities.Date.getUtcIso8601Date();
        String utcDate = OAIUtilities.Date.formatUtcISO8601Date(date);
        while (this._database.entityExists(newResumptionToken)) {
            newResumptionToken = this.resumptionTokenIdGen.generate();
        }
        if (rtEnt == null) {
            Enumeration paramNames;
            rtEnt = new DatabaseEntity(newResumptionToken);
            cursor = 0;
            Request cocoonRequest = request.getRequest();
            if (cocoonRequest != null && (paramNames = cocoonRequest.getParameterNames()) != null) {
                while (paramNames.hasMoreElements()) {
                    String paramName = (String)paramNames.nextElement();
                    String paramVal = cocoonRequest.getParameter(paramName);
                    if (!Utilities.checkString(paramName = OAIUtilities.normalizeHttpRequestParameterName(paramName)) || !Utilities.checkString(paramVal)) continue;
                    if ("identifier".equals(paramName)) {
                        rtEnt.addProperty(paramName, paramVal);
                        continue;
                    }
                    if ("metadataPrefix".equals(paramName)) {
                        rtEnt.addProperty(paramName, paramVal);
                        continue;
                    }
                    if ("set".equals(paramName)) {
                        rtEnt.addProperty(paramName, paramVal);
                        continue;
                    }
                    if ("from".equals(paramName)) {
                        rtEnt.addProperty(paramName, paramVal);
                        continue;
                    }
                    if ("until".equals(paramName)) {
                        rtEnt.addProperty(paramName, paramVal);
                        continue;
                    }
                    if ("resumptionToken".equals(paramName)) {
                        rtEnt.addProperty(paramName, paramVal);
                        continue;
                    }
                    if (!"verb".equals(paramName)) continue;
                    rtEnt.addProperty(paramName, paramVal);
                }
            }
            resultsId = newResumptionToken + "_results";
        } else {
            cursor = Integer.parseInt(rtEnt.getProperty("cursor")) + this.numRecordsPerResponse;
            rtEnt.setId(newResumptionToken);
            resultsId = rtEnt.getProperty("resultsId");
        }
        rtEnt.deleteProperty("cursor");
        rtEnt.deleteProperty("responseDate");
        rtEnt.addProperty("cursor", Integer.toString(cursor));
        rtEnt.addProperty("resultsId", resultsId);
        rtEnt.addProperty("responseDate", utcDate);
        if (Utilities.checkString(previousResumptionToken)) {
            this._database.delete(new DatabaseEntity(previousResumptionToken));
        }
        this._database.update(rtEnt);
        this._database.optimize();
        return newResumptionToken;
    }

    protected String getResumptionTokenCursor(String resumptionToken) {
        return this.getResumptionTokenProperty(resumptionToken, "cursor");
    }

    protected String getResumptionTokenProperty(String resumptionToken, String propertyName) {
        String propVal = null;
        try {
            DatabaseEntity ent = this._database.getEntity(resumptionToken);
            if (ent != null) {
                propVal = ent.getProperty(propertyName);
            }
        }
        catch (SDXException e) {
            LoggingUtils.logException(this.logger, (Exception)((Object)e));
        }
        return propVal;
    }
}

