/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.source.impl.validity;

import org.apache.excalibur.source.SourceValidity;

public class DelayedValidity
implements SourceValidity {
    private long delay;
    private long expires;
    private SourceValidity delegate;

    public DelayedValidity(long delay, SourceValidity validity) {
        this.delay = delay;
        this.expires = System.currentTimeMillis() + delay;
        this.delegate = validity;
    }

    public int isValid() {
        long currentTime = System.currentTimeMillis();
        if (currentTime <= this.expires) {
            return 1;
        }
        this.expires = currentTime + this.delay;
        return this.delegate.isValid();
    }

    public int isValid(SourceValidity newValidity) {
        return this.delegate.isValid(newValidity);
    }
}

