/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.pool;

import org.apache.avalon.excalibur.pool.InstrumentedResourceLimitingPool;
import org.apache.avalon.excalibur.pool.ObjectFactory;
import org.apache.avalon.excalibur.pool.Poolable;
import org.apache.avalon.excalibur.pool.Validatable;

public class ValidatedResourceLimitingPool
extends InstrumentedResourceLimitingPool {
    private boolean m_needsValidation;

    public ValidatedResourceLimitingPool(ObjectFactory factory, int max, boolean maxStrict, boolean blocking, long blockTimeout, long trimInterval) {
        super(factory, max, maxStrict, blocking, blockTimeout, trimInterval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Poolable get() throws Exception {
        Poolable poolable;
        do {
            boolean needsValidation;
            Object object = this.m_semaphore;
            synchronized (object) {
                this.m_needsValidation = true;
                poolable = super.get();
                needsValidation = this.m_needsValidation;
            }
            if (!needsValidation || this.validatePoolable(poolable)) continue;
            object = this.m_semaphore;
            synchronized (object) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Removing a " + poolable.getClass().getName() + " from the pool because it failed validation.");
                }
                this.permanentlyRemovePoolable(poolable);
                poolable = null;
            }
        } while (poolable == null);
        return poolable;
    }

    protected Poolable newPoolable() throws Exception {
        this.m_needsValidation = false;
        return super.newPoolable();
    }

    protected boolean validatePoolable(Poolable poolable) throws Exception {
        if (poolable instanceof Validatable) {
            return ((Validatable)poolable).validate();
        }
        return true;
    }
}

