/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.StringTokenizer;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DayTimeDurationValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.ValidationErrorValue;
import net.sf.saxon.value.Whitespace;
import net.sf.saxon.value.YearMonthDurationValue;

public class DurationValue
extends AtomicValue {
    protected boolean negative = false;
    protected int years = 0;
    protected int months = 0;
    protected int days = 0;
    protected int hours = 0;
    protected int minutes = 0;
    protected int seconds = 0;
    protected int microseconds = 0;
    protected boolean normalized = false;

    protected DurationValue() {
    }

    public DurationValue(boolean bl, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this(bl, n, n2, n3, n4, n5, n6, n7, BuiltInAtomicType.DURATION);
    }

    public DurationValue(boolean bl, int n, int n2, int n3, int n4, int n5, int n6, int n7, AtomicType atomicType) {
        this.negative = !bl;
        this.years = n;
        this.months = n2;
        this.days = n3;
        this.hours = n4;
        this.minutes = n5;
        this.seconds = n6;
        this.microseconds = n7;
        this.normalizeZeroDuration();
        this.normalized = n2 < 12 && n4 < 24 && n5 < 60 && n6 < 60 && n7 < 1000000;
        this.typeLabel = atomicType;
    }

    protected void normalizeZeroDuration() {
        if (this.years == 0 && this.months == 0 && this.days == 0 && this.hours == 0 && this.minutes == 0 && this.seconds == 0 && this.microseconds == 0) {
            this.negative = false;
        }
    }

    public DurationValue(CharSequence charSequence) throws XPathException {
        StringTokenizer stringTokenizer = new StringTokenizer(((Object)Whitespace.trimWhitespace(charSequence)).toString(), "-+.PYMDTHS", true);
        int n = 0;
        try {
            String string;
            if (!stringTokenizer.hasMoreElements()) {
                this.badDuration("empty string", charSequence);
            }
            if ("+".equals(string = (String)stringTokenizer.nextElement())) {
                this.badDuration("+ sign not allowed in a duration", charSequence);
            } else if ("-".equals(string)) {
                this.negative = true;
                string = (String)stringTokenizer.nextElement();
            }
            if (!"P".equals(string)) {
                this.badDuration("missing 'P'", charSequence);
            }
            int n2 = 0;
            block10: while (stringTokenizer.hasMoreElements()) {
                string = (String)stringTokenizer.nextElement();
                if ("T".equals(string)) {
                    n2 = 4;
                    if (!stringTokenizer.hasMoreElements()) {
                        this.badDuration("T must be followed by time components", charSequence);
                    }
                    string = (String)stringTokenizer.nextElement();
                }
                int n3 = Integer.parseInt(string);
                if (!stringTokenizer.hasMoreElements()) {
                    this.badDuration("missing unit letter at end", charSequence);
                }
                char c = ((String)stringTokenizer.nextElement()).charAt(0);
                switch (c) {
                    case 'Y': {
                        if (n2 > 0) {
                            this.badDuration("Y is out of sequence", charSequence);
                        }
                        this.years = n3;
                        n2 = 1;
                        ++n;
                        continue block10;
                    }
                    case 'M': {
                        if (n2 == 4 || n2 == 5) {
                            this.minutes = n3;
                            n2 = 6;
                            ++n;
                            continue block10;
                        }
                        if (n2 == 0 || n2 == 1) {
                            this.months = n3;
                            n2 = 2;
                            ++n;
                            continue block10;
                        }
                        this.badDuration("M is out of sequence", charSequence);
                    }
                    case 'D': {
                        if (n2 > 2) {
                            this.badDuration("D is out of sequence", charSequence);
                        }
                        this.days = n3;
                        n2 = 3;
                        ++n;
                        continue block10;
                    }
                    case 'H': {
                        if (n2 != 4) {
                            this.badDuration("H is out of sequence", charSequence);
                        }
                        this.hours = n3;
                        n2 = 5;
                        ++n;
                        continue block10;
                    }
                    case '.': {
                        if (n2 < 4 || n2 > 6) {
                            this.badDuration("misplaced decimal point", charSequence);
                        }
                        this.seconds = n3;
                        n2 = 7;
                        continue block10;
                    }
                    case 'S': {
                        if (n2 < 4 || n2 > 7) {
                            this.badDuration("S is out of sequence", charSequence);
                        }
                        if (n2 == 7) {
                            while (string.length() < 6) {
                                string = string + "0";
                            }
                            if (string.length() > 6) {
                                string = string.substring(0, 6);
                            }
                            this.microseconds = Integer.parseInt(string);
                        } else {
                            this.seconds = n3;
                        }
                        n2 = 8;
                        ++n;
                        continue block10;
                    }
                }
                this.badDuration("misplaced " + c, charSequence);
            }
            if (n == 0) {
                this.badDuration("Duration specifies no components", charSequence);
            }
            this.normalizeZeroDuration();
        }
        catch (NumberFormatException numberFormatException) {
            this.badDuration("non-numeric component", charSequence);
        }
        this.typeLabel = BuiltInAtomicType.DURATION;
    }

    protected void badDuration(String string, CharSequence charSequence) throws XPathException {
        DynamicError dynamicError = new DynamicError("Invalid duration value '" + charSequence + "' (" + string + ')');
        dynamicError.setErrorCode("FORG0001");
        throw dynamicError;
    }

    public AtomicValue copy(AtomicType atomicType) {
        DurationValue durationValue = new DurationValue(!this.negative, this.years, this.months, this.days, this.hours, this.minutes, this.seconds, this.microseconds);
        durationValue.typeLabel = atomicType;
        return durationValue;
    }

    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.DURATION;
    }

    public AtomicValue convertPrimitive(BuiltInAtomicType builtInAtomicType, boolean bl, XPathContext xPathContext) {
        switch (builtInAtomicType.getPrimitiveType()) {
            case 88: 
            case 518: 
            case 632: {
                return this;
            }
            case 513: {
                return new StringValue(this.getStringValueCS());
            }
            case 631: {
                return new UntypedAtomicValue(this.getStringValueCS());
            }
            case 633: {
                return YearMonthDurationValue.fromMonths((this.years * 12 + this.months) * (this.negative ? -1 : 1));
            }
            case 634: {
                try {
                    return new DayTimeDurationValue(this.negative ? -1 : 1, this.days, this.hours, this.minutes, this.seconds, this.microseconds);
                }
                catch (ValidationException validationException) {
                    return new ValidationErrorValue(validationException);
                }
            }
        }
        ValidationException validationException = new ValidationException("Cannot convert duration to " + builtInAtomicType.getDisplayName());
        validationException.setErrorCode("XPTY0004");
        validationException.setIsTypeError(true);
        return new ValidationErrorValue(validationException);
    }

    public DurationValue normalizeDuration() {
        long l = (long)this.years * 12L + (long)this.months;
        long l2 = l / 12L;
        long l3 = l % 12L;
        long l4 = ((((long)this.days * 24L + (long)this.hours) * 60L + (long)this.minutes) * 60L + (long)this.seconds) * 1000000L + (long)this.microseconds;
        int n = (int)(l4 % 1000000L);
        long l5 = l4 / 1000000L;
        long l6 = l5 % 60L;
        long l7 = l5 / 60L;
        long l8 = l7 % 60L;
        long l9 = l7 / 60L;
        long l10 = l9 % 24L;
        long l11 = l9 / 24L;
        return new DurationValue(!this.negative, (int)l2, (int)l3, (int)l11, (int)l10, (int)l8, (int)l6, n);
    }

    public int signum() {
        if (this.negative) {
            return -1;
        }
        if (this.years == 0 && this.months == 0 && this.days == 0 && this.hours == 0 && this.minutes == 0 && this.seconds == 0 && this.microseconds == 0) {
            return 0;
        }
        return 1;
    }

    public int getYears() {
        return this.years;
    }

    public int getMonths() {
        return this.months;
    }

    public int getDays() {
        return this.days;
    }

    public int getHours() {
        return this.hours;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public int getSeconds() {
        return this.seconds;
    }

    public int getMicroseconds() {
        return this.microseconds;
    }

    public String getStringValue() {
        return ((Object)this.getStringValueCS()).toString();
    }

    public CharSequence getStringValueCS() {
        if (this.years == 0 && this.months == 0 && this.days == 0 && this.hours == 0 && this.minutes == 0 && this.seconds == 0 && this.microseconds == 0) {
            return "PT0S";
        }
        if (!this.normalized) {
            return this.normalizeDuration().getStringValueCS();
        }
        FastStringBuffer fastStringBuffer = new FastStringBuffer(32);
        if (this.negative) {
            fastStringBuffer.append('-');
        }
        fastStringBuffer.append("P");
        if (this.years != 0) {
            fastStringBuffer.append(this.years + "Y");
        }
        if (this.months != 0) {
            fastStringBuffer.append(this.months + "M");
        }
        if (this.days != 0) {
            fastStringBuffer.append(this.days + "D");
        }
        if (this.hours != 0 || this.minutes != 0 || this.seconds != 0 || this.microseconds != 0) {
            fastStringBuffer.append("T");
        }
        if (this.hours != 0) {
            fastStringBuffer.append(this.hours + "H");
        }
        if (this.minutes != 0) {
            fastStringBuffer.append(this.minutes + "M");
        }
        if (this.seconds != 0 || this.microseconds != 0) {
            if (this.seconds != 0 && this.microseconds == 0) {
                fastStringBuffer.append(this.seconds + "S");
            } else {
                long l = this.seconds * 1000000 + this.microseconds;
                String string = l + "";
                if (this.seconds == 0) {
                    string = "0000000" + string;
                    string = string.substring(string.length() - 7);
                }
                fastStringBuffer.append(string.substring(0, string.length() - 6));
                fastStringBuffer.append('.');
                int n = string.length() - 1;
                while (string.charAt(n) == '0') {
                    --n;
                }
                fastStringBuffer.append(string.substring(string.length() - 6, n + 1));
                fastStringBuffer.append('S');
            }
        }
        return fastStringBuffer;
    }

    public double getLengthInSeconds() {
        double d = this.years;
        d = d * 12.0 + (double)this.months;
        d = d * 30.43684991666667 + (double)this.days;
        d = d * 24.0 + (double)this.hours;
        d = d * 60.0 + (double)this.minutes;
        d = d * 60.0 + (double)this.seconds;
        return this.negative ? -d : (d += (double)this.microseconds / 1000000.0);
    }

    public Object convertToJava(Class clazz, XPathContext xPathContext) throws XPathException {
        if (clazz.isAssignableFrom(DurationValue.class)) {
            return this;
        }
        if (clazz == String.class || clazz == CharSequence.class) {
            return this.getStringValue();
        }
        if (clazz == Object.class) {
            return this.getStringValue();
        }
        Object object = super.convertToJava(clazz, xPathContext);
        if (object == null) {
            DynamicError dynamicError = new DynamicError("Conversion of xs:duration to " + clazz.getName() + " is not supported");
            dynamicError.setXPathContext(xPathContext);
            dynamicError.setErrorCode("SXJE0003");
        }
        return object;
    }

    public AtomicValue getComponent(int n) throws XPathException {
        if (!this.normalized) {
            return this.normalizeDuration().getComponent(n);
        }
        switch (n) {
            case 1: {
                return Int64Value.makeIntegerValue(this.negative ? -this.years : this.years);
            }
            case 2: {
                return Int64Value.makeIntegerValue(this.negative ? -this.months : this.months);
            }
            case 3: {
                return Int64Value.makeIntegerValue(this.negative ? -this.days : this.days);
            }
            case 4: {
                return Int64Value.makeIntegerValue(this.negative ? -this.hours : this.hours);
            }
            case 5: {
                return Int64Value.makeIntegerValue(this.negative ? -this.minutes : this.minutes);
            }
            case 6: {
                FastStringBuffer fastStringBuffer = new FastStringBuffer(16);
                String string = "000000" + this.microseconds;
                string = string.substring(string.length() - 6);
                fastStringBuffer.append((this.negative ? "-" : "") + this.seconds + '.' + string);
                return DecimalValue.makeDecimalValue(fastStringBuffer, false);
            }
            case 12: {
                return Int64Value.makeIntegerValue(this.negative ? -this.seconds : this.seconds);
            }
            case 11: {
                return new Int64Value(this.negative ? -this.microseconds : this.microseconds);
            }
        }
        throw new IllegalArgumentException("Unknown component for duration: " + n);
    }

    public boolean equals(Object object) {
        DurationValue durationValue = (DurationValue)object;
        DurationValue durationValue2 = this.normalizeDuration();
        DurationValue durationValue3 = durationValue.normalizeDuration();
        return durationValue2.negative == durationValue3.negative && durationValue2.years == durationValue3.years && durationValue2.months == durationValue3.months && durationValue2.days == durationValue3.days && durationValue2.hours == durationValue3.hours && durationValue2.minutes == durationValue3.minutes && durationValue2.seconds == durationValue3.seconds && durationValue2.microseconds == durationValue3.microseconds;
    }

    public int hashCode() {
        return new Double(this.getLengthInSeconds()).hashCode();
    }

    public DurationValue add(DurationValue durationValue) throws XPathException {
        DynamicError dynamicError = new DynamicError("Only subtypes of xs:duration can be added");
        dynamicError.setErrorCode("XPTY0004");
        dynamicError.setIsTypeError(true);
        throw dynamicError;
    }

    public DurationValue subtract(DurationValue durationValue) throws XPathException {
        DynamicError dynamicError = new DynamicError("Only subtypes of xs:duration can be subtracted");
        dynamicError.setErrorCode("XPTY0004");
        dynamicError.setIsTypeError(true);
        throw dynamicError;
    }

    public DurationValue negate() {
        return new DurationValue(this.negative, this.years, this.months, this.days, this.hours, this.minutes, this.seconds, this.microseconds);
    }

    public DurationValue multiply(double d) throws XPathException {
        DynamicError dynamicError = new DynamicError("Only subtypes of xs:duration can be multiplied by a number");
        dynamicError.setErrorCode("XPTY0004");
        dynamicError.setIsTypeError(true);
        throw dynamicError;
    }

    public DecimalValue divide(DurationValue durationValue) throws XPathException {
        DynamicError dynamicError = new DynamicError("Only subtypes of xs:duration can be divided by another duration");
        dynamicError.setErrorCode("XPTY0004");
        dynamicError.setIsTypeError(true);
        throw dynamicError;
    }

    public Comparable getXPathComparable() {
        return null;
    }

    public Comparable getSchemaComparable() {
        return DurationValue.getSchemaComparable(this);
    }

    public static Comparable getSchemaComparable(DurationValue durationValue) {
        int n = 12 * durationValue.years + durationValue.months;
        double d = durationValue.days;
        d = d * 24.0 + (double)durationValue.hours;
        d = d * 60.0 + (double)durationValue.minutes;
        d = d * 60.0 + (double)durationValue.seconds;
        d += (double)durationValue.microseconds / 1000000.0;
        if (durationValue.negative) {
            d = -d;
            n = -n;
        }
        return new DurationValueOrderingKey(n, d);
    }

    static class DurationValueOrderingKey
    implements Comparable {
        private int months;
        private double seconds;

        public DurationValueOrderingKey(int n, double d) {
            this.months = n;
            this.seconds = d;
        }

        public int compareTo(Object object) {
            DurationValueOrderingKey durationValueOrderingKey;
            if (object instanceof DurationValueOrderingKey) {
                durationValueOrderingKey = (DurationValueOrderingKey)object;
            } else if (object instanceof YearMonthDurationValue) {
                durationValueOrderingKey = (DurationValueOrderingKey)DurationValue.getSchemaComparable((YearMonthDurationValue)object);
            } else if (object instanceof DayTimeDurationValue) {
                durationValueOrderingKey = (DurationValueOrderingKey)DurationValue.getSchemaComparable((DayTimeDurationValue)object);
            } else {
                throw new ClassCastException("Non-comparable values");
            }
            if (this.months == durationValueOrderingKey.months) {
                return Double.compare(this.seconds, durationValueOrderingKey.seconds);
            }
            if (this.seconds == durationValueOrderingKey.seconds) {
                return this.months == durationValueOrderingKey.months ? 0 : (this.months < durationValueOrderingKey.months ? -1 : 1);
            }
            double d = 86400.0;
            double d2 = (double)this.monthsToDaysMinimum(this.months) * d + this.seconds;
            double d3 = (double)this.monthsToDaysMaximum(this.months) * d + this.seconds;
            double d4 = (double)this.monthsToDaysMinimum(durationValueOrderingKey.months) * d + durationValueOrderingKey.seconds;
            double d5 = (double)this.monthsToDaysMaximum(durationValueOrderingKey.months) * d + durationValueOrderingKey.seconds;
            if (d3 < d4) {
                return -1;
            }
            if (d2 > d5) {
                return 1;
            }
            return Integer.MIN_VALUE;
        }

        private int monthsToDaysMinimum(int n) {
            if (n < 0) {
                return -this.monthsToDaysMaximum(-n);
            }
            if (n < 12) {
                int[] nArray = new int[]{0, 28, 59, 89, 120, 150, 181, 212, 242, 273, 303, 334};
                return nArray[n];
            }
            int n2 = n / 12;
            int n3 = n % 12;
            int n4 = n2 * 365 + n2 % 4 - n2 % 100 + n2 % 400 - 1;
            return n4 + this.monthsToDaysMinimum(n3);
        }

        private int monthsToDaysMaximum(int n) {
            if (n < 0) {
                return -this.monthsToDaysMinimum(-n);
            }
            if (n < 12) {
                int[] nArray = new int[]{0, 31, 62, 92, 123, 153, 184, 215, 245, 276, 306, 337};
                return nArray[n];
            }
            int n2 = n / 12;
            int n3 = n % 12;
            int n4 = n2 * 365 + n2 % 4 - n2 % 100 + n2 % 400 + 1;
            return n4 + this.monthsToDaysMaximum(n3);
        }
    }
}

