/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.source.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.excalibur.source.ModifiableSource;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceNotFoundException;
import org.apache.excalibur.source.SourceParameters;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.SourceUtil;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.TimeStampValidity;

public class HTTPClientSource
extends AbstractLogEnabled
implements ModifiableSource,
Initializable,
Parameterizable {
    public static final String POST = "POST";
    public static final String GET = "GET";
    public static final String PROXY_HOST = "proxy.host";
    public static final String PROXY_PORT = "proxy.port";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String CONTENT_LENGTH = "Content-Length";
    public static final String LAST_MODIFIED = "Last-Modified";
    private final String m_uri;
    private final Map m_parameters;
    private final HttpState m_httpState;
    private HttpClient m_client;
    private int m_proxyPort;
    private String m_proxyHost;
    private boolean m_dataValid;
    private boolean m_exists;
    private String m_mimeType;
    private long m_contentLength;
    private long m_lastModified;
    private SourceValidity m_cachedValidity;
    private long m_cachedLastModificationDate;

    public HTTPClientSource(String uri, Map parameters, HttpState httpState) throws Exception {
        this.m_uri = uri;
        this.m_parameters = parameters == null ? Collections.EMPTY_MAP : parameters;
        this.m_httpState = httpState;
    }

    public void parameterize(Parameters params) throws ParameterException {
        this.m_proxyHost = params.getParameter(PROXY_HOST, null);
        this.m_proxyPort = params.getParameterAsInteger(PROXY_PORT, -1);
        if (this.getLogger().isDebugEnabled()) {
            String message = this.m_proxyHost == null || this.m_proxyPort == -1 ? "No proxy configured" : "Configured with proxy host " + this.m_proxyHost + " port " + this.m_proxyPort;
            this.getLogger().debug(message);
        }
    }

    public void initialize() throws Exception {
        this.m_client = new HttpClient();
        if (this.m_proxyHost != null && this.m_proxyPort != -1) {
            this.m_client.getHostConfiguration().setProxy(this.m_proxyHost, this.m_proxyPort);
        }
        if (this.m_httpState != null) {
            this.m_client.setState(this.m_httpState);
        }
        this.m_dataValid = false;
    }

    private String findMethodType() {
        String method = (String)this.m_parameters.get(SourceResolver.METHOD);
        return method == null ? GET : method;
    }

    private HttpMethod getMethod() {
        String method = this.findMethodType();
        if (POST.equals(method)) {
            return this.createPostMethod(this.m_uri, (SourceParameters)this.m_parameters.get(SourceResolver.URI_PARAMETERS));
        }
        return this.createGetMethod(this.m_uri);
    }

    private PostMethod createPostMethod(String uri, SourceParameters params) {
        PostMethod post = new PostMethod(uri);
        if (params == null) {
            return post;
        }
        Iterator names = params.getParameterNames();
        while (names.hasNext()) {
            String name = (String)names.next();
            Iterator values = params.getParameterValues(name);
            while (values.hasNext()) {
                String value = (String)values.next();
                post.addParameter(new NameValuePair(name, value));
            }
        }
        return post;
    }

    private GetMethod createGetMethod(String uri) {
        GetMethod method = new GetMethod(uri);
        Iterator i = this.m_parameters.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            String value = (String)this.m_parameters.get(key);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Adding header '" + key + "', with value '" + value + "'");
            }
            method.setRequestHeader(key, value);
        }
        return method;
    }

    private HeadMethod createHeadMethod(String uri) {
        return new HeadMethod(uri);
    }

    private PutMethod createPutMethod(String uri, File uploadFile) throws IOException {
        PutMethod put = new PutMethod(uri);
        put.setRequestBody((InputStream)new FileInputStream(uploadFile.getAbsolutePath()));
        return put;
    }

    private DeleteMethod createDeleteMethod(String uri) {
        return new DeleteMethod(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateData() {
        if (!this.m_dataValid) {
            if (GET.equals(this.findMethodType())) {
                HeadMethod head = this.createHeadMethod(this.m_uri);
                try {
                    this.executeMethod((HttpMethod)head);
                    return;
                }
                catch (IOException e) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Unable to determine response data, using defaults", (Throwable)e);
                    }
                }
                finally {
                    head.releaseConnection();
                }
            }
            this.m_exists = false;
            this.m_mimeType = null;
            this.m_contentLength = -1L;
            this.m_lastModified = 0L;
            this.m_dataValid = true;
        }
    }

    protected int executeMethod(HttpMethod method) throws IOException {
        int response = this.m_client.executeMethod(method);
        this.updateExists(method);
        this.updateMimeType(method);
        this.updateContentLength(method);
        this.updateLastModified(method);
        return response;
    }

    private void updateExists(HttpMethod method) {
        int response = method.getStatusCode();
        this.m_exists = response == 200 || response == 201 || response == 206;
    }

    public boolean exists() {
        this.updateData();
        return this.m_exists;
    }

    public InputStream getInputStream() throws IOException, SourceNotFoundException {
        HttpMethod method = this.getMethod();
        int response = this.executeMethod(method);
        this.m_dataValid = true;
        if (!this.exists()) {
            StringBuffer error = new StringBuffer();
            error.append("Unable to retrieve URI: ");
            error.append(this.m_uri);
            error.append(" (");
            error.append(response);
            error.append(")");
            throw new SourceNotFoundException(error.toString());
        }
        return method.getResponseBodyAsStream();
    }

    public String getURI() {
        return this.m_uri;
    }

    public String getScheme() {
        return SourceUtil.getScheme(this.m_uri);
    }

    public SourceValidity getValidity() {
        long lm = this.getLastModified();
        if (lm > 0L) {
            if (lm == this.m_cachedLastModificationDate) {
                return this.m_cachedValidity;
            }
            this.m_cachedLastModificationDate = lm;
            this.m_cachedValidity = new TimeStampValidity(lm);
            return this.m_cachedValidity;
        }
        return null;
    }

    public void refresh() {
        this.recycle();
    }

    private void updateMimeType(HttpMethod method) {
        Header header = method.getResponseHeader(CONTENT_TYPE);
        this.m_mimeType = header == null ? null : header.getValue();
    }

    public String getMimeType() {
        this.updateData();
        return this.m_mimeType;
    }

    private void updateContentLength(HttpMethod method) {
        try {
            Header length = method.getResponseHeader(CONTENT_LENGTH);
            this.m_contentLength = length == null ? -1L : Long.parseLong(length.getValue());
        }
        catch (NumberFormatException e) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Unable to determine content length, returning -1", (Throwable)e);
            }
            this.m_contentLength = -1L;
        }
    }

    public long getContentLength() {
        this.updateData();
        return this.m_contentLength;
    }

    private void updateLastModified(HttpMethod method) {
        Header lastModified = method.getResponseHeader(LAST_MODIFIED);
        this.m_lastModified = lastModified == null ? 0L : Date.parse(lastModified.getValue());
    }

    public long getLastModified() {
        this.updateData();
        return this.m_lastModified;
    }

    private void recycle() {
        this.m_dataValid = false;
    }

    public OutputStream getOutputStream() throws IOException {
        File tempFile = File.createTempFile("httpclient", "tmp");
        return new WrappedFileOutputStream(tempFile, this.getLogger());
    }

    public void delete() throws SourceException {
        DeleteMethod delete = this.createDeleteMethod(this.m_uri);
        try {
            int response = this.executeMethod((HttpMethod)delete);
            if (!this.deleteSuccessful(response)) {
                throw new SourceException("Failed to delete " + this.m_uri + " (" + response + ")");
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(this.m_uri + " deleted (" + response + ")");
            }
        }
        catch (IOException e) {
            throw new SourceException("IOException thrown during delete", e);
        }
        finally {
            delete.releaseConnection();
        }
    }

    private boolean deleteSuccessful(int response) {
        return response == 200 || response == 202 || response == 204;
    }

    public boolean canCancel(OutputStream stream) {
        if (stream instanceof WrappedFileOutputStream) {
            return ((WrappedFileOutputStream)stream).canCancel();
        }
        throw new IllegalArgumentException("Output stream supplied was not created by this class");
    }

    public void cancel(OutputStream stream) throws IOException {
        if (!(stream instanceof WrappedFileOutputStream)) {
            throw new IllegalArgumentException("Output stream supplied was not created by this class");
        }
        ((WrappedFileOutputStream)stream).cancel();
    }

    private class WrappedFileOutputStream
    extends FileOutputStream {
        private File m_file;
        private final Logger m_logger;

        public WrappedFileOutputStream(File file, Logger logger) throws IOException {
            super(file);
            this.m_file = file;
            this.m_logger = logger;
        }

        public void close() throws IOException {
            super.close();
            if (this.m_file != null) {
                this.upload();
                this.m_file.delete();
                this.m_file = null;
            }
        }

        public boolean canCancel() {
            return this.m_file != null;
        }

        public void cancel() throws IOException {
            if (this.m_file == null) {
                throw new IOException("Stream already closed");
            }
            super.close();
            this.m_file.delete();
            this.m_file = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void upload() throws IOException {
            PutMethod uploader = HTTPClientSource.this.createPutMethod(HTTPClientSource.this.m_uri, this.m_file);
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.debug("Stream closed, writing data to " + HTTPClientSource.this.m_uri);
            }
            try {
                int response = HTTPClientSource.this.executeMethod((HttpMethod)uploader);
                if (!this.successfulUpload(response)) {
                    throw new SourceException("Write to " + HTTPClientSource.this.m_uri + " failed (" + response + ")");
                }
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug("Write to " + HTTPClientSource.this.m_uri + " succeeded (" + response + ")");
                }
            }
            finally {
                if (uploader != null) {
                    uploader.releaseConnection();
                }
            }
        }

        private boolean successfulUpload(int response) {
            return response == 200 || response == 201 || response == 204;
        }
    }
}

