/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.mail.datasource;

import java.io.IOException;
import java.io.InputStream;
import org.apache.cocoon.mail.datasource.AbstractDataSource;
import org.apache.cocoon.servlet.multipart.Part;

public class FilePartDataSource
extends AbstractDataSource {
    private Part part;

    public FilePartDataSource(Part part) {
        this(part, null, null);
    }

    public FilePartDataSource(Part part, String type, String name) {
        super(FilePartDataSource.getName(name, part), FilePartDataSource.getType(type, part));
        this.part = part;
    }

    private static String getName(String name, Part part) {
        if (FilePartDataSource.isNullOrEmpty(name) && FilePartDataSource.isNullOrEmpty(name = part.getFileName())) {
            name = "attachment";
        }
        return name;
    }

    private static String getType(String type, Part part) {
        if (FilePartDataSource.isNullOrEmpty(type) && FilePartDataSource.isNullOrEmpty(type = part.getMimeType())) {
            type = "application/octet-stream";
        }
        return type;
    }

    public InputStream getInputStream() throws IOException {
        try {
            return this.part.getInputStream();
        }
        catch (IOException e) {
            if (this.getLogger() != null) {
                this.getLogger().warn("Unable to obtain input stream for '" + this.part.getUploadName() + "'", (Throwable)e);
            }
            throw e;
        }
    }
}

