/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.portal.coplet.adapter.impl;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.portal.application.PortalApplicationConfigFactory;
import org.apache.cocoon.portal.coplet.CopletData;
import org.apache.cocoon.portal.coplet.CopletFactory;
import org.apache.cocoon.portal.coplet.CopletInstanceData;
import org.apache.cocoon.portal.coplet.adapter.impl.CachingURICopletAdapter;
import org.apache.cocoon.portal.event.Event;
import org.apache.cocoon.portal.event.impl.CopletLinkEvent;
import org.apache.cocoon.portal.layout.CompositeLayout;
import org.apache.cocoon.portal.layout.LayoutFactory;
import org.apache.cocoon.portal.layout.NamedItem;
import org.apache.cocoon.portal.layout.impl.CopletLayout;
import org.apache.cocoon.portal.profile.ProfileManager;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ApplicationCopletAdapter
extends CachingURICopletAdapter {
    public void streamContent(CopletInstanceData coplet, String uri, ContentHandler contentHandler) throws SAXException {
        try {
            super.streamContent(coplet, uri, contentHandler);
        }
        catch (SAXException se) {
            this.getLogger().error("ApplicationCopletAdapter: Exception while getting coplet resource", (Throwable)se);
            this.renderErrorContent(coplet, contentHandler);
        }
    }

    public void handleCopletInstanceEvent(Event e) {
        super.handleCopletInstanceEvent(e);
        if (e instanceof CopletLinkEvent) {
            CopletLinkEvent event = (CopletLinkEvent)e;
            CopletInstanceData coplet = (CopletInstanceData)event.getTarget();
            String link = event.getLink();
            if ("createNewCopletInstance".equals(link)) {
                try {
                    this.createNewInstance(coplet);
                }
                catch (ProcessingException ex) {
                    this.getLogger().error("Could not create new coplet instance", (Throwable)ex);
                }
            } else {
                coplet.setAttribute("link", event.getLink());
            }
        }
    }

    private void createNewInstance(CopletInstanceData coplet) throws ProcessingException {
        ProfileManager profileManager = null;
        try {
            try {
                profileManager = (ProfileManager)this.manager.lookup(ProfileManager.ROLE);
                CopletData copletData = coplet.getCopletData();
                LayoutFactory lfac = (LayoutFactory)this.manager.lookup(LayoutFactory.ROLE);
                CopletLayout copletLayout = (CopletLayout)lfac.newInstance("coplet");
                CopletFactory cfac = (CopletFactory)this.manager.lookup(CopletFactory.ROLE);
                CopletInstanceData newCoplet = cfac.newInstance(copletData);
                copletLayout.setCopletInstanceData(newCoplet);
                profileManager.register(copletLayout);
                NamedItem newItem = new NamedItem();
                newItem.setLayout(copletLayout);
                CompositeLayout tabLayout = (CompositeLayout)profileManager.getPortalLayout("portalApplications", null);
                newItem.setName(this.getNewInstanceTabName(tabLayout));
                tabLayout.addItem(newItem);
            }
            catch (ServiceException ce) {
                throw new ProcessingException("Unable to lookup profile manager.", (Throwable)ce);
            }
            catch (Exception e) {
                throw new ProcessingException(e);
            }
            Object var11_12 = null;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            this.manager.release((Object)profileManager);
            throw throwable;
        }
        this.manager.release((Object)profileManager);
    }

    private String getNewInstanceTabName(CompositeLayout layout) {
        Integer data = (Integer)layout.getAspectData("tab");
        NamedItem selectedItem = (NamedItem)layout.getItem(data);
        if (selectedItem instanceof NamedItem) {
            return selectedItem.getName();
        }
        return "New";
    }

    private void setApplicationConfig(CopletInstanceData coplet) {
        try {
            PortalApplicationConfigFactory factory = PortalApplicationConfigFactory.getInstance(this.resolver);
            coplet.setAttribute("config", factory.getConfig(coplet.getCopletData().getId()));
        }
        catch (ProcessingException pe) {
            this.getLogger().error("Error while getting portal application configuration for coplet " + coplet.getId(), (Throwable)pe);
        }
    }

    public void login(CopletInstanceData coplet) {
        this.getLogger().info("ApplicationCopletAdapter:login");
        this.setApplicationConfig(coplet);
    }

    public void logout(CopletInstanceData coplet) {
        this.getLogger().info("ApplicationCopletAdapter:logout");
    }

    protected boolean renderErrorContent(CopletInstanceData coplet, ContentHandler handler) throws SAXException {
        handler.startDocument();
        XMLUtils.startElement((ContentHandler)handler, (String)"p");
        XMLUtils.data((ContentHandler)handler, (String)("ApplicationCopletAdapter: Can't get content for coplet " + coplet.getId() + ". Look up the logs."));
        XMLUtils.endElement((ContentHandler)handler, (String)"p");
        handler.endDocument();
        return true;
    }
}

