/*
Copyright (C) 2000-2010  Ministere de la culture et de la communication (France), AJLSM
See LICENCE file
*/
package fr.gouv.culture.sdx.documentbase;

import fr.gouv.culture.sdx.search.lucene.query.LuceneIndex;

public class LuceneIndexParameters extends IndexParameters {

    /**Lucene IndexWriter parameter*/
    private int maxMergeDocs = LuceneIndex.DEFAULT_MAX_MERGE_DOCS; //Defaulted
    /**Lucene IndexWriter parameter*/
    private int mergeFactor = LuceneIndex.DEFAULT_MERGE_FACTOR; //Defaulted

    public LuceneIndexParameters() {
    }

    /**Build this object and set's the class variables for LuceneIndex writing
     *
     *@param maxMergeDocs The largest number of documents ever merged at indexation
     *@param mergeFactor   Determines how often segment indexes are merged at indexation
     *
     */
    public LuceneIndexParameters(int maxMergeDocs, int mergeFactor) {
        this.maxMergeDocs = maxMergeDocs;
        this.mergeFactor = mergeFactor;
    }

    /**Get's the merge factor*/
    public int getMergeFactor() {
        return mergeFactor;
    }

    /**Set's the merge factor*/
    public void setMergeFactor(int mergeFactor) {
        this.mergeFactor = mergeFactor;
    }

    /**Get's the max merge docs value*/
    public int getMaxMergeDocs() {
        return maxMergeDocs;
    }

    /**Set's the max merge docs value*/
    public void setMaxMergeDocs(int maxMergeDocs) {
        this.maxMergeDocs = maxMergeDocs;
    }

}
