/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.portal.transformation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.wrapper.RequestParameters;
import org.apache.cocoon.portal.LinkService;
import org.apache.cocoon.portal.coplet.CopletInstanceData;
import org.apache.cocoon.portal.event.impl.ChangeCopletInstanceAspectDataEvent;
import org.apache.cocoon.portal.event.impl.CopletJXPathEvent;
import org.apache.cocoon.portal.event.impl.JXPathEvent;
import org.apache.cocoon.portal.layout.Layout;
import org.apache.cocoon.portal.transformation.AbstractCopletTransformer;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.excalibur.xml.sax.XMLizable;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class CopletTransformer
extends AbstractCopletTransformer {
    public static final String NAMESPACE_URI = "http://apache.org/cocoon/portal/coplet/1.0";
    public static final String COPLET_ELEM = "coplet";
    public static final String SELECT_ATTR = "select";
    public static final String LINK_ELEM = "link";
    public static final String LINKS_ELEM = "links";
    public static final String CONTENT_ELEM = "content";
    protected boolean insideLinks;
    protected List collectedEvents = new ArrayList();
    protected XMLizable content;

    public CopletTransformer() {
        this.defaultNamespaceURI = NAMESPACE_URI;
    }

    public void setupTransforming() throws IOException, ProcessingException, SAXException {
        super.setupTransforming();
        this.insideLinks = false;
        this.content = null;
        this.collectedEvents.clear();
    }

    public void startTransformingElement(String uri, String name, String raw, Attributes attr) throws ProcessingException, IOException, SAXException {
        if (name.equals(COPLET_ELEM)) {
            String expression = attr.getValue(SELECT_ATTR);
            if (expression == null) {
                throw new ProcessingException("Attribute select must be spcified.");
            }
            CopletInstanceData cid = this.getCopletInstanceData();
            JXPathContext jxpathContext = JXPathContext.newContext((Object)cid);
            Object object = jxpathContext.getValue(expression);
            if (object == null) {
                throw new ProcessingException("Could not find value for expression " + expression);
            }
        } else if (name.equals(LINK_ELEM)) {
            LinkService linkService = this.getPortalService().getComponentManager().getLinkService();
            String format = attr.getValue("format");
            AttributesImpl newAttrs = new AttributesImpl();
            newAttrs.setAttributes(attr);
            newAttrs.removeAttribute("format");
            if (attr.getValue("href") != null) {
                CopletInstanceData cid = this.getCopletInstanceData();
                ChangeCopletInstanceAspectDataEvent event = new ChangeCopletInstanceAspectDataEvent(cid, null, null);
                String value = linkService.getLinkURI(event);
                value = value.indexOf(63) == -1 ? value + '?' + attr.getValue("href") : value + '&' + attr.getValue("href");
                newAttrs.removeAttribute("href");
                this.output(value, format, newAttrs);
            } else {
                String path = attr.getValue("path");
                String value = attr.getValue("value");
                newAttrs.removeAttribute("path");
                newAttrs.removeAttribute("value");
                JXPathEvent event = null;
                if (attr.getValue("layout") != null) {
                    newAttrs.removeAttribute("layout");
                    String layoutId = attr.getValue("layout");
                    Layout layout = this.getPortalService().getComponentManager().getProfileManager().getPortalLayout(null, layoutId);
                    if (layout != null) {
                        event = new JXPathEvent(layout, path, value);
                    }
                } else {
                    String copletId = attr.getValue(COPLET_ELEM);
                    newAttrs.removeAttribute(COPLET_ELEM);
                    CopletInstanceData cid = this.getCopletInstanceData(copletId);
                    if (cid != null) {
                        event = new CopletJXPathEvent(cid, path, (Object)value);
                    }
                }
                if (this.insideLinks) {
                    if (event != null) {
                        this.collectedEvents.add(event);
                    }
                } else {
                    String href = linkService.getLinkURI(event);
                    this.output(href, format, newAttrs);
                }
            }
        } else if (name.equals(LINKS_ELEM)) {
            this.insideLinks = true;
            String format = attr.getValue("format");
            if (format == null) {
                format = "html-link";
            }
            this.stack.push(format);
        } else if (name.equals(CONTENT_ELEM) && this.insideLinks) {
            this.startSAXRecording();
        } else {
            super.startTransformingElement(uri, name, raw, attr);
        }
    }

    public void endTransformingElement(String uri, String name, String raw) throws ProcessingException, IOException, SAXException {
        if (name.equals(LINK_ELEM)) {
            String elem;
            if (!this.insideLinks && (elem = (String)this.stack.pop()).length() > 0) {
                this.sendEndElementEvent(elem);
            }
        } else if (name.equals(LINKS_ELEM)) {
            String elem;
            this.insideLinks = false;
            String format = (String)this.stack.pop();
            LinkService linkService = this.getPortalService().getComponentManager().getLinkService();
            String href = linkService.getLinkURI(this.collectedEvents);
            AttributesImpl newAttrs = new AttributesImpl();
            this.output(href, format, newAttrs);
            this.collectedEvents.clear();
            if (this.content != null) {
                this.content.toSAX(this.contentHandler);
                this.content = null;
            }
            if ((elem = (String)this.stack.pop()).length() > 0) {
                this.sendEndElementEvent(elem);
            }
        } else if (name.equals(CONTENT_ELEM) && this.insideLinks) {
            this.content = this.endSAXRecording();
        } else if (!name.equals(COPLET_ELEM)) {
            super.endTransformingElement(uri, name, raw);
        }
    }

    protected void output(String uri, String format, AttributesImpl newAttrs) throws SAXException {
        if (format == null) {
            format = "html-link";
        }
        if ("html-link".equals(format)) {
            newAttrs.addCDATAAttribute("href", uri);
            this.sendStartElementEvent("a", (Attributes)newAttrs);
            this.stack.push("a");
        } else if ("html-form".equals(format)) {
            int pos;
            boolean addParametersAsHiddenFields = false;
            String parameters = null;
            if (newAttrs.getValue("enctype") != null && (pos = uri.indexOf(63)) != -1) {
                parameters = uri.substring(pos + 1);
                uri = uri.substring(0, pos);
                addParametersAsHiddenFields = true;
            }
            newAttrs.addCDATAAttribute("action", uri);
            this.sendStartElementEvent("form", (Attributes)newAttrs);
            this.stack.push("form");
            if (addParametersAsHiddenFields) {
                RequestParameters pars = new RequestParameters(parameters);
                Enumeration enumeration = pars.getParameterNames();
                while (enumeration.hasMoreElements()) {
                    String pName = (String)enumeration.nextElement();
                    String pValue = pars.getParameter(pName);
                    AttributesImpl hiddenAttrs = new AttributesImpl();
                    hiddenAttrs.addCDATAAttribute("type", "hidden");
                    hiddenAttrs.addCDATAAttribute("name", pName);
                    hiddenAttrs.addCDATAAttribute("value", pValue);
                    this.startElement("", "input", "input", (Attributes)hiddenAttrs);
                    this.endElement("", "input", "input");
                }
            }
        } else if ("text".equals(format)) {
            this.sendTextEvent(uri);
            this.stack.push("");
        } else if ("parameters".equals(format)) {
            String value = uri.substring(uri.indexOf(63) + 1);
            this.sendTextEvent(value);
            this.stack.push("");
        } else {
            newAttrs.addCDATAAttribute("href", uri);
            this.sendStartElementEvent(LINK_ELEM, (Attributes)newAttrs);
            this.stack.push(LINK_ELEM);
        }
    }
}

